/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: icon.c,v 1.9.2.1 96/02/22 13:59:17 leon Exp Locker: leon $ */

#include "icon.h"
#include "pcache.h"
#include "anchor.h"
#include "TagP.h"

/* type desc */
KlType KnIconClass;





/* init class fields and call super class Init proc */
void
KnIconInit(KnIcon icon, Widget knvas, KnO parent, char *name, 
	 KnPosition x, KnPosition y)
{
    PCacheAttributesStruct values;
    KnO anchor;
    Cardinal i, l;
    int ax, ay, trash;
    XpmExtension *ext;

    icon->name = XtNewString(name);
    values.valuemask = 0;
    PCachePreload(icon->name, XtScreen(knvas), &values);

/* TEST HERE IF THE PIXMAP WAS FOUND OR NOT */
    
    KnRectInit((KnRect)icon, knvas, parent, x, y,
	       values.width, values.height);
    icon->anchors = KlListNMake(0);
    KlIncRef(icon->anchors);
    ext = values.extensions;
    for(i = 0; i < values.nextensions; i++) {
	if(!strcmp(ext[i].name, "Ports")) {
	    for(l = 0; l < ext[i].nlines; l++) {
		sscanf(ext[i].lines[l], "%d %d %d ", &trash, &ax, &ay);
		anchor = KnCreateAnchor(knvas, parent, x+ax, y+ay, False);
		KlListAppend(icon->anchors, (KlO)anchor);
		KlListAppend(((KnAnchor)anchor)->links, (KlO)icon);
	    }
	}
    }
}

void
KnIconFree(KnIcon icon)
{
    /* PCacheRelease is not yet implemented */
#define PCacheRelease(s)
    PCacheRelease(icon->name);
    XtFree(icon->name);
    KnOFree((KnO)icon);		/* need a send_super here */
}



/* allocates storage space for a new KnIcon object */
KnO
KnCreateIcon(Widget knvas, KnO parent, char *name, KnPosition x, KnPosition y)
{  
    KnIcon icon;
    icon =  (KnIcon)KlOMake(KnIconClass);
    KnIconInit(icon, knvas, parent, name, x, y);
    return (KnO)icon;
}


void
KnIconCopyFields(KnIcon new, KnIcon old)
{
    KnRectCopyFields((KnRect)new, (KnRect)old);
    new->name = XtNewString(old->name);
}




extern Pixmap KnvasGetStipple(Widget w);



extern void
KnvasSetClipRegion(Widget w, KnRegion r);


void
KnIconDraw(KnIcon icon, KnDrawingContext ct, Transformer tf)
{

    Transformer t;    
    XPoint points[4];
    XRectangle box;
    PCachePixmap image;
    PCacheAttributesStruct values;
    TagObject tag;
    tag = (TagObject)KnGetTag(ct->w, (KnO)icon);

    icon->flags &= ~KnCLEARED_FLAG;
    t = tf;
    points[0].x = points[3].x = icon->x;
    points[1].x = points[2].x = icon->x + icon->width;
    points[0].y = points[1].y = icon->y;
    points[2].y = points[3].y = icon->height + icon->y;


    if(t) {
	TransformerTransformPointList(t, points, 4, points);
    }
    GetBoundingBox(points, 4, &box);
    if((box.width <= 0) || (box.height <= 0)) {
	/* do not draw a zero sized pixmap */
	return;
    }

    /* WARNING: we must get the icon size BEFORE adding extra space for
       shadow. values will now hold the REAL pixmap size */
    values.valuemask = PCACHE_SIZE;
    values.width = box.width;
    values.height = box.height;
    
#ifdef LOOK3D
    if(tag->tag.shadowThickness) {
	box.width += tag->tag.shadowThickness;
	box.height += tag->tag.shadowThickness;
    }
#endif /* LOOK3D */
    if(KnRectInRegion(ct->clip, box.x, box.y, 
		     box.width, box.height)) {

	if(NULL != tag->tag.sym) {
	    values.valuemask |= PCACHE_SYM_COLORS;
	    values.symcolors = tag->tag.sym->colors;
	    values.nsymcolors = tag->tag.sym->n;
	}
	image = PCacheGetPixmap(icon->name, XtScreen(ct->w), &values);
#ifdef LOOK3D
	if(tag->tag.shadowThickness) {
	    /* here, we draw the cast shadow */
	    /* OPTIMIZE HERE: use XChangeGC */
	    XSetClipOrigin(ct->dpy, tag->tag.gc, 
			   box.x+tag->tag.shadowThickness,
			   box.y+tag->tag.shadowThickness);
	    XSetClipMask(ct->dpy, tag->tag.gc, image->mask);
	    XSetForeground(ct->dpy, tag->tag.gc,
			   BlackPixel(ct->dpy, 0));
	    XSetStipple(ct->dpy, tag->tag.gc, KnvasGetStipple(ct->w));
	    XSetTSOrigin(ct->dpy, tag->tag.gc, 
			   box.x+tag->tag.shadowThickness,
			   box.y+tag->tag.shadowThickness);
	    XSetFillStyle(ct->dpy, tag->tag.gc, FillStippled);

	    /* we translate the shadow, but pixmap size do not change: USE
               values size */
	    XFillRectangle(ct->dpy, ct->win, tag->tag.gc, 
			   box.x+tag->tag.shadowThickness,
			   box.y+tag->tag.shadowThickness, 
			   values.width, values.height);
	    XSetFillStyle(ct->dpy, tag->tag.gc, FillSolid);
	    XSetForeground(ct->dpy, tag->tag.gc, tag->tag.foreground);
	}
#endif /* LOOK3D */
	XSetClipOrigin(ct->dpy, tag->tag.gc, 
		       box.x, box.y);
	XSetClipMask(ct->dpy, tag->tag.gc, image->mask);
	XCopyArea(ct->dpy, image->pixmap, ct->win,
		  tag->tag.gc, 0, 0, values.width, values.height, 
		  box.x, box.y);
	if(tag->tag.clipped) {
	    /* extend the clip region to contain the whole pixmap, else we may
	       redraw the whole pixmap and only a part of another object.
	       Then restore Clip Region */
	    KnUnionRectWithRegion(&box, ct->clip, ct->clip);
	    KnvasSetClipRegion(ct->w, ct->clip);
	}
	else {
	    XSetClipMask(ct->dpy, tag->tag.gc, 0);
	}
	if(DrawSelection(icon))
	    KnDrawSelectedBox(tag, ct, &box);
    }
}


void
KnIconImport()
{
    /* no new selector */
}



/* class initializations for KnIcon objects
 * 
 * returns: 
 */
void
KnIconClassInitialize()
{
     /* declare  type */
    KlDeclareSubType(&KnIconClass, "KnIcon", KnRectClass, sizeof(struct KnIconStruct));

    /* declare methods */
    KlDeclareMethod(KnIconClass, KlSelFree, KnIconFree);
    KlDeclareMethod(KnIconClass, KlSelMake, KnCreateIcon);
    KlDeclareMethod(KnIconClass, KnOSelCopyFields, KnIconCopyFields);
    KlDeclareMethod(KnIconClass, KnOSelDraw, KnIconDraw);
}
