/* $Id: hash.h,v 1.3 95/07/28 15:22:53 leon Exp $ */
/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */

/***************************************************************************
 * khash.h
 *
 * Simple hash table management functions.
 ***************************************************************************/



#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_


#include <Kn/compat.h>

typedef struct _KnHashslot {
    struct _KnHashslot 	*next ;		/* collision handling */
    char *item;
    void		*value ;		/* item at this entry */
} KnHashslotRec, *KnHashslot ;

typedef struct _KnHashtable {
    unsigned long	(*hash_fct)() ;	/* hash function on those items */
    int			(*cmp_fct)() ;	/* compare function on those items */
    unsigned int	size ;		/* # of entries in table */
    unsigned int	item_count ;	/* # of items actually stored */
    unsigned int	mode ;		/* mode of the hashtable */
    KnHashslot		*slots ;	/* table of slots */
    KnHashslot		current_slot ;	/* current lookup value (FindNext) */
} KnHashtableRec, *KnHashtable ;

/*
 * Various defines for the hashtable 'mode' field :
 */

#define HASH_OVERRIDE		1

/*
 * Macros to access slots :
 */

#define KnHashthableSize(h)	 ((h)->size)
#define KnHashtableCount(h)	 ((h)->item_count)

#define KnHashtableOverrideMode(h) ((h)->mode |= HASH_OVERRIDE)

/*
 * Prototypes :
 */

KnHashtable KnHashtableMake ( unsigned int size );


void *KnHashtableAdd  (KnHashtable hashtable, char *item, void *value) ;
void *KnHashtableRemove (KnHashtable hashtable, char *item, void *value) ;
void *KnHashtableFind (KnHashtable hashtable, char *item);



#endif /* _HASHTABLE_H_ */

