/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: arc.h,v 1.4 95/09/25 14:56:13 leon Exp $ */
#ifndef __ARC_H
#define __ARC_H

#include <Kn/kno.h>


#ifdef __cplusplus
extern "C" {
#endif

extern void KnArcImport();
extern void KnArcClassInitialize();

#define KnArcPart\
    KnOPart;\
    Position width;\
    Position height;\
    Dimension start;\
    Dimension angle


typedef struct KnArcStruct {
    KnArcPart;
} *KnArc;



/* The Arc Class
   
 * INHERITS: KnO
 
 * OVERRIDES:

- KnOSelDraw
- KnOSelClear
- KnOSelContains
- KnOSelBoundingBox
- KnOSelCenter
- KnOSelSize
 
 * FIELDS: new fields defined in the KnRect class are:
- width: the arc's width
- height: the arc's height

 * DESCRIPTION

 * Define an arc object whose top left corner is (x, y) and size is (width,
 * height). This is in fact an ellipsis, if width receive a different value
 * from height. The arc may be translated, zoomed, using the standard KnO
 * methods. The object is drawn as a arc, using lineWidth and foreground from
 * its tag.

 * WARNING: A Arc may not be rotated.

 * USE: class writing */
extern KlType KnArcClass;




#define KnFArcPart\
    KnArcPart


typedef struct KnFArcStruct {
    KnFArcPart;
} *KnFArc;




/* The Filled Arc Class
   
 * INHERITS: KnArc
 
 * OVERRIDES:
- KnSelDraw 
 
 * FIELDS: no new field defined

 * DESCRIPTION

 * Define a filled arc object whose top left corner is (x, y) and size is
 * (width, height). This is in fact an ellipsis, if width receive a different
 * value from height. The arc may be translated, zoomed, using the standard KnO
 * methods. The object is drawn as a filled arc, using lineWidth and foreground
 * from its tag.

 * WARNING: A KnFArc may not be rotated.

 * USE: class writing
 */
extern KlType KnFArcClass;




/* Builds a new KnArc Object
   
 * This is KnArc class constructor. It builds a new KnArc object, that will be
 * drawn as a arc, whose left corner coordinates are (x,y) and size is width x
 * height. Position and size are given in the parent's coodinates system. The
 * 'start' parameter is the start angle used to draw the arc; the 'angle'
 * parameter gives tha arc's angle. Both are given in degrees. The newly
 * created object gets its parent's tag and has no defualt behavior.

 * WARNING: rotate has no effect on a arc

 * USE: application programming.
 
 * returns: The newly created KnArc */
KnO
KnCreateArc(Widget knvas,	/* ignored. required for consistency. */
	     KnO parent,	/* object's parent */
	     KnPosition x,	/* x top left coordinate of the arc's
				   bounding box */ 
	     KnPosition y,	/* y top left coordinate of the arc's
				   bounding box */
	     KnDimension width,	/* arc's width */
	     KnDimension height,	/* arc's height */
	     KnDimension start,	/* arc's starting angle */
	     KnDimension angle);	/* arc's angle */



/* Builds a new Circle Object

 * It builds a new KnArc object, whose 'start' value is 0 and 'angle' value is
 * 360 (so drawn as a circle), whose left corner coordinates are (x,y) and size
 * is width x height. Position and size are given in the parent's coodinates
 * system. The newly created object gets its parent's tag and has no defualt
 * behavior.

 * USE: application programming.
 
 * returns: The newly created KnArc
 */
KnO
KnCreateCircle(Widget knvas,	/* ignored. required for consistency. */
	     KnO parent,	/* object's parent */
	     KnPosition x,	/* x top left coordinate of the circle's
				   bounding box */ 
	     KnPosition y,	/* y top left coordinate of the circle's
				   bounding box */
	     KnDimension width,	/* circle's width */
	     KnDimension height);	/* circle's height */



/* Builds a new KnFArc Object
   
 * This is KnFArc class constructor. It builds a new KnFArc object, that will
 * be drawn as a filled arc, whose left corner coordinates are (x,y) and size
 * is width x height. Position and size are given in the parent's coodinates
 * system. The 'start' parameter is the start angle used to draw the arc; the
 * 'angle' parameter gives tha arc's angle. Both are given in degrees. The
 * newly created object gets its parent's tag and has no defualt behavior.

 * WARNING: rotate has no effect on a filled arc

 * USE: application programming.
 
 * returns: The newly created KnFArc*/
KnO
KnCreateFArc(Widget knvas,	/* ignored. required for consistency. */
	     KnO parent,	/* object's parent */
	     KnPosition x,	/* x top left coordinate of the arc's
				   bounding box */ 
	     KnPosition y,	/* y top left coordinate of the arc's
				   bounding box */
	     KnDimension width,	/* arc's width */
	     KnDimension height, /* arc's height */
	     KnDimension start,	/* arc's start angle (Degrees) */
	     KnDimension angle);	/* arc's angle value (Degrees)*/




/* Builds a new Filled Circle Object

 * It builds a new KnFArc object, whose 'start' value is 0 and 'angle' value is
 * 360 (so drawn as a circle), whose left corner coordinates are (x,y) and size
 * is width x height. Position and size are given in the parent's coodinates
 * system. The newly created object gets its parent's tag and has no defualt
 * behavior.

 * USE: application programming.
 
 * returns: The newly created KnFArc
 */
KnO
KnCreateFCircle(Widget knvas,	/* ignored. required for consistency. */
	     KnO parent,	/* object's parent */
	     KnPosition x,	/* x top left coordinate of the circle's
				   bounding box */ 
	     KnPosition y,	/* y top left coordinate of the circle's
				   bounding box */
	     KnDimension width,	/* circle's width */
	     KnDimension height); /* circle's height */




/* KnArc Initializer

 * Initialize the KnArc fields according to the parameters. This must be
 * called by any KnArc sub-class. This will call the KnO Initializer before
 * initializing the specific KnArc fields. The new KnArc fields are:

-  c->width = width;
-  c->height = height;

 * USE: class writing.
 
 * returns: 
 */
void
KnArcInit(KnArc c,		/* the graphical object */
	  Widget knvas,		/* a knvas widget */
	  KnO parent,		/* object's parent */
	  KnPosition x,		/* x top left coordinate of the arc's bounding
				   box */
	  KnPosition y,		/* y top left coordinate of the arc's
				   bounding box */
	  KnDimension width,	/* arc's width */
	  KnDimension height,	/* arc's height */
	  KnDimension start,	/* arc's start angle (Degrees) */
	  KnDimension angle);	/* arc's angle value (Degrees) */




/* KnFArc Initializer

 * Initialize the KnFArc fields according to the parameters. This must be
 * called by any KnFArc sub-class. This will call the KnArc
 * initializer. There are no KnFArc specific fields.

 * USE: class writing. 
 
 * returns:
 */
void
KnFArcInit(KnFArc c,		/* the graphical object */
	   Widget knvas,	/* a knvas widget */
	   KnO parent,		/* object's parent */
	   KnPosition x,		/* x top left coordinate of the arc's
				   bounding box */ 
	   KnPosition y,		/* y top left coordinate of the arc's
				   bounding box */
	   KnDimension width,	/* arc's width */
	   KnDimension height,	/* arc's height */
	   KnDimension start,	/* arc's start angle (Degrees) */
	   KnDimension angle);	/* arc's angle value (Degrees) */



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __ARC_H */
