/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: anchor.h,v 1.5 95/09/25 14:56:06 leon Exp $ */
#ifndef __ANCHOR_H
#define __ANCHOR_H



#include <X11/Intrinsic.h>
#include <Kn/kno.h>

#ifdef __cplusplus
extern "C" {
#endif

/* THE TWO FUNCTIONS MUST BE PROVIDED FOR CLASS INITIALIZATION */
extern void KnAnchorImport();
extern void KnAnchorClassInitialize();

#define KnAnchorPart\
    KnOPart;\
    KlList links

    
typedef struct KnAnchorStruct {
    KnAnchorPart;
} *KnAnchor;



extern KlType KnAnchorClass;

/* THE CLASS SHOULD PROVIDE AT LEAST ONE CONSTRUCTOR */
KnO
KnCreateAnchor(Widget knvas,	/* ignored. required to be consitent with other
				   constructors */
	     KnO parent,	/* the object's parent */
	     KnPosition x,
	     KnPosition y,
	     Boolean mobile
	       );

/* THE CLASS SHOULD PROVIDE AN INITIALIZATION FUNCTION */
void
KnAnchorInit(KnAnchor obj,	/* the graphical object */
	       Widget knvas,	/* ignored. required for consistency */
	       KnO parent,	/* the object's parent */
	     KnPosition x,
	     KnPosition y,
	     Boolean mobile
	       );



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif

#endif /* __ANCHOR_H */
