/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: anchor.c,v 1.7 95/09/28 11:58:18 leon Exp $ */

#include "anchor.h"
#include "pcache.h"
#include "layer.h"
#include "TagP.h"

void
KnAnchorInit(KnAnchor obj,
	     Widget knvas,
	     KnO parent,
	     KnPosition x,
	     KnPosition y,
	     Boolean mobile)
{
    KnOInit((KnO)obj, knvas, parent, x, y);
    /* private initializations */
    obj->links = KlListNMake(0);
    KlIncRef(obj->links);
}


void
KnAnchorFree(KnAnchor a)
{
    if(a->links) {
	/* Clone object do not copy link list */
	KlDecRef(a->links);
	if(a->links->reference_count <= 1) {
	    /* list will be freed, set size to 0 to avoid DecRef on links */
	    a->links->size = 0;
	}
    }
    KnOFree((KnO)a);
}


void
KnAnchorCopyFields(KnAnchor new, KnAnchor old)
{
    KnOCopyFields((KnO)new, (KnO)old);
    new->links = NULL;
}



KnO
KnCreateAnchor(Widget knvas,
	     KnO parent,
	     KnPosition x,
	     KnPosition y,
	     Boolean mobile)
{
    KnAnchor obj;
    static KnInteractor moveI = NULL;
    
    obj = (KnAnchor)KlOMake(KnAnchorClass);
    KnAnchorInit(obj, knvas, parent, x, y, mobile);
    if(NULL == moveI) {
	moveI = (KnInteractor) KnCreateMoveInteractor(knvas, "move-anchors");
	KlIncRef(moveI);
    }
    if(mobile)
	KnSetInteractor(knvas, (KnO)obj, moveI);
    return (KnO)obj;
}


/* type desc */
KlType KnAnchorClass;

/* new selectors */
Selector KnOSelNewMethod;


/* DECLARE NEW SELECTORS HERE */
void
KnAnchorImport()
{
    
}



#define AHALFSIZE 3
#define ASIZE 7
#define ANCHOR_PIXMAP "anchor"

/* draws an anchor
   
 * If an anchor has no link, it must be visible, else visibility depends on the
 * visibleAnchors tag value.
*/
void
KnAnchorDraw(KnAnchor an, KnDrawingContext ct, Transformer tf) 
{
    PCachePixmap pix;
    Transformer t;    
    XPoint point;
    XRectangle box;
    TagObject tag;
    PCacheAttributesStruct values;
    
    an->flags &= ~KnCLEARED_FLAG;
    tag = (TagObject)KnGetTag(ct->w, (KnO)an);
    if(an->links->size > 0) {
	if(!tag->tag.visibleAnchors) return;
    }
    values.valuemask = 0;
    pix = PCacheGetPixmap(ANCHOR_PIXMAP, XtScreen(ct->w), &values);

    point.x = an->x;
    point.y = an->y;
    t = tf;
    if(t) {
	TransformerTransformPoint(t, &point, &point);
    }
    box.x = point.x-AHALFSIZE;
    box.y = point.y-AHALFSIZE;
    box.width = ASIZE;
    box.height = ASIZE;


    if(KnRectInRegion(ct->clip, box.x, box.y, 
		     box.width, box.height)) {
	XCopyArea(ct->dpy, pix->pixmap,ct->win,  tag->tag.gc,
		   0, 0, ASIZE, ASIZE, box.x, box.y);
    }
}




KnO
KnAnchorContains(KnAnchor anchor, Widget w, Int x, Int y)
{
    Boolean res;
    KnPosition rx = x, ry = y;


    if(anchor->t) {
	TransformerInvTransform(anchor->t, x, y, &rx, &ry);
    }

    res = (rx >= anchor->x-AHALFSIZE) && (rx <= anchor->x + AHALFSIZE) &&
	(ry >= anchor->y-AHALFSIZE) && (ry <= anchor->y + AHALFSIZE);
    return res ? (KnO)anchor : NULL;
}



void
KnAnchorClear(KnAnchor anchor, Widget w)
{
    XPoint points[4];

    if(anchor->flags & KnCLEARED_FLAG) return;
    points[0].x = points[3].x = anchor->x - AHALFSIZE;
    points[1].x = points[2].x = anchor->x + AHALFSIZE;
    points[0].y = points[1].y = anchor->y - AHALFSIZE;
    points[2].y = points[3].y = anchor->y + AHALFSIZE;

    KlSend_clearbox(anchor, points, 4, NULL);
}


void
KnAnchorBoundingBox(KnAnchor anchor, Widget view, XRectangle *box)
{
    XPoint points[4];

    if(anchor->flags & KnCLEARED_FLAG) return;
    points[0].x = points[3].x = anchor->x - AHALFSIZE;
    points[1].x = points[2].x = anchor->x + AHALFSIZE;
    points[0].y = points[1].y = anchor->y - AHALFSIZE;
    points[2].y = points[3].y = anchor->y + AHALFSIZE;

    KnTransformPointList(view, anchor, points, 4);
    GetBoundingBox(points, 4, box);
}



void
KnAnchorTranslate(KnAnchor anchor, Int dx, Int dy)
{
    Cardinal i;
    KnO kno;
    KnLayer layer;
    Widget w;
    /* HACK: Here, we need a widget to do the clear. but this is a work around
       and should changed properly (see the CLEARING file */
    kno = (KnO)anchor;
    while(kno->parent) kno=kno->parent;
    layer = (KnLayer)kno;
    /* kno is the layer */
    w = (Widget)layer->parents->list[0];
    
    for(i = 0; i < anchor->links->size; i++) {
	kno = (KnO)anchor->links->list[i];
	kno->flags &= ~KnCLEARED_FLAG;
	KlSend_clear(kno, w);
    }
    KnOTranslate((KnO)anchor, dx, dy);
    for(i = 0; i < anchor->links->size; i++) {
	kno = (KnO)anchor->links->list[i];
	kno->flags &= ~KnCLEARED_FLAG;
	KlSend_clear(kno, w);
    }
}


/* CLASS INITIALIZATIONS FOR KNNEWCLASS OBJECTS */
void
KnAnchorClassInitialize()
{
     /* DECLARE  TYPES */
    KlDeclareSubType(&KnAnchorClass, "KnAnchor", KnOClass, sizeof(struct KnAnchorStruct));

    /* declare methods */
    KlDeclareMethod(KnAnchorClass, KlSelFree, KnAnchorFree);
    KlDeclareMethod(KnAnchorClass, KnOSelCopyFields, KnAnchorCopyFields);
    KlDeclareMethod(KnAnchorClass, KnOSelDraw, KnAnchorDraw);
    KlDeclareMethod(KnAnchorClass, KnOSelContains, KnAnchorContains);
    KlDeclareMethod(KnAnchorClass, KnOSelClear, KnAnchorClear);
    KlDeclareMethod(KnAnchorClass, KnOSelTranslate, KnAnchorTranslate);
    KlDeclareMethod(KnAnchorClass, KnOSelBoundingBox, KnAnchorBoundingBox);

}
