/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: Tag.h,v 1.3 95/07/28 15:23:05 leon Exp $ */

/***
   NAME
     Tag
   PURPOSE
     define the Tag object class as Xt Object.
   NOTES
     
   HISTORY
     jml - Feb 1, 1995: Created.
***/

#include <X11/Intrinsic.h>
#include <X11/xpm.h>


#ifndef __TAG_H
#define __TAG_H

#ifdef __cplusplus
extern "C" {
#endif


    
#define XtNlineWidth "lineWidth"
#define XtNlineStyle "lineStyle"
#define XtNcapStyle "capStyle"
#define XtNjoinStyle "joinStyle"
#define XtNsymColors "symColors"
#define XtNvisibleAnchors "visibleAnchors"
#define XtNselectionLook "selectionLook"


#define XtCLineWidth "LineWidth"
#define XtCLineStyle "LineStyle"
#define XtCCapStyle "CapStyle"
#define XtCJoinStyle "JoinStyle"
#define XtCSymColors "SymColors"
#define XtCVisibleAnchors "VisibleAnchors"
#define XtCSelectionLook "SelectionLook"


#define XtRLineStyle "LineStyle"
#define XtRCapStyle "CapStyle"
#define XtRJoinStyle "JoinStyle"
#define XtRSymColors "SymColors"
#define XtRSelectionLook "SelectionLook"

typedef enum _SelectionLook {
    KnSELECTION_UNVISIBLE = 0,
    KnSELECTION_SIMPLE = 1,
    KnSELECTION_FANCY = 2
} SelectionLook;



typedef struct _TagClassRec *TagObjectClass;
typedef struct _TagRec *TagObject;

typedef Widget KnTag;
typedef unsigned int KnTagId;




/* The Tag Class
   
 * INHERITS: none
 
 * OVERRIDES: no method overrided
 
 * FIELDS: new fields defined in the KnTag class are:
-    Pixel foreground
-    Pixel background 
-    int line_width
-    int line_style
-    int cap_style
-    int join_style
-    XFontStruct font
-    SymColors sym
-    Boolean visibleAnchors
-    SelectionLook selectionLook
-    unsigned char shadowType
-    Dimension shadowThickness

 * DESCRIPTION

 * The KnTag class is intended to provide graphical attributes sharing between
 * graphical objects. A Graphical object (KnO) does not have fields to describe
 * its appearance, it only has a tag field and get the graphical attributes it
 * needs from the tag. The KnTag exists both to hide the Xlib Graphic Context
 * (GC) and to allow external customizations (through Xt resources) of theses
 * GCs. At build time, any KnTag will get its attributes from the display
 * resource database, exactly as widgets do it. To retrieve its resources, the
 * tag will use the path of the knvas widget it belongs to. Unlike KnOs, tags
 * are not shared between multiple views (knvases), and user has still to
 * create one tag per view, but this should disapear soon using the 'palette'
 * concept.

 * RESOURCES (Name, Class, Type, Default Value)

- XtNforeground, XtCForeground, Pixel, 1
- XtNbackground, XtCBackground, Pixel, 1
- XtNlineWidth, XtCLineWidth, int, 0
- XtNlineStyle, XtCLineStyle, int, LineSolid
- XtNcapStyle, XtCCapStyle, int, CapButt
- XtNjoinStyle, XtCJoinStyle, int, JoinMitter
- XtNfont, XtCfont, XFontStruct *, XtDefaultFont
- XtNsymColors, XtCSymColors, SymColors, NULL
- XtNvisibleAnchors, XtCVisibleAnchors, Boolean, False
- XtNselectionLook, XtCSelectionLook, SelectionLook, KnSELECTION_FANCY
- XmNshadowType, XmCShadowType, unsigned char, XmSHADOW_OUT
- XmNshadowThickness, XmCShadowThickness, unsigned char, 0

 * USE: class writing
 */
extern WidgetClass tagObjectClass;





/* Builds a new KnTag Object
   
 * This is KnTag class constructor. It builds a new KnTag object named
 * "name". The name will be used by the tag to retrieve resources from the
 * knvas's display database. The resource path of any attribute's resource
 * will be <knvas name>.<tag name>.<attribute>, so that you can give the same
 * name to two tags in different knvases and give them different resources.

 * USE: application programming.
 
 * returns: The newly created KnTag
 */
KnTag
KnCreateTag(Widget knvas,	/* knvas owning the tag */
	  String name);		/* tag's name */





#ifndef __C2MAN__
/* Builds the tag GC
   
 * This function must be called by a knvas when it is realized, so that the
 * tag can create its gc field.

 * USE: knvas writing
 
 * returns: */
#endif 
void
KnTagRealize(KnTag tag);	/* the tag object */






#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* __TAG_H */
