/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: KnvasP.h,v 1.8 95/09/25 14:55:52 leon Exp $ */
#ifndef __KNVASP_H
#define __KNVASP_H

/* set defaults for Motif widget */
#ifndef DO_ATHENA_WIDGET
#define DO_MOTIF_WIDGET
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Kn/Knvas.h>
#ifdef DO_MOTIF_WIDGET
/* set default to 3D LOOK */
#ifndef NO_RELIEF
#define LOOK3D
#endif
#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#if (XmVersion >= 1002)
#include <Xm/ManagerP.h>
#else
#include <Xm/XmP.h>
#endif /* (XmVersion >= 1002) */
#endif /* DO_MOTIF_WIDGET */


#ifdef __cplusplus
extern "C" {
#endif


typedef struct {
    int empty;
} KnvasClassPart;

#ifdef DO_MOTIF_WIDGET
typedef struct _KnvasClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart		constraint_class;
    XmManagerClassPart		manager_class;
    KnvasClassPart	knvas_class;
} KnvasClassRec;
#else
typedef struct _KnvasClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    KnvasClassPart	knvas_class;
} KnvasClassRec;
#endif

enum InteractionCursor {
    KnCENTER_CURSOR = 0,
    KnTOP_LEFT_CURSOR = 1,
    KnTOP_CURSOR = 2,
    KnTOP_RIGHT_CURSOR = 3,
    KnBOTTOM_LEFT_CURSOR = 4,
    KnBOTTOM_CURSOR = 5,
    KnBOTTOM_RIGHT_CURSOR = 6,
    KnLEFT_CURSOR = 7,
    KnRIGHT_CURSOR = 8,
    KnERROR_CURSOR = 9
};

typedef struct _KnvasPart{
    /* resources (public fields) */
    XtCallbackList interactorCallback; /* called by any interactor function */
    XtCallbackList knvasCallback; /* called by globals interactors */
    Boolean pixmapBuffering;	/* use double buffering or not */
    Boolean autoUpdate;		/* auto update on change */

    /* private fields */
    Transformer t;		/* view transformer */
    XtValueMask smask;		/* OR of all the kno masks */
    KnTag defaultTag;		/* This tag will be set on every newly created
				   object */		       
    KlList layers;		/* a view consists in a list of layers */
    KlList tags;		/* each view must have a palette of tags */
    KlList interactors;		/* each view must have a palette of tags */
    KlList sobjs;		/* selected objects */
    KnRegion clear;		/* build the region to erase */
    KlList delete;		/* obj to be deleted */
    KlList clear_tags;
    Pixmap pixmap;		/* pixmap Id when pixmapBuffering is on */
    XRectangle psize;		/* pixmap size when pixmap buffering is on */
    GC pixgc;			/* gc used to copy from pixmap to window */
    GC ghostgc;			/* gc used tod raw ghosts using XOR */
    GC selectgc;		/* gc used to draw selection handles */
    GC maskgc1;			/* used to draw clipped - depth 1 */
    GC maskgc;			/* used to draw clipped */
    int kindOfMove;		/* private to interactors */
    Boolean dispatched;		/* XEvent dispatched by an interactor ? */
    Boolean in_dispatch;	/* are we inside a dispatch proc ? */
    Cursor cursors[10];		/* cursors used by interactors */
    KnO grab;			/* object grabbing events */
    Transformer *gt;		/* each gobj has a global transformer */
    KnO target;			/* Image that is currently considered as this
				   widget */
    KnPosition lastx, lasty;	/* position of last move */
    KnPosition firstx, firsty;
#ifdef LOOK3D
    Pixmap stipple;		/* we need to build a stipple / display */
#endif
    int xmin, xmax;		/* horizontal min/max values of scrolling */
    int ymin, ymax;		/* vertical min/max values of scrolling */
    int hval, vval;
    float zoomx, zoomy;		/* keep trace of current zoom factor */
#ifdef DO_MOTIF_WIDGET    
    XmScrollBarWidget hsb;	/* the horizontal scrollbar */
    XmScrollBarWidget vsb;	/* the vertical scrollbar */
    XmScrolledWindowWidget sw;	/* the parent scrolled window */
#endif    
} KnvasPart;


#ifdef DO_MOTIF_WIDGET    
typedef struct _KnvasRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    KnvasPart	        knvas;
} KnvasRec;
#else
typedef struct _KnvasRec {
    CorePart		core;
    CompositePart	composite;
    KnvasPart	knvas;
} KnvasRec;
#endif /* DO_MOTIF_WIDGET */


extern KnvasClassRec knvasClassRec;


#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KNVASP_H */
