/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: kl_config.h,v 1.1.1.1 95/08/09 09:34:03 leon Exp $ */


/* This file contained compilation flags for use with the klone library. AS it
   is IMPORTANT that same flags are used for both making the library and using
   it, we cannot rely on external configuration */


#ifndef __KL_CONFIG_H
#define __KL_CONFIG_H





/*
 * YOU MUST ALWAYS USE STANDARD MALLOC, else it may cause problems with Xt
 */
#define USE_STANDARD_MALLOC
#define USE_DEFAULTS




#if defined(linux)
				/* Linux i386 */
#undef USE_DEFAULTS
#define LINUX

#endif




#if defined(__alpha)
				/* DEC alpha */
#undef USE_DEFAULTS
#define VOID_MALLOC
#define SYSV_TIME
#define VOID_FREE
#define VOID_SIGNALS

#endif


#if defined(sparc) || defined(__sparc__)
#if defined(__SVR4) || defined(__svr4__) || defined(SVR4)

				/* SUN - solaris */
#undef USE_DEFAULTS
#define SIMPLE_LHS
#define PROTOTYPES
#define NO_MALLOC_DECLARE

#else /* __SVR4 */
				/* sun4OS4 */
#undef USE_DEFAULTS
#define VOID_SIGNALS
#define DOUBLE_ALIGN
#define USE_IRINT

#endif
#endif



#ifndef  USE_DEFAULTS
				/* set possible defaults */
#define SIMPLE_LHS
#define VOID_SIGNALS
#endif



#endif /* __KL_CONFIG_H */
