/*
 * user.c -- Example how to use a ComboBox inside a XbaeMatrix
 * 
 * Copyright (c) 1997 Linas Vepstas
 *               linas@linas.org
 *
 * Copyright (c) 1993, 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * RWTH Aachen, Germany
 * albrecht@igpm.rwth-aachen.de
 *
 * Copyright (C) 1997 Robin D. Clark
 * Internet: rclark@cs.hmc.edu 
 *  Address: 609 8th Street 
 *           Huntington Beach, CA 92648-4632 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/LabelGP.h>
#include <Xbae/Matrix.h>
#include "ComboBox.h"


/** Looks a lot nicer when the shadow thickness is set to zero *******/
String fbRes[] = {
  "*combobox*shadowThickness:     0",
  NULL,
};

/************************************************/
  
Widget 
MakeCombo (Widget parent)
{
   Widget cellw;
   XmString str;

   cellw = XtVaCreateManagedWidget("combobox", xmComboBoxWidgetClass, parent, 
                        XmNshadowThickness, 0, /* don't draw a shadow, use bae shadows */
			XmNeditable, False,
                        XmNmarginHeight, 3,
                        XmNmarginWidth, 3,
                        XmNsquareArrow, True,
			XmNsorted, True,  
                        XmNtwmHandlingOn, True,
			NULL);
   /* Put string unordered into the combo box! They'll get sorted
    * by the box.
    */
   str = XmStringCreateLtoR("William the conquerior", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Karl der Gro\337e", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Henry VIII & his chicken band", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Louis XIV", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Louis de Funes", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Helmut Kohl", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("James Major", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("James Bond", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Billy Boy (M$ Windoze)", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0); XmStringFree(str);
   str = XmStringCreateLtoR("Francois Mitterand", XmSTRING_DEFAULT_CHARSET);
   XmComboBoxAddItem(cellw, str, 0);
   XmComboBoxSelectItem(cellw, str, False);
   XmStringFree(str);

   return cellw;
}


int 
main( int argc, char *argv[] )
{
   Widget toplevel, dialog;
   Widget cellw, reg;
   XtAppContext app;
   short colwidths [50];
   String celldata[50][50];
   String *cellarr[50];
   int i,j;
 
   for (i=0; i<50; i++) {
      colwidths[i] = 23;
   }

   /* create cell contents */
   for (i=0; i<50; i++) {
      for (j=0; j<50; j++) {
         celldata[i][j] = XtMalloc (23);
         sprintf (celldata[i][j], "Row %d Col %d", i,j);
      }
   }
   for (i=0; i<50; i++) {
      cellarr[i] = &celldata[i][0];
   }
   
   toplevel = XtVaAppInitialize( &app, "Xacc", NULL, 0,
 				 &argc, argv, fbRes,
				 NULL );

   reg = XtVaCreateWidget( "testmatrix",
                            xbaeMatrixWidgetClass,  toplevel,
                            XmNcells,               cellarr,
                            XmNfixedRows,           2,
                            XmNfixedColumns,        2,
                            XmNtrailingFixedRows,   1,
                            XmNtrailingFixedColumns,1,
                            XmNrows,                45,
                            XmNvisibleRows,         6,
                            XmNvisibleColumns,      2,
                            XmNtopRow,              12, 
                            XmNtraverseFixedCells,  True,
                            XmNfill,                True,
                            XmNcolumns,             8,
                            XmNcolumnWidths,        colwidths,
                            XmNtraverseFixedCells,  False,
                            XmNgridType,            XmGRID_SHADOW_IN,
                            XmNshadowType,          XmSHADOW_ETCHED_IN,
                            XmNcellShadowThickness, 5,  /* exaggerate for effect */

                            XmNverticalScrollBarDisplayPolicy,XmDISPLAY_STATIC,
                            XmNselectScrollVisible, True,
                            NULL);
    
   /* put widgets into assorted cells */
   cellw = MakeCombo (reg);
   XtManageChild(cellw);
   XbaeMatrixSetCellWidget (reg, 15,2,cellw);
   
   cellw = MakeCombo (reg);
   XtManageChild(cellw);
   XbaeMatrixSetCellWidget (reg, 17,0,cellw);
 
   cellw = MakeCombo (reg);
   XtManageChild(cellw);
   XbaeMatrixSetCellWidget (reg, 0,3,cellw);
 
   cellw = MakeCombo (reg);
   XtManageChild(cellw);
   XbaeMatrixSetCellWidget (reg, 1,3,cellw);
 
   cellw = MakeCombo (reg);
   XtManageChild(cellw);
   XbaeMatrixSetCellWidget (reg, 0,1,cellw);
   
   XtManageChild(reg);
  
   /* Draw toplevel */
   XtRealizeWidget(toplevel);
   
   /* Enter event loop */
   XtAppMainLoop(app);
}
/************************** END OF FILE *************************/
