/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 * Copyright(c) 1995-99 Andrew Lister
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: Utils.h,v 1.5 2000/03/21 23:02:06 danny Exp $
 */

/*
 * Utils.h created by Andrew Lister (6 August, 1995)
 */
#ifndef _Xbae_Utils_h
#define _Xbae_Utils_h

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include <Xbae/Macros.h>

void xbaeGetVisibleRows(XbaeMatrixWidget, int *, int *);
void xbaeGetVisibleColumns(XbaeMatrixWidget, int *, int *);
void xbaeGetVisibleCells(XbaeMatrixWidget mw, int *, int *, int *,
			    int *);
void xbaeClearCell(XbaeMatrixWidget, int, int);
void xbaeMakeRowVisible(XbaeMatrixWidget, int);
void xbaeMakeColumnVisible(XbaeMatrixWidget, int);
void xbaeMakeCellVisible(XbaeMatrixWidget, int, int);
void xbaeAdjustTopRow(XbaeMatrixWidget);
void xbaeAdjustLeftColumn(XbaeMatrixWidget);
Boolean xbaeIsRowVisible(XbaeMatrixWidget, int);
Boolean xbaeIsColumnVisible(XbaeMatrixWidget, int);
Boolean xbaeIsCellVisible(XbaeMatrixWidget, int, int);
void xbaeSetClipMask(XbaeMatrixWidget, unsigned int);
void xbaeGetCellTotalWidth(XbaeMatrixWidget);
void xbaeGetColumnPositions(XbaeMatrixWidget);
void xbaeGetRowPositions(XbaeMatrixWidget);
void xbaeComputeSize(XbaeMatrixWidget, Boolean, Boolean);
short xbaeMaxRowLabel(XbaeMatrixWidget);
void xbaeParseColumnLabel(String, ColumnLabelLines);
Boolean xbaeEventToXY(XbaeMatrixWidget, XEvent *, int *, int *,
			 CellType *);
Boolean xbaeXYToRowCol(XbaeMatrixWidget, int *, int *, int *, int *,
			  CellType);
int xbaeXtoCol(XbaeMatrixWidget, int);
int xbaeYtoRow(XbaeMatrixWidget, int);
int xbaeXtoTrailingCol(XbaeMatrixWidget, int);
void xbaeRowColToXY(XbaeMatrixWidget, int, int, int *, int *);
Window xbaeGetCellWindow(XbaeMatrixWidget, Widget *, int, int);
void xbaeCalcVertFill(XbaeMatrixWidget, Window, int, int, int, int,
			 int *, int *, int *, int *);
void xbaeCalcHorizFill(XbaeMatrixWidget, Window, int, int, int, int,
			  int *, int *, int *, int *);

void xbaeObjectLock(Widget);
void xbaeObjectUnlock(Widget);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
