/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 * Copyright(c) 1995-99 Andrew Lister
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: Converters.h,v 1.3 2000/02/29 19:29:13 danny Exp $
 */

#ifndef _Xbae_Converters_h
#define _Xbae_Converters_h

#if defined (__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
 * Converters.h created by Andrew Lister (6 August, 1995)
 */

#include <Xm/Xm.h>
#include <Xbae/Macros.h>
/*
 * Type converters
 */
Boolean CvtStringToStringArray(Display *, XrmValuePtr, Cardinal *,
				   XrmValuePtr, XrmValuePtr, XtPointer *);
void StringArrayDestructor(XtAppContext, XrmValuePtr, XtPointer,
			       XrmValuePtr, Cardinal *);
Boolean CvtStringToCellTable(Display *, XrmValuePtr, Cardinal *,
				 XrmValuePtr, XrmValuePtr, XtPointer *);
void StringCellDestructor(XtAppContext, XrmValuePtr, XtPointer,
			      XrmValuePtr, Cardinal *);
Boolean CvtStringToWidthArray(Display *, XrmValuePtr, Cardinal *,
				  XrmValuePtr, XrmValuePtr, XtPointer *);
void WidthArrayDestructor(XtAppContext, XrmValuePtr, XtPointer,
			       XrmValuePtr, Cardinal *);
Boolean CvtStringToMaxLengthArray(Display *, XrmValuePtr, Cardinal *,
				      XrmValuePtr, XrmValuePtr, XtPointer *);
void MaxLengthArrayDestructor(XtAppContext, XrmValuePtr, XtPointer,
				  XrmValuePtr, Cardinal *);
Boolean CvtStringToBooleanArray(Display *, XrmValuePtr, Cardinal *,
				    XrmValuePtr, XrmValuePtr, XtPointer *);
void BooleanArrayDestructor(XtAppContext, XrmValuePtr, XtPointer,
				XrmValuePtr, Cardinal *);
Boolean CvtStringToAlignmentArray(Display *, XrmValuePtr, Cardinal *,
				      XrmValuePtr, XrmValuePtr, XtPointer *);
void AlignmentArrayDestructor(XtAppContext, XrmValuePtr, XtPointer,
				  XrmValuePtr, Cardinal *num_args);
Boolean CvtStringToPixelTable(Display *, XrmValuePtr, Cardinal *,
				  XrmValuePtr, XrmValuePtr, XtPointer *);
void PixelTableDestructor(XtAppContext, XrmValuePtr, XtPointer,
				  XrmValuePtr, Cardinal *);
Boolean CvtStringToGridType(Display *, XrmValuePtr, Cardinal *,
				XrmValuePtr, XrmValuePtr, XtPointer *);

Boolean
#ifdef __VMS
CvtStringToMatrixScrollBarDisp
#else
CvtStringToMatrixScrollBarDisplayPolicy
#endif
	(Display *, XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr, XtPointer *);

#if defined (__cplusplus) || defined(c_plusplus)
}
#endif

#endif
