#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/DrawingA.h>
#include <Xm/XmP.h>
#include "Tab.h"

void vc_cb(Widget, XtPointer, XtPointer);
void go_to_cb(Widget, XtPointer, XtPointer);

Widget tab_wid;
Widget child1;
Widget child2;
Widget child3;

void main(int argc,char *argv[])
{
Widget topLevel;
Widget frame;
Widget box;
int i;

topLevel=XtInitialize(argv[0],"XmTab",NULL,0,&argc,argv);


tab_wid = XtVaCreateWidget("Tab", xmTabWidgetClass, topLevel,
					NULL);

XtAddCallback(tab_wid, XmNvalueChangedCallback, (XtCallbackProc) vc_cb, NULL);

    child1 = XtVaCreateWidget("Toggles", xmFormWidgetClass, tab_wid,
					NULL);

	frame = XtVaCreateWidget("Frame", xmFrameWidgetClass, child1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					NULL);

	XtVaCreateManagedWidget("A New Tab", xmLabelWidgetClass, frame,
					XmNchildType, XmFRAME_TITLE_CHILD,
					NULL);

	box = XmCreateRadioBox(frame, "RadioBox", NULL, 0);

	
	for(i=0; i<20; i++)
	XtVaCreateManagedWidget("Toggle", xmToggleButtonWidgetClass, box,
					NULL);

	XtManageChild(box);
	XtManageChild(frame);

    child2 = XtVaCreateWidget("NewTab", xmDrawingAreaWidgetClass, tab_wid,
		XtVaTypedArg, XmNtabLabel, XmRString, "DrawingArea", 12,
		XtVaTypedArg, XmNbackground, XmRString, "gray60", 7,
			XmNwidth, 500,
			XmNheight, 500,
					NULL);

    child3 = XtVaCreateWidget("T", xmRowColumnWidgetClass, tab_wid,
		XtVaTypedArg, XmNtabLabel, XmRString, "PushButtons", 12,
			XmNnumColumns, 3,
			XmNadjustLast, False,
			XmNorientation, XmVERTICAL,
			XmNpacking, XmPACK_COLUMN,
					NULL);
						
	for(i=0; i<12; i++)
	XtAddCallback(
	XtVaCreateManagedWidget("Go to 1st Tab", 
			xmPushButtonWidgetClass, child3,
			NULL),
		XmNactivateCallback, (XtCallbackProc) go_to_cb, NULL);

XtManageChild(child1);
XtManageChild(child2);
XtManageChild(child3);
XtManageChild(tab_wid);

XmTabSetTabWidget(tab_wid, child3, True);

XtRealizeWidget(topLevel);
XtMainLoop();
}


void vc_cb(Widget w, XtPointer client, XtPointer call)
{
	printf("value changed callback\n");

}

void go_to_cb(Widget w, XtPointer client, XtPointer call)
{
	XmTabSetTabWidget(tab_wid, child1, True);
/*
	XtManageChild(child3);
	XtUnmanageChild(child1);
*/
}

