

/*************************************************************************
 * Version 1.4  on  18-Nov-1996
 * (c) 1996 Pralay Kanti Dakua (pralay@teil.soft.net) 
 *     Tata Elxsi India Ltd
 *
 * This is a free software and permission to use, modify, distribute,
 * selling and using for commercial purpose is hereby granted provided
 * that the above copyright notice and this permission notice shall be
 * included in all copies and their supporting documentations.
 *
 * There is no warranty for this software. In no event Pralay Kanti Dakua
 * or Tata Elxsi India Ltd will be liable for merchantability and
 * fitness of the software and damages due to this software.
 *
 * Author:
 * Pralay Kanti Dakua (pralay@teil.soft.net)
 * Tata Elxsi India Ltd.
 *
 **************************************************************************
 *
 * Credits
 * -------
 * The keyboard translations are added by Andreas Zeller (zeller@comsoft.de).
 *
 **************************************************************************/



#ifndef __DOUBLESSP_H__
#define __DOUBLESSP_H__

#include <X11/ConstrainP.h>
#include <X11/CompositeP.h>
#include <Xm/ManagerP.h>
#include "DoubleSS.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _XmDoubleSliderScaleClassPart {
	int i;
} XmDoubleSliderScaleClassPart;

typedef struct _XmDoubleSliderScaleClassRec{
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
	XmManagerClassPart  manager_class;
	XmDoubleSliderScaleClassPart dsscale_class;
}XmDoubleSliderScaleClassRec;

typedef struct _XmDoubleSliderScalePart {

XtCallbackList lower_drag_callback;
XtCallbackList upper_drag_callback;
XtCallbackList lower_value_changed_callback;
XtCallbackList upper_value_changed_callback;

Pixmap slider;

GC foreground_GC;

Dimension slot_thickness;

Dimension slider_thickness;
Dimension slider_length;

unsigned char orientation;
unsigned char processing_direction;

Boolean show_values;

int minimum_value;
int maximum_value;

int lower_value;
int upper_value;

int lower_x;
int lower_y;
int upper_x;
int upper_y;

Position show_lower_value_x;
Position show_lower_value_y;
Position show_upper_value_x;
Position show_upper_value_y;

Boolean lower_slider_on;
Boolean upper_slider_on;

int offset_x;
int offset_y;

Dimension scale_width;
Dimension scale_height;

Dimension slider_size_x;
Dimension slider_size_y;

XmFontList font_list;

unsigned char scale_alignment;

} XmDoubleSliderScalePart;

typedef struct _XmDoubleSliderScaleRec {
   CorePart   core;
	CompositePart  composite;
	ConstraintPart constraint; 	
  	XmManagerPart   manager;
    XmDoubleSliderScalePart	dsscale; 
} XmDoubleSliderScaleRec;

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /***  __DOUBLESSP_H__  ***/

