
/*************************************************************************
 * Version 1.00  on  28.12.1995
 * (c) 1995 Pralay Dakua
 *     pralay@teil.soft.net
 *
 * This program is free software; permission hereby granted, free of
 * charge, to any person obtaining a copy of this software and
 * associated documentations to copy, modify and  distribute it under
 * the terms of the GNU General Public License as published by
 * the Free Software Foundation, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.

 * AS THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
 * FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 * OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 * PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
 * TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU,  SHOULD THE
 * PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 * REPAIR OR CORRECTION.
 *
 **************************************************************************/

#include <stdio.h>
#include <string.h>
#include <Xm/XmP.h>
#include "CenterP.h"

/*** widget methods */
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void expose(Widget, XExposeEvent *, Region);
static void resize(Widget);
static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal *);
static XtGeometryResult GeometryManager(Widget, XtWidgetGeometry*, XtWidgetGeometry*);
static void ChangeManaged(Widget);
static XtGeometryResult QueryGeometry(Widget, XtWidgetGeometry*, XtWidgetGeometry*);


static void do_layout(XmCenterWidget);
static void do_horizontal_layout(XmCenterWidget);
static void do_vertical_layout(XmCenterWidget);
static void get_children_space(XmCenterWidget, Dimension*, Dimension*);


#define offset(field) XtOffsetOf(XmCenterRec, field)

static XtResource resources[] = {
{
XmNorientation,
XmCOrientation,
XmROrientation,
sizeof(unsigned char),
offset(center.orientation),
XmRImmediate,
(XtPointer)XmHORIZONTAL
},
{
XmNjustification,
XmCJustification,
XmRJustification,
sizeof(unsigned char),
offset(center.justification),
XmRImmediate,
(XtPointer)XmJUSTIFICATION_CENTER
},
{
XmNspacing,
XmCSpacing,
XmRDimension,
sizeof(Dimension),
offset(center.spacing),
XmRString,
"0"
},
{
XmNdistributed,
XmCDistributed,
XmRBoolean,
sizeof(Boolean),
offset(center.distributed),
XmRImmediate,
(XtPointer)False,
}
};


XmCenterClassRec xmCenterClassRec = {
{   /*** core class part ****/
(WidgetClass) &xmManagerClassRec,               /* super class */
"XmCenter",                                     /* class name */
sizeof(XmCenterRec),                            /* widget size */
NULL,                                           /* class initialize */
NULL,                                           /* class part initialize */
False,                                          /* class inited */
(XtInitProc)Initialize,                         /* initialize */
NULL,                                           /* initialize hook */
XtInheritRealize,                               /* realize */
NULL,                                           /* actions */
0,                                              /* num actions */
resources,                                      /*  resources */
XtNumber(resources),                            /* num resources */
NULLQUARK,                                      /* xrm class */
True,                                           /* compress motion */
XtExposeCompressMultiple,                       /* compress exposure */
True,                                           /* compress enter leave */
True,                                           /* visible interest */
(XtWidgetProc)NULL,                             /* destroy */
(XtWidgetProc)resize,                           /* resize */
(XtExposeProc)NULL,                             /* expose */
(XtSetValuesFunc)SetValues,                     /* set values */
NULL,                                           /* set values hook */
XtInheritSetValuesAlmost,                       /* set values almost */
NULL,                                           /* get values hook */
NULL,                                           /* accept focus */
XtVersion,                                      /* version */
NULL,                                           /* callback private */
NULL,                                           /* tm table */
QueryGeometry,                                           /* query geometry */
NULL,                                           /* display accelerator */
NULL                                            /* extension */
},
{ /***** composite class part *****/
GeometryManager,                                /* geomerty manager */
ChangeManaged,                                  /* change managed */
XtInheritInsertChild,                           /* insert child */
XtInheritDeleteChild,                           /* delete child */
NULL                                            /* extension */
},
{ /**** Constraint Class Part *****/
NULL,                                           /* constraint resource list     */
0,                                              /* number of constraints in list */
0,                                              /* size of constraint record     */
NULL,                                           /* constraint initialization   */
NULL,                                           /* constraint destroy proc     */
NULL,                                           /* constraint set_values proc   */
NULL                                            /* pointer to extension record  */
},
{ /***** Manager Class Part *****/
XtInheritTranslations,                          /* translations */
NULL,                                           /* syn_resources  */
0,                                              /* num_syn_resources */
NULL,                                           /* syn_constraint_resources */
0,                                              /* num_syn_constraint_resources */
(XmParentProcessProc)NULL,                      /* parent_process */
NULL                                            /* extension */
},
{ /****** center class part ****/
0,                                              /* extension */
}
};


WidgetClass xmCenterWidgetClass =(WidgetClass) &xmCenterClassRec;


/*** widget methods */

static void Initialize(Widget req, Widget new, ArgList args, Cardinal *nargs)
{
XmCenterWidget reqw = (XmCenterWidget)req;
XmCenterWidget neww = (XmCenterWidget)new;

if(reqw->core.width <= 0)
    neww->core.width = 10;
if(reqw->core.height <=0)
    neww->core.height = 10;
}

/****************/
static void resize(Widget w)
{
XmCenterWidget wid =(XmCenterWidget)w;
do_layout(wid);
}

/****************/
static Boolean 
	SetValues(Widget cur, Widget req, Widget new, ArgList args, Cardinal *nargs)
{
XmCenterWidget curw = (XmCenterWidget)cur;
XmCenterWidget neww = (XmCenterWidget)new;

/* change of x,y size, border width are are always acceptable.
 * these changes are acceptable -
 * justification.
 * orientation.
 * spacing.
 * after these changes call do_layout().
 */ 

if(neww->center.orientation != XmHORIZONTAL && neww->center.orientation != XmVERTICAL)
  {
     XtWarning("Invalid orientation type.");
     neww->center.orientation = XmHORIZONTAL;
  }

if(neww->center.justification != XmJUSTIFICATION_BEGINNING
             && neww->center.justification != XmJUSTIFICATION_CENTER
             && neww->center.justification != XmJUSTIFICATION_END)
  {
     XtWarning("Invalid justification type.");
     neww->center.justification = XmJUSTIFICATION_CENTER;
  }

if(!neww->center.distributed)
{
if(neww->center.orientation == XmHORIZONTAL
              && neww->center.spacing >= neww->core.width)
  {
     XtWarning("Spacing is greater than or equal to window width.");
     neww->center.spacing = 0;
  } 
else if(neww->center.orientation == XmVERTICAL
             && neww->center.spacing >= neww->core.height)
  {
     XtWarning("Spacing is greater than or equal to window height.");
     neww->center.spacing = 0;
  } 

if(neww->center.spacing > 0)
    XtWarning("Spacing is less than zero.");
    neww->center.spacing = 0;
}

do_layout(neww);
return(False);
}

/******************/
static XtGeometryResult 
   QueryGeometry(Widget w, XtWidgetGeometry *req, XtWidgetGeometry *pref)
{
XmCenterWidget wid = (XmCenterWidget)w;
Widget child;
Dimension width, height;
Dimension children_space_w, children_space_h;
Dimension ret_h, ret_w;
XtGeometryResult reply;
int i;

if(req->request_mode & CWX)
       pref->x = req->x;

if(req->request_mode & CWY)
       pref->y = req->y;


if(req->request_mode & CWBorderWidth)
       pref->border_width = req->border_width;

get_children_space(wid, &children_space_w, &children_space_h);

if(req->request_mode & CWWidth)
{
	if(width < children_space_w)
     pref->width = children_space_w;
	else
       pref->width = req->width;
}

if(req->request_mode & CWHeight)
{
	if(height < children_space_h)
		pref->height = children_space_h;
	else
       pref->height = req->height;
}

return(XtGeometryYes);
}

/****************/
static XtGeometryResult 
    GeometryManager(Widget w, XtWidgetGeometry *request, 
										XtWidgetGeometry *prefer)
{
XmCenterWidget center_wid =(XmCenterWidget)w->core.parent;
Dimension children_space_w, children_space_h;
Dimension ret_h, ret_w;
XtGeometryResult reply;

/* whenever any child trying to change its position
 * ignore it.
 * but in case of changing the size consider it
 * and relayout. same for border width. 
 * (but whenevever width and height change, x,y must be changed
 * for centering.
 */  

if(request->request_mode & CWWidth)
        w->core.width = request->width;

if(request->request_mode & CWHeight)
        w->core.height = request->height;

if(request->request_mode & CWBorderWidth)
        w->core.border_width = request->border_width;

get_children_space(center_wid, &children_space_w, &children_space_h);

if(center_wid->core.width < children_space_w)
{
	reply = XtMakeResizeRequest((Widget)center_wid,
              children_space_w , center_wid->core.height, &ret_w, &ret_h);
	if(reply == XtGeometryYes) center_wid->core.width = ret_w;
}

if(center_wid->core.height < children_space_h)
{
	reply = XtMakeResizeRequest((Widget)center_wid,
                center_wid->core.width, children_space_h, &ret_w, &ret_h);
	if(reply == XtGeometryYes) center_wid->core.height = ret_h;
}

do_layout(center_wid);

return(XtGeometryYes);
}

/****************/
static void ChangeManaged(Widget w)
{

/* whenever any child widget managed or unmanaged
 * relayout for centering.
 */ 
/* resize window HERE ITSELF.
 * also call XtMakeResizeRequest()
 */

XmCenterWidget wid = (XmCenterWidget)w;
Dimension ch_width, ch_height;
XtGeometryResult reply;
Dimension ret_w, ret_h;

get_children_space(wid, &ch_width, &ch_height);

if(wid->core.width < ch_width)
{
	reply = XtMakeResizeRequest((Widget)wid,
              ch_width , wid->core.height, &ret_w, &ret_h);
	if(reply == XtGeometryYes) wid->core.width = ret_w;
}
if(wid->core.height < ch_height)
{
	reply = XtMakeResizeRequest((Widget)wid,
                wid->core.width , ch_height, &ret_w, &ret_h);
	if(reply == XtGeometryYes) wid->core.height = ret_h;
}

do_layout(wid);
}

/******* aux *********/

static void do_layout(XmCenterWidget wid)
{
if(wid->center.orientation == XmHORIZONTAL)
    {
       do_horizontal_layout(wid);
    }
else if(wid->center.orientation == XmVERTICAL)
    {
       do_vertical_layout(wid);
    }
}

/***********************/
static void do_horizontal_layout(XmCenterWidget wid)
{
Widget child;
int i;
Position x,y;
Dimension children_space_w, children_space_h;
unsigned int no_of_managed_child;
int dist_space;

/* get the center window size. calculate the total space
 * required for children. then start assigning the 
 * x,y co-ord for the children.
 */

get_children_space(wid, &children_space_w, &children_space_h);

if(wid->center.distributed)
  {
    no_of_managed_child = 0;
         for(i=0; i < wid->composite.num_children; i++)
           {
              child = wid->composite.children[i];
                if(child->core.managed) no_of_managed_child++;
           }
       
        x = (Position)(((float)(wid->core.width  - children_space_w))/
															(float)(no_of_managed_child+1));
        dist_space = (int)x;
  } /* if */
else
        x = (Position)(((float)(wid->core.width - children_space_w)/2.0)
												+ wid->center.spacing);

      if(wid->center.justification == XmJUSTIFICATION_BEGINNING)
             y = (Position)(((float)(wid->core.height - children_space_h))/2.0);
    
		for(i=0; i < wid->composite.num_children; i++)
         {
            child = wid->composite.children[i];
            if(child->core.managed) 
              {
              if(wid->center.justification == XmJUSTIFICATION_CENTER)
                  	 y = (Position)(((float)(wid->core.height - child->core.height 
											- 2*child->core.border_width))/2.0); 

               else if(wid->center.justification == XmJUSTIFICATION_END)
                y = (Position)(((float)(wid->core.height + children_space_h))/2.0
                              - (float)child->core.height - 2*child->core.border_width); 

                  XtMoveWidget(child, x,y);

               if(wid->center.distributed)
                {
                  x+=(Position)((int)child->core.width + dist_space + 
														(int)(2*child->core.border_width));
                } 
                else
                  x += (Position)(child->core.width + wid->center.spacing 
														+ 2*child->core.border_width);
              } /* if */
         } /* for */
}

/********************/
static void do_vertical_layout(XmCenterWidget wid)
{
Widget child;
int i;
Position x,y;
Dimension children_space_w, children_space_h;
unsigned int no_of_managed_child;
int dist_space;

/* get the center window size. calculate the total space
 * required for children. then start assigning the
 * x,y co-ord for the children.
 */

get_children_space(wid, &children_space_w, &children_space_h);


if(wid->center.distributed)
  {
    no_of_managed_child = 0;
         for(i=0; i < wid->composite.num_children; i++)
           {
              child = wid->composite.children[i];
                if(child->core.managed) no_of_managed_child++;
           }

        y = (Position)(((float)(wid->core.height  - children_space_h))/
                                             (float)(no_of_managed_child+1));
        dist_space = (int)y;
  } /* if */
else
        y = (Position)(((float)(wid->core.height - children_space_h)/2.0)
                                    + wid->center.spacing);

      if(wid->center.justification == XmJUSTIFICATION_BEGINNING)
             x = (Position)(((float)(wid->core.width - children_space_w))/2.0);

      for(i=0; i < wid->composite.num_children; i++)
         {
            child = wid->composite.children[i];
            if(child->core.managed)
              {
              if(wid->center.justification == XmJUSTIFICATION_CENTER)
               x = (Position)(((float)(wid->core.width - child->core.width 
											- 2*child->core.border_width))/2.0);

               else if(wid->center.justification == XmJUSTIFICATION_END)
                x = (Position)(((float)(wid->core.width + children_space_w))/2.0
                              - (float)child->core.width - 2*child->core.border_width); 

                 XtMoveWidget(child, x,y);

               if(wid->center.distributed)
                {
                  y+=(Position)((int)child->core.height + dist_space +
                                          (int)(2*child->core.border_width));
                }
                else
                 y += (Position)(child->core.height + wid->center.spacing 
															+ 2*child->core.border_width);
              } /* if */
         } /* for */
}

/**************************/

static void
  get_children_space(XmCenterWidget wid, Dimension *width, Dimension *height)
{
Widget child;
int i;
Dimension children_space_w, children_space_h;

if(wid->center.orientation == XmHORIZONTAL)
{
 if(wid->center.distributed)
  children_space_w = 0;
 else
  children_space_w = wid->center.spacing;
  children_space_h = 0;

  for(i=0; i < wid->composite.num_children; i++)
   {
    child = wid->composite.children[i];
    if(child->core.managed)
       {
         if(wid->center.distributed)
         children_space_w += (child->core.width + 2*child->core.border_width);
         else
         children_space_w += (child->core.width + wid->center.spacing
                                 + 2*child->core.border_width);

         children_space_h = (children_space_h < (child->core.height
               + 2*child->core.border_width))?
               (child->core.height + 2*child->core.border_width): children_space_h;
       }
   }/* for */
} /* if */
else if(wid->center.orientation == XmVERTICAL)
{
  children_space_w = 0;
 if(wid->center.distributed)
  children_space_h = 0;
 else
  children_space_h = wid->center.spacing;

  for(i=0; i < wid->composite.num_children; i++)
   {
    child = wid->composite.children[i];
    if(child->core.managed)
       {
         children_space_w =
            (children_space_w < (child->core.width + 2*child->core.border_width))?
                 (child->core.width + 2*child->core.border_width): children_space_w;

         if(wid->center.distributed)
         children_space_h += (child->core.height + 2*child->core.border_width);
         else
         children_space_h +=
            (child->core.height + wid->center.spacing + 2*child->core.border_width);
       }
   } /* for */
} /* if */

*width = children_space_w;
*height = children_space_h;
}

/******************* end of program ********************/
