/*
 * xhello4.c -- A (modified) "My First Program", now with user defined
 * push button face.
 */

#include <Xm/Xm.h>
#include <pushbuttons.h>
#include <msgbox.h>

#include "QuitPB.xpm"  /* The pixmaps to be displayed */
#include "QuitPBa.xpm"

Widget MessageDialog = NULL;

void ReallyExitCB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    exit(0);
} /* ReallyExitCB */

void CancelCB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    XtUnmanageChild(MessageDialog);
} /* CancelCB */


void ExitCB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    if ( MessageDialog == NULL ) {
        MessageDialog = XmCreateMsgBox(w, "msgbox", 
	                    "Quit...", 
                            "Do you really want to quit?", 
		            MB_YESNO | MB_DEFAULT2, NULL, 0);
        XtAddCallback(
	    XmMsgBoxGetChild(MessageDialog, XmPUSHBUTTON_YES),
	    XmNactivateCallback, 
	    (XtCallbackProc) ReallyExitCB, NULL);
        XtAddCallback(
	    XmMsgBoxGetChild(MessageDialog, XmPUSHBUTTON_NO),
	    XmNactivateCallback, 
	    (XtCallbackProc) CancelCB, NULL);
    }
    XtManageChild(MessageDialog);
} /* ExitCB */


int main(Cardinal argc, char **argv)
{
    static char  *Fallback[] = {
        "*.background: Gray75", 
        "*.fontList: -*-helvetica-bold-r-normal-*-*-120-*-*-*-*-iso8859-1", 
        NULL};
    XtAppContext AppCtx;
    Widget       TopLevel, Button;

    TopLevel = XtVaAppInitialize(&AppCtx, "XHello", NULL, 0, 
                                 &argc, argv, Fallback, NULL);
    Button = XmCreatePixmapPushButton(TopLevel, "ok", 
                                        QuitPB_xpm, QuitPBa_xpm, NULL,
                                        NULL, 0);
    XtAddCallback(Button, XmNactivateCallback, 
                  (XtCallbackProc) ExitCB, NULL);
    XtManageChild(Button);
    XtRealizeWidget(TopLevel);
    XtAppMainLoop(AppCtx);
    return 0;   
} /* main */
    
/* End of xhello4.c */
