/*
 * resource.c -- Dieses Programm-Modul implementiert den Zugriff auf
 *               solche Ressourcen, die in der Ressourcen-Datenbank
 *               abgelegt sind.
 * 
 * Status: 27.04.1994
 * 
 * (c) 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * albrecht@igpm.rwth-aachen.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */

#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <X11/StringDefs.h>

#include "resource.h"

/* --------------------------------------------------------------------
 * Diese Funktion implementiert den Zugriff auf eine x-beliebige
 * Ressource eines x-beliebigen Widgets.
 * 
 * Parameter:
 *   w
 *   ResourceName   Name
 *   ResourceClass  Klassenname des abzufragenden Eintrags. Wenn hier
 *		    NULL uebergeben wird, so benutzt die Routine den
 *		    angegebenen ResourceName, dessen erster Buchstabe
 *		    dann in einen Grossbuchstaben verwandelt wird.
 *   Default	    Hier kann eine Vorgabe eingesetzt werden, die immer
 *		    dann zurueckgegeben wird, wenn kein passender
 *		    Eintrag in der Ressourcen-Datenbank zu finden war.
 * 
 * Ergebnis:
 *   Liefert NULL, wenn kein Eintrag zu dieser Ressource zu finden ist.
 *   Ansonsten gibt die Routine einen Zeiger auf den String zurueck, 
 *   der in der Datenbank angegeben wurde. Der Zeiger zeigt dabei auf
 *   Daten innerhalb der Datenbank und darf daher nicht veraendert
 *   werden! Ausserdem wird jeder abgefragte Eintrag solange im Cache
 *   vorraetig gehalten, bis die Verbindung zum jeweiligen Display, 
 *   auf dem sich das Widget befindet, geschlossen wird.
 */
char *XmLoadStringResource(Widget w, char *ResourceName, 
                                     char *ResourceClass,
                                     char *Default)
{
    XtResource Resources[] = {
	{ NULL, NULL, XtRString, sizeof(String), 0, XtRString, NULL }
    };
    String TheString;
    char   *TempClassName;
    
    Resources[0].resource_name = ResourceName;
    if ( ResourceClass )
        Resources[0].resource_class = ResourceClass;
    else {
	TempClassName = strdup(ResourceName);
	TempClassName[0] = toupper(TempClassName[0]);
	Resources[0].resource_class = TempClassName;
    }
    XtGetApplicationResources(
	w,				/* welches Widget abfragen? */
	(XtPointer) &TheString,		/* Daten dorthin schreiben! */
	Resources, XtNumber(Resources), /* da sind die Resourcen... */
	NULL, 0				/* und nix weiter.          */
	);
    if ( ResourceClass == NULL ) free(TempClassName);
    return TheString ? TheString : Default;
} /* XmLoadStringResource */

/* Ende von resource.c */
