/*
 * msgbox.h -- Die allseits beliebte Message-Box fuer Standardfragen
 *             usw. Einfache Rueckfragen des Programms lassen sich so
 *             mit einem einzigen Befehl namens "MessageBox()" er-
 *	       ledigen, ohne den sonst erforderlichen Aufwand (Schalt-
 *	       flaechen einfuegen, Layout usw.)
 *
 * Status: 02.05.1994
 * 
 * (c) 1994 Harald Albrecht
 * Institut fuer Geometrie und Praktische Mathematik
 * albrecht@igpm.rwth-aachen.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING for more details);
 * if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 */
#ifndef __msgbox_h
#define __msgbox_h

#include <pushbuttons.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Die verfuegbaren Symbole, die in der Message-Box angezeigt werden
 * koennen. (Nur so der Vollstaendigkeit halber, MB_ICONMASK ist kein
 * Symbol, sondern dient nur der spaeteren Ausmaskierung der Symbol-
 * nummer).
 */
#define MB_ICONMASK		0x000F
#define MB_INFOICON		XmLABELFACE_INFO
#define MB_HANDICON		XmLABELFACE_HAND
#define MB_QUESTIONICON		XmLABELFACE_QUESTION
#define MB_EXCLAMATIONICON	XmLABELFACE_EXCLAMATION
#define MB_STANDBYICON		XmLABELFACE_TIME

/*
 * Alle verfuegbaren Kombinationen von Schaltflaechen...auch hier ist
 * MB_BUTTONMASK eine Bitmaske (naja, der Name laesst das ja auch
 * vermuten).
 */
#define MB_BUTTONMASK		0x00F0
#define MB_OK			0x0010
#define MB_OKCANCEL		0x0020
#define MB_YESNO		0x0030
#define MB_YESNOCANCEL		0x0040
#define MB_RETRYABORT		0x0050
#define MB_RETRYABORTIGNORE	0x0060

#define MB_HELP			0x1000

/* Welcher der Buttons ist der Default-Button? */
#define MB_DEFAULTMASK		0x0300
#define MB_DEFAULTSHIFT		8
#define MB_DEFAULT1		0x0000
#define MB_DEFAULT2		0x0100
#define MB_DEFAULT3		0x0200
#define MB_DEFAULT4		0x0300

typedef Boolean (XmEventLoopProc)(XtAppContext);


extern int XmMessageBox(Widget Parent, char *Caption, char *Text, 
                        int Flags, XmEventLoopProc *ExternalEventLoop);

extern Widget XmCreateMsgBox(Widget Parent, char *Name, 
                             char *Caption, char *Text, 
			     int Flags, 
			     ArgList Args, Cardinal ArgCount);

extern Widget XmMsgBoxGetChild(Widget w, int WhichChild);


#ifdef __cplusplus
}
#endif

#endif
/* Ende von mbox.h */
