/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef MAPSCAN_H
#define MAPSCAN_H	1

#include "Earth.h"
#include "earthmisc.h"

#define MAP_DATA_SCALE (30000)

#define XingTypeEntry (0)
#define XingTypeExit  (1)

typedef	struct
{
  int    type;
  int    cidx;
  double x, y;
  double angle;
} EdgeXing;

typedef struct		s_map_scan_input
{
  ProjType		proj_type;
  double		view_lon;
  double		view_lat;
  double		view_rot;
  double		view_mag;
  int			wdth;
  int			hght;
  int			shift_x;
  int			shift_y;
} t_map_scan_input;

typedef struct		s_map_scan_output
{
  ViewPosInfo		view_pos_info;
  double		proj_scale;
  double		proj_xofs;
  double		proj_yofs;
  double		inv_proj_scale;
  XearthArr		*scanbits;
  XearthArr		*edgexings;
  int			min_y;
  int			max_y;
  XearthArr		**scanbuf;
} t_map_scan_output;

/* xy->screen projections
 */
#define XPROJECT(x)     ((mso->proj_scale*(x))+mso->proj_xofs)
#define YPROJECT(y)     (mso->proj_yofs-(mso->proj_scale*(y)))
#define INV_XPROJECT(x) (((x)-mso->proj_xofs)*mso->inv_proj_scale)
#define INV_YPROJECT(y) ((mso->proj_yofs-(y))*mso->inv_proj_scale)

/* PROTO mapscan.c */
/* include/XearthI.h */
/* mapscan.c */
char *itoa P((int signed_integer));
void mso_alloc P((t_map_scan_input *msi, t_map_scan_output *mso));
void mso_reset P((t_map_scan_input *msi, t_map_scan_output *mso));
void mso_cleanup P((t_map_scan_input *msi, t_map_scan_output *mso));
void scan_map P((t_map_scan_input *msi, t_map_scan_output *mso));
void orth_scan_outline P((t_map_scan_input *msi, t_map_scan_output *mso));
void orth_scan_curves P((t_map_scan_input *msi, t_map_scan_output *mso));
double *orth_extract_curve P((t_map_scan_output *mso, int npts, short *data));
void orth_scan_along_curve P((t_map_scan_input *msi, t_map_scan_output *mso, double *prev, double *curr, int cidx));
void orth_find_edge_xing P((double *prev, double *curr, double *rslt));
void orth_handle_xings P((t_map_scan_input *msi, t_map_scan_output *mso));
void orth_scan_arc P((t_map_scan_input *msi, t_map_scan_output *mso, double x_0, double y_0, double a_0, double x_1, double y_1, double a_1));
void merc_scan_outline P((t_map_scan_input *msi, t_map_scan_output *mso));
void merc_scan_curves P((t_map_scan_input *msi, t_map_scan_output *mso));
double *merc_extract_curve P((t_map_scan_output *mso, int npts, short *data));
void merc_scan_along_curve P((t_map_scan_input *msi, t_map_scan_output *mso, double *prev, double *curr, int cidx));
double merc_find_edge_xing P((double *prev, double *curr));
void merc_handle_xings P((t_map_scan_input *msi, t_map_scan_output *mso));
void merc_scan_edge P((t_map_scan_input *msi, t_map_scan_output *mso, EdgeXing *from, EdgeXing *to));
void xing_error P((t_map_scan_input *msi, const char *file, int line, int idx, int nxings, EdgeXing *xings));
void scan P((t_map_scan_input *msi, t_map_scan_output *mso, double x_0, double y_0, double x_1, double y_1));
void get_scanbits P((t_map_scan_input *msi, t_map_scan_output *mso, int val));
#endif
