/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EARTHPOS_H
#define EARTHPOS_H	1

#include "Earth.h"
#include "earthmisc.h"

typedef struct		s_earth_pos_input
{
  int			compute_sun_pos;
  time_t		fixed_time;
  ViewPosType		view_pos_type;
  double		view_lon;
  double		view_lat;
  double		period;
  double		inclin;
} t_earth_pos_input;

typedef struct		s_earth_pos_output
{
  double		view_lat;
  double		view_lon;
  double		sun_lat;
  double		sun_lon;
} t_earth_pos_output;

/* PROTO earthpos.c */
/* include/XearthI.h */
/* earthpos.c */
void sun_relative_position P((t_earth_pos_input *epi, t_earth_pos_output *epo, double *lat_ret, double *lon_ret));
void simple_orbit P((t_earth_pos_input *epi, time_t ssue, double *lat, double *lon));
void compute_positions P((t_earth_pos_input *epi, t_earth_pos_output *epo));
#endif
