/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EARTH_H
#define EARTH_H	1

#include <X11/Intrinsic.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xfuncproto.h>

/*
 * EarthWidget resources
 */

#ifndef XtNprojType	
#define XtNprojType	"projType"
#endif

#ifndef XtCProjType
#define XtCProjType	"ProjType"
#endif

#ifndef XtNviewPosType
#define XtNviewPosType	"viewPosType"
#endif

#ifndef XtCViewPosType
#define XtCViewPosType	"ViewPosType"
#endif	

#ifndef XtNviewLat
#define XtNviewLat	"viewLat"
#endif

#ifndef XtCViewLat
#define XtCViewLat	"ViewLat"
#endif	

#ifndef XtNviewLon
#define XtNviewLon	"viewLon"
#endif

#ifndef XtCViewLon
#define XtCViewLon	"ViewLon"
#endif	

#ifndef XtNperiod
#define XtNperiod	"period"
#endif

#ifndef XtCPeriod
#define XtCPeriod	"Period"
#endif	

#ifndef XtNinclin
#define XtNinclin	"inclin"
#endif

#ifndef XtCInclin
#define XtCInclin	"Inclin"
#endif	

#ifndef XtNviewRot
#define XtNviewRot	"viewRot"
#endif

#ifndef XtCViewRot	
#define XtCViewRot	"ViewRot"
#endif

#ifndef XtNviewMag
#define XtNviewMag	"viewMag"
#endif

#ifndef XtCViewMag
#define XtCViewMag	"ViewMag"
#endif

#ifndef XtNstarFreq
#define XtNstarFreq	"starFreq"
#endif

#ifndef XtCStarFreq
#define XtCStarFreq	"StarFreq"
#endif

#ifndef XtNbigStars
#define XtNbigStars	"bigStars"
#endif

#ifndef XtCBigStars
#define XtCBigStars	"BigStars"
#endif

#ifndef XtNday
#define XtNday		"day"
#endif

#ifndef XtCDay
#define XtCDay		"Day"
#endif

#ifndef XtNnight
#define XtNnight	"night"
#endif

#ifndef XtCNight
#define XtCNight	"Night"
#endif

#ifndef XtNterminator
#define XtNterminator	"terminator"
#endif

#ifndef XtCTerminator
#define XtCTerminator	"Terminator"
#endif

#ifndef XtNmono
#define XtNmono		"mono"
#endif

#ifndef XtCMono
#define XtCMono		"Mono"
#endif

#ifndef XtNnumColors
#define XtNnumColors	"numColors"
#endif

#ifndef XtCNumColors
#define XtCNumColors	"NumColors"
#endif

#ifndef XtNxGamma
#define XtNxGamma	"xGamma"
#endif

#ifndef XtCXGamma
#define XtCXGamma	"XGamma"
#endif

#ifndef XtNtime
#define XtNtime		"time"
#endif

#ifndef XtCTime
#define XtCTime		"Time"
#endif

#ifndef XtNshiftX
#define XtNshiftX	"shiftX"
#endif

#ifndef XtCShiftX
#define XtCShiftX	"ShiftX"
#endif

#ifndef XtNshiftY
#define XtNshiftY	"shiftY"
#endif

#ifndef XtCShiftY
#define XtCShiftY	"ShiftY"
#endif

#ifndef XtNcomputeSunPos
#define XtNcomputeSunPos	"computeSunPos"
#endif

#ifndef XtCComputeSunPos
#define XtCComputeSunPos	"ComputeSunPos"
#endif

#ifndef XtNdoShade
#define XtNdoShade		"doShade"
#endif

#ifndef XtCDoShade
#define XtCDoShade		"DoShade"
#endif

#ifndef XtNdoStars
#define XtNdoStars		"doStars"
#endif

#ifndef XtCDoStars
#define XtCDoStars		"DoStars"
#endif

#ifndef XtNdoGrid
#define XtNdoGrid		"doGrid"
#endif

#ifndef XtCDoGrid
#define XtCDoGrid		"DoGrid"
#endif

#ifndef XtNgridBig
#define XtNgridBig		"gridBig"
#endif

#ifndef XtCGridBig
#define XtCGridBig		"GridBig"
#endif

#ifndef XtNgridSmall
#define XtNgridSmall		"gridSmall"
#endif

#ifndef XtCGridSmall
#define XtCGridSmall		"GridSmall"
#endif

/*
 * EarthWidgetConstraint resources
 */

#ifndef XtNlatitude
#define XtNlatitude		"latitude"
#endif

#ifndef XtCLatitude
#define XtCLatitude		"Latitude"
#endif

#ifndef XtNlongitude
#define XtNlongitude		"longitude"
#endif

#ifndef XtCLongitude
#define XtCLongitude		"Longitude"
#endif

extern WidgetClass		earthWidgetClass;

typedef struct _EarthClassRec	*EarthWidgetClass;
typedef struct _EarthRec	*EarthWidget;

typedef enum		_ProjType
{
  ProjTypeOrthographic,
  ProjTypeMercator
} ProjType;

typedef enum		_ViewPosType
{
  ViewPosTypeFixed,
  ViewPosTypeSunRel,
  ViewPosTypeOrbit
} ViewPosType;

_XFUNCPROTOBEGIN

extern void		XearthSetViewMag(
#if NeedFunctionPrototypes
Widget			self,
#if NeedWidePrototypes
double			view_mag
#else
float			view_mag
#endif
#endif
);

extern void		XearthSetViewRot(
#if NeedFunctionPrototypes
Widget			self,
#if NeedWidePrototypes
double			view_rot
#else
float			view_rot
#endif
#endif
);

extern void		XearthSetViewLat(
#if NeedFunctionPrototypes
Widget			self,
#if NeedWidePrototypes
double			view_lat
#else
float			view_lat
#endif
#endif
);

extern void		XearthSetViewLon(
#if NeedFunctionPrototypes
Widget			self,
#if NeedWidePrototypes
double			view_lon
#else
float			view_lon
#endif
#endif
);

extern void		XearthChildGetLatitude(
#if NeedFunctionPrototypes
Widget			child,
#if NeedWidePrototypes
double			*latitude
#else
float			*latitude
#endif
#endif
);

extern void		XearthChildGetLongitude(
#if NeedFunctionPrototypes
Widget			child,
#if NeedWidePrototypes
double			*longitude
#else
float			*longitude
#endif
#endif
);

extern void		XearthChildSetLatitude(
#if NeedFunctionPrototypes
Widget			child,
#if NeedWidePrototypes
double			latitude
#else
float			latitude
#endif
#endif
);

extern void		XearthChildSetLongitude(
#if NeedFunctionPrototypes
Widget			child,
#if NeedWidePrototypes
double			longitude
#else
float			longitude
#endif
#endif
);

extern int		XearthGetXY(
#if NeedFunctionPrototypes
Widget			self,
#if NeedWidePrototypes
double			latitude,
double			longitude,
#else
float			latitude,
float			longitude,
#endif
Position		*xret,
Position		*yret
#endif
);

_XFUNCPROTOEND

#endif
