'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfIcon
.SH DESCRIPTION
The XfwfIcon widget displays an image. The preferred width and
height of the widget will be set to the width and height of the loaded
image, plus space for the frame. The widget has a callback
\fIactivateCallback\fP, that is by default bound to a click of the left
mouse button.

The image is a \fIPixmap\fP, optionally accompanied by a mask, to make
parts of the image transparent. When the image has a mask, the frame
around the widget will not be shown.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfIcon
Name	Class	Type	Default
XtNimage	XtCImage	Icon *	NULL 
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps +2

.TP
.I "XtNimage"
The image must be in \fIPixmap\fP format. The width and height of the
image will be used to set the width and height of the widget.  There
is a converter for strings (defined in the Common widget), which will
try to interpret a string as a file name and load the file. The file
must be in XPM format. The converter also knows about some built-in
images, called \fI"FATAL"\fP, \fI"ERROR"\fP, \fI"WARNING"\fP, \fI"QUESTION"\fP,
\fI"INFO"\fP and \fI"NONE"\fP.

	

.TP
.I "XtNactivate"
The callback is called by the \fIactivate\fP action, which is by default
bound to a click of mouse button 1.

	

.TP
.I "XtNframeWidth"
By default, icons do not have a frame.

	

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Color 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Color 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNuseXCC	XtCUseXCC	Boolean 	TRUE 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNxcc	XtCXCc	XCC 	create_xcc 
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Color 	XtDefaultForeground 
XtNbackground	XtCBackground	Color 	XtDefaultBackground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The type \fIIcon\fP is defined in \fIConverters.h\fP

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.SS "Translations"

By default, the \fIactivate\fP action is bound to a mouse click and to
the Return key.

	

.nf
<Btn1Down>,<Btn1Up>: activate() 
.fi

.nf
<Key>Return: activate() 
.fi

.SS "Actions"

.TP
.I "activate

The \fIactivate\fP action just calls the \fIactivate\fP callback functions,
passing the \fIXEvent\fP pointer in the \fIcall_data\fP argument.

