'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfGroup
.SH DESCRIPTION
The Group widget is a subclass of RowCol, which means that it
arranges its children in rows and columns. (See the RowCol widget for
the resources that influence the layout.) The Group widget adds two
things to the capabilities already present in RowCol, namely a label
in the upper left hand corner and the ability to make a number of
Toggle buttons act as radio buttons.

The label is a short, one line piece of text, that is displayed over
the border in the top left corner. The border is interupted at that
point.  Since this works best with `ledged' or `chiseled' border
types, the default border is \fIXfwfChiseled\fP.

The special support for radio buttons works as follows: when a child
is added the Group widget checks if it is of class \fIXfwfToggle\fP or a
subclass thereof. If so, the Group widget installs a callback in it.
When the toggle button is then activated, the Group widget determines
which other buttons need to be turned off. All toggle buttons are
given an implicit number. The first one to be added is number 0.

There are three selection styles, settable through the
\fIselectionStyle\fP resource:

1) `single' (\fIXfwfSingleSelection\fP) means that at most one of the
toggle buttons may be on, but it is possible that they are all off.
When one of the buttons is turned on, all others are turned off
automatically. The resource \fIselection\fP holds the number of the button
that is on, or -1 if they are all off.

2) `one' (\fIXfwfOneSelection\fP) means that at all times exactly one
button is turned on. It is not possible to turn buttons off, except by
toggling another one to on. The resource \fIselection\fP holds the number
of the button that is currently on.

3) `multi' or `multiple' (\fIXfwfMultipleSelection\fP) means that any
number of buttons may be on. No buttons are turned off automatically.
The resource \fIselection\fP has one bit set for each button that is on.
Thus, if buttons 1, 4 and 5 are on, the value of \fIselection\fP is (1<<1
+ 1<<4 + 1<<5 =) 0x62. Note that this limits the number of buttons
that is recorded in \fIselection\fP to the first 32. It is still possible
to have more buttons, but the application will then have to use
callbacks or other means to keep track of the toggle buttons.

4) `none' (\fIXfwfNoSelection\fP) turns off any special handling of toggle
buttons. The value of the \fIselection\fP resource is undefined.

Applications may of course install callbacks on the toggle buttons,
but a simpler way is to attach to the \fIactivateCallback\fP of the Group
widget itself, or use no callback at all and simply inspect the
\fIselection\fP resource when needed.

It is recommended that application visually differentiate between
selection styles. One way would be to use different graphics in the
toggle buttons, e.g., the Motif convention that radiobuttons have an
empty or colored diamond, and non-exclusive toggles a square.
Suitable icons are already defined by the Common widget.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfGroup
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNselectionStyle	XtCSelectionStyle	SelectionType 	XfwfSingleSelection 
XtNselection	XtCSelection	long 	0 
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps +2

.TP
.I "XtNlabel"
The label must be a single line. It is displayed superimposed on the
frame, in the upper lefthand corner. Currently, it must be simple
string in a single font.

	

.TP
.I "XtNfont"
The font for the label is set with \fIfont\fP.

	

.TP
.I "XtNforeground"
The foreground color is the color used to draw the text.

	

.TP
.I "XtNselectionStyle"
The \fIselectionStyle\fP resource determines how the Group widget treats
the child widgets that are of class \fIXfwfToggle\fP or a subclass
thereof. The possible values are \fIXfwfNoSelection\fP,
\fIXfwfSingleSelection\fP (default), \fIXfwfOneSelection\fP and
\fIXfwfMultipleSelection\fP. The meaning is as explained above. There is a
converter from strings, that recognizes the strings `no', `none',
`single', `one', `multi', and `multiple', in upper or lower case.

	

.TP
.I "XtNselection"
The resource \fIselection\fP holds the state of the toggle buttons (if
any). If \fIselectionType = XfwfSingleSelection\fP or \fIXfwfOneSelection\fP,
it holds the number of the buttons that is currently on, or -1 if they
are all off. If \fIselectionType = XfwfMultipleSelection\fP, it is a
bitmap with one bit set for each button that is on. (See the
introduction above for more information.)

The value can also be set (e.g., through \fIXtSetValues\fP); the result is
that the corresponding toggle buttons will be turned on or off.

	

.TP
.I "XtNactivate"
The callback \fIactivate\fP can be used by applications that want to be
informed of any change to the state of the toggle buttons as soon as
it happens. Other applications can simply use \fIXtGetValues\fP to get the
value of the \fIselection\fP resource. The callback will be called with
the value of \fIselection\fP as \fIcall_data\fP argument.

	

.TP
.I "XtNframeType"
The default border type is different from that of its superclass
RowCol. It is set to \fIXfwfChiseled\fP because that is the conventional
border type around radio buttons, and because it looks better when
there is a label superimposed on it.

	

.TP
.I "XtNinnerOffset"
The default value for \fIinnerOffset\fP is set to 3 pixels, which makes
it a little bit more likely that the descenders of the label will stay
visible.

	

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfRowCol
Name	Class	Type	Default
XtNstoreByRow	XtCStoreByRow	Boolean 	True 
XtNrows	XtCRows	Int 	0 
XtNcolumns	XtCColumns	Int 	0 
XtNalignment	XtCAlignment	Alignment 	XfwfTopLeft 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNuserData	XtCUserData	Pointer	NULL 
XtNxcc	XtCXCc	XCC 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The \fISelectionType\fP type is exported to the public header file.

	

.nf

.B type
 SelectionType = enum {
                XfwfNoSelection, XfwfSingleSelection,
                XfwfOneSelection, XfwfMultipleSelection }
.fi

