.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfTextMenu
.SH DESCRIPTION
The TextMenu widget implements a simple menu, consisting of a
series of labels. It is called `TextMenu' because it has no support
for anything other than simple strings to be displayed.

The contents of the menu are defined by the \fImenu\fP resource. The
syntax of the description is given further on. When a menu item is
selected, a callback function is called with the number of the item
and the label as \fIcall_data\fP argument (numbering starts at 0).

When the user moves from one menu item to another, another callback is
called. This callback is called even for inactive (grayed out) items.
It can be used, for example, to display an explanation of the selected
item while the mouse is on it.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfTextMenu
Name	Class	Type	Default
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNtablist	XtCTablist	String 	NULL 
XtNmenu	XtCMenu	String 	"empty"
XtNactive	XtCActive	long 	0xFFFFFFFF 
XtNselection	XtCSelection	int 	-1 
XtNcursor	XtCCursor	Cursor 	"arrow"
XtNactivate	XtCActivate	Callback	NULL 
XtNchangeSelection	XtCChangeSelection	Callback	NULL 

.TE
.ps +2

.TP
.I "XtNfont"
Currently, the menu items are all in one font.

	

.hi
<FontStruct> XFontStruct * font = <String>XtDefaultFont 
.eh

.TP
.I "XtNforeground"
The color of the text is likewise uniform.

	

.hi
Pixel  foreground = <String>XtDefaultForeground 
.eh

.TP
.I "XtNtablist"
A tablist can be provided for tabbing to particular columns
within the label. The string consists of numbers separated by one or
more blanks. Each number is an offset in pixels from the left edge of
the widget.

	

.hi
String  tablist = NULL 
.eh

.TP
.I "XtNmenu"
The menu is a string with labels separated by newlines. Each line is
an item, except when the line consists of nothing but blanks and
dashes. The menu will show a horizontal line there. Each menu item may
have a shortcut letter, indicated by an underline in front of the
letter.  Here is an example:

\fI"_New\\n_Save\\nSave _As\\n----\\nE_xit"\fP

The shortcut letters will be underlined in the menu.  Note that
neither resources in a resource database nor hardcoded resources in a
program may contain actual newlines. In a resource file, the newlines
can be given as \fI\\n\fP, in a C program they must be written as \fI\\\\n\fP.
The resource manager will automatically convert them to actual
newlines just before they are assigned to the \fImenu\fP resource.

	

.hi
String  menu = "empty"
.eh

.TP
.I "XtNactive"
Item \fIN\fP is active when bit \fIN\fP in \fIactive\fP is set, otherwise it is
grayed out. There is only room for 32 items in this resource, if there
are more than 32 items in the menu (a bad idea anyway!) the rest of
the items will always be active.

	

.hi
long  active = 0xFFFFFFFF 
.eh

There should probably be more resources to control placement of the
labels, such as margins, interline spacing, etc. For the moment, we'll
keep it simple.

.TP
.I "XtNselection"
When an item is selected, either with the mouse or with the
keyboard, the number of the selected item is stored in \fIselection\fP.
This resource can also be set by the application to indicate which
item should be highlighted when the menu opens. (When a mouse is used,
this has no effect, of course.) Items are numbered starting at 0. The
value is -1 if no item is selected. If an inactive item is selected,
the value is stored in \fIselection\fP, but the item is not highlighted.

	

.hi
int  selection = -1 
.eh

.TP
.I "XtNcursor"
The cursor (when not \fINone\fP) is the mouse cursor that is displayed
when the mouse is over the widget. The value \fINone\fP causes the
parent's cursor to be used.

	

.hi
Cursor  cursor = <String>"arrow"
.eh

.TP
.I "XtNactivate"
The \fIactivate\fP callback is called when the user has completed a
selection. Usually that means that he released the mouse on an item or
pressed Return. When the mouse is released outside the menu or on an
inactive item, the callback is not called.  The number of the item and
the label are passed as the \fIcall_data\fP argument (of type
\fIXfwfTextMenuData*\fP). Items are numbered from 0. Inactive items are
numbered as well.

	

.hi
<Callback> XtCallbackList  activate = NULL 
.eh

.TP
.I "XtNchangeSelection"
When the user moves from one item to another, the \fIchangeSelection\fP
callback is called, with the number of the new selection as
\fIcall_data\fP. This callback is called even when the new selection is an
inactive (grayed out) item. It is also called when the mouse leaves
the menu, in which case the first part of the \fIcall_data\fP argument
will be -1. The \fIcall_data\fP is of type \fIXfwfTextMenuData*\fP.

	

.hi
<Callback> XtCallbackList  changeSelection = NULL 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Shell
Name	Class	Type	Default
allowShellResize	XtCAllowShellResize	Boolean 	False 
createPopupChildProc	XtCCreatePopupChildProc	XTCreatePopupChildProc 	NULL 
XtNgeometry	XtCGeometry	String 	NULL 
overrideRedirect	XtCOverrideRedirect	Boolean 	False 
popdownCallback	XtCPopdownCallback	Callback	NULL 
popupCallback	XtCPopupCallback	Callback	NULL 
saveUnder	XtCSaveUnder	Boolean 	False 
XtNvisual	XtCVisual	Visual *	CopyFromParent 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The \fIcall_data\fP of the callback functions is set to a struct with
two fields. The first is the number of the item (starting at 0), the
second is a pointer to the label. Note that it is only a pointer; the
receiver should make a local copy if the label is to be edited.

	

.nf

.B type
 XfwfTextMenuData = struct {
	    int n;
	    String label;
	}
.fi

.SS "Translations"

The translations react both to the mouse and to key presses. A mouse
release causes the menu to pop down. If the mouse was on an active
item at the time, the \fIactivate\fP callback will be called. The Enter
key also pops down the menu. Mouse movement is translated to changes
in highlights, ditto for the up and down cursor keys.

	

.nf
<EnterWindow>: highlight() 
.fi

.nf
<LeaveWindow>: highlight() 
.fi

.nf
<BtnUp>: XtMenuPopdown() notify() 
.fi

.nf
<BtnMotion>: highlight() 
.fi

.nf
<Key>Return: XtMenuPopdown() notify() 
.fi

.nf
<Key>Escape: XtMenuPopdown() 
.fi

.nf
<Key>Up: previous() 
.fi

.nf
<Key>Down: next() 
.fi

.nf
<Key>: shortcut() 
.fi

.nf
<Map>: init() add_keyboard_grab() 
.fi

.nf
<Unmap>: remove_keyboard_grab() 
.fi

.hi
.SS "Actions"

.TP
.I "init

When the menu appears because of a key press, one of the items
should be highlighted. The \fIinit\fP action checks the type of event and
the \fIselection\fP variable.

.hi

.nf
void init($, XEvent* event, String* params, Cardinal* num_params)
{
    if ($selection < 0) XtVaSetValues($, XtNselection, 0, NULL);
}
.fi

.eh

.TP
.I "add_keyboard_grab

.hi

.nf
void add_keyboard_grab($, XEvent* event, String* params, Cardinal* num_params)
{
    XtGrabKeyboard($, False, GrabModeAsync, GrabModeAsync, CurrentTime);
}
.fi

.eh

.TP
.I "remove_keyboard_grab

.hi

.nf
void remove_keyboard_grab($, XEvent* event, String* params, Cardinal* num_params)
{
    XtUngrabKeyboard($, CurrentTime);
}
.fi

.eh

.TP
.I "highlight

The \fIhighlight\fP action determines which item is selected by looking
at the coordinates of the mouse. The previous selection, if any, is
drawn in normal colors again and the new one, if any, is shown in
reverse. If the selection changed, the \fIchangeSelection\fP callback is
called.

.hi

.nf
void highlight($, XEvent* event, String* params, Cardinal* num_params)
{
    int newsel, x = event->xbutton.x, y = event->xbutton.y;
    XfwfTextMenuData data;

    if (x < 0 || x >= $width)			/* Pointer outside menu */
	newsel = -1;
    else					/* Pointer inside menu */
	for (newsel = $nitems - 1; newsel >= 0; newsel--)
	    if ($offset[newsel] <= y  y < $offset[newsel] + $itemheight)
		break;
    if (newsel != $selection) {
	if ($selection >= 0  is_active($selection))
	    draw_normal($, $selection);
	if (newsel >= 0  is_active(newsel))
	    draw_highlight($, newsel);
	$selection = newsel;
	data.n = $selection;
	data.label = $item[$selection];
	XtCallCallbackList($, $changeSelection, data);
    }
}
.fi

.eh

.TP
.I "notify

The \fInotify\fP action invokes the \fIactivate\fP callback, unless the
current selection is inactive or there is no selection.

.hi

.nf
void notify($, XEvent* event, String* params, Cardinal* num_params)
{
    XfwfTextMenuData data;

    if (*num_params != 0)
	sscanf(params[0], "%d", $selection);
    if ($selection >= 0  is_active($selection)) {
	data.n = $selection;
	data.label = $item[$selection];
	XtCallCallbackList($, $activate, data);
    }
}
.fi

.eh

.TP
.I "previous

The \fIprev\fP action moves the highlight up one item, skipping inactive
items. If there are no more items above the current one, the action
does nothing. The \fIchangeSelection\fP callback is called when there was
a change in selection.

.hi

.nf
void previous($, XEvent* event, String* params, Cardinal* num_params)
{
    int newsel;
    XfwfTextMenuData data;

    for (newsel = $selection - 1; newsel >= 0; newsel--)
	if (is_active(newsel)) break;
    if (newsel >= 0) {
	if (is_active($selection)) draw_normal($, $selection);
	draw_highlight($, newsel);
	$selection = newsel;
	data.n = $selection;
	data.label = $item[$selection];
	XtCallCallbackList($, $changeSelection, data);
    }
}
.fi

.eh

.TP
.I "next

The \fInext\fP action is analogous.

.hi

.nf
void next($, XEvent* event, String* params, Cardinal* num_params)
{
    int newsel;
    XfwfTextMenuData data;

    for (newsel = $selection + 1; newsel < $nitems; newsel++)
	if (is_active(newsel)) break;
    if (newsel < $nitems) {
	if ($selection >= 0  is_active($selection))
	    draw_normal($, $selection);
	draw_highlight($, newsel);
	$selection = newsel;
	data.n = $selection;
	data.label = $item[$selection];
	XtCallCallbackList($, $changeSelection, data);
    }
}
.fi

.eh

.TP
.I "shortcut

The \fIshortcut\fP action is normally called on a keypress.  The first
argument (if any) is a number in decimal representation, indicating
for which item this is a shortcut. If there is nu argument, the
keypress is taken from the event and looked up in the \fIshortcut\fP
array. If the keypress is a valid shortcut, the menu pops down and the
\fIactivate\fP callback will be called, unless the item is not active.

.hi

.nf
void shortcut($, XEvent* event, String* params, Cardinal* num_params)
{
    int newsel, n;
    XfwfTextMenuData data;
    char buf[3];

    if (*num_params == 1) {
	newsel = atol(params[0]);
	if (newsel < 0 || newsel >= $nitems) {
	    XtWarning("Incorrect arguments for shortcut action");
	    return;
	}
	if (newsel == $selection || ! is_active(newsel)) return;
    } else if (*num_params == 0) {
	n = XLookupString(event->xkey, buf, sizeof(buf), NULL, NULL);
	if (n != 1) return;
	for (newsel = 0; newsel < $nitems; newsel++)
	    if (toupper($shortcut[newsel]) == toupper(buf[0])) break;
	if (newsel == $nitems || ! is_active(newsel)) return;
    } else {
	XtWarning("Incorrect arguments for shortcut action");
	return;
    }
    $selection = newsel;
    XtPopdown($);
    data.n = $selection;
    data.label = $item[$selection];
    XtCallCallbackList($, $activate, data);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <X11/Xmu/CharSet.h>
.fi

.nf

.B incl
 "stip4.bm"
.fi

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/TabString.h>
.fi

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.nf

.B incl
 <X11/Xmu/Converters.h>
.fi

.nf

.B incl
 <ctype.h>
.fi

.hi

.hi
.SS "Private variables"

The number of items is kept in \fInitems\fP.

	

.nf
Cardinal  nitems
.fi

The shortcut letters for each item are collected in the \fIshortcut\fP
array.

	

.nf
char * shortcut
.fi

The vertical offsets of each of the menu items is computed and
stored in an array \fIoffset\fP.

	

.nf
Position * offset
.fi

The labels in the \fImenu\fP string are put into an array \fIitem\fP.

	

.nf
String * item
.fi

The positions of the horizontal lines are stored in a
null-terminated array \fIline\fP

	

.nf
Position * line
.fi

The GC \fIgc\fP holds the font, foreground and background for active
items that are not selected. It is also used for the horizontal lines.

	

.nf
GC  gc
.fi

\fIrvgc\fP is for items that are highlighted, which is achieved by
swapping foreground and background.

	

.nf
GC  rvgc
.fi

For graying out the text, another GC is used.

	

.nf
GC  graygc
.fi

The tablist is converted from string format to a list of int's for speed.

	

.nf
int * tabs
.fi

The height of each line is also stored in a private variable.
Currently it is just the font ascent plus the font descent, but in
future it may be something else.

	

.nf
int  itemheight
.fi

.hi

.hi
.SS "Methods"

The conversion from string to long is needed for the \fIactive\fP
resource.

.nf
class_initialize()
{
    XtAddConverter(XtRString, XtRLong, XmuCvtStringToLong, NULL, 0);
    XtSetTypeConverter(XtRLong, XtRString, XfwfCvtLongToString,
		       NULL, 0, XtCacheNone, NULL);
}
.fi

The \fIinitialize\fP methods creates the first GC's and initializes the
private variables. It sets the GC's to \fINULL\fP and then calls utility
routines to actually create them.

The \fItabs\fP and \fIitemheight\fP variables must be given values before
\fIparse_item\fP is called.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($menu) $menu = XtNewString($menu);
    $itemheight = $font->ascent + $font->descent;
    $tablist = XtNewString($tablist);
    $tabs = XfwfTablist2Tabs($tablist);
    $offset = NULL;
    $item = NULL;
    $line = NULL;
    $shortcut = NULL;
    parse_menu($);
    $gc = NULL; make_gc($);
    $rvgc = NULL; make_rvgc($);
    $graygc = NULL; make_graygc($);
    XtAddCallback($, XtNpopupCallback, add_cursor_cb, NULL);
}
.fi

The \fIset_values\fP method checks if any of the resources changed. If
the menu changed, it is parsed again to set the private variables. The
\fItablist\fP is also parsed.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Boolean need_redraw = False;

    if ($old$font != $font) {
	$itemheight = $font->ascent + $font->descent;
	need_redraw = True;
    }
    if ($old$foreground != $foreground) {
	need_redraw = True;
    }
    if ($old$tablist != $tablist) {
	myfree($old$tablist);
	$tablist = XtNewString($tablist);
	myfree($old$tabs);
	$tabs = XfwfTablist2Tabs($tablist);
	need_redraw = True;
    }
    if ($old$menu != $menu) {
	myfree($old$menu);
	$menu = XtNewString($menu);
	parse_menu($);
	need_redraw = True;
    }
    if ($old$active != $active) {
	need_redraw = True;
    }
    if ($old$selection != $selection) {
	need_redraw = True;
    }
    return need_redraw;
}
.fi

The \fIexpose\fP method simply draws each of the labels, using the
appropriate utility function. Horizontal lines are drawn between items
that are separated by dashes in the \fImenu\fP.

.nf
expose($, XEvent * event, Region  region)
{
    Cardinal i;

    if (! XtIsRealized($)) return;
    for (i = 0; i < $nitems; i++)
	if (! is_active(i)) draw_grayed($, i);
	else if (i == $selection) draw_highlight($, i);
	else draw_label($, i, $gc);
    if ($line)
	for (i = 0; $line[i]; i++)
	    XDrawLine(XtDisplay($), XtWindow($), $gc, 0, $line[i],
		      $width, $line[i]);
}
.fi

The \fIdestroy\fP method is needed to reclaim heap memory when the
widget is destroyed. The widget has allocated a few strings and
arrays, which must be freed again. (\fIdestroy\fP is upward chained, we
only need to dispose of heap space thas has been allocated in the
TextMenu class itself.)

.nf
destroy($)
{
    int i;

    for (i = 0; i < $nitems; i++) myfree($item[i]);
    myfree($tablist); myfree($tabs); myfree($menu); myfree($shortcut);
    myfree($offset); myfree($item); myfree($line);
    XtReleaseGC($, $gc); XtReleaseGC($, $rvgc); XtReleaseGC($, $graygc);
}
.fi

.hi

.hi
.SH "Utilities"

The \fIis_active\fP macro returns true if item \fIn\fP is active.

\fBdef\fP is_active(n) =
(n >=8 *sizeof ($active )||($active (1 <<n )))

The \fIXtRealloc\fP function wants to see \fIchar*\fP arguments, which is
rather inconvenient.

\fBdef\fP myrealloc(p, size) =
((XtPointer )XtRealloc ((char *)p ,size ))

\fBdef\fP mymalloc(size) =
((XtPointer )XtMalloc (size ))

\fBdef\fP myfree(p) =
XtFree ((XtPointer )p )

The margin between the frame and the text is given by the constant
\fIMARGIN\fP.  It may in future be replaced by a resource.

\fBdef\fP MARGIN = 5 

The \fIdraw_label\fP routine draws the text of item \fIn\fP with the given
GC and underlines the shortcut key.

.nf
draw_label($, int  n, GC  gc)
{
    Cardinal i, j;
    Dimension w, w1;
    Position y;
    Display *dpy = XtDisplay($);
    Window win = XtWindow($);
    String s;

    y = $offset[n] + $font->ascent;
    i = 0;
    s = $item[n];
    for (j = i; s[j]  s[j] != '\\n'  s[j] != '_'; j++) ;
    XfwfDrawImageString(dpy, win, gc, MARGIN, y, s, j - i, $tabs);
    if (s[j] == '_') {
	w = XfwfTextWidth($font, s, j - i, $tabs);
	i = j + 1;
	w1 = XTextWidth($font, s + i, 1);
	for (j = i; s[j]  s[j] != '\\n'; j++) ;
	XfwfDrawImageString(dpy, win, gc, MARGIN + w, y, s + i, j - i,
			    $tabs);
	XDrawLine(dpy, win, gc, MARGIN + w, y + 2, MARGIN + w + w1 - 1,
		  y + 2);
    }
}
.fi

The \fIdraw_normal\fP routine draws item \fIn\fP in normal colors.  Note
that this routine first clears the area, to remove any previous
highlighting. It should therefore notbe used from \fIexpose\fP, since that
method always draws on a window that is already cleared.

.nf
draw_normal($, int  n)
{
    XFillRectangle(XtDisplay($), XtWindow($), $rvgc, MARGIN,
		   $offset[n], $width - 2 * MARGIN, $itemheight);
    draw_label($, n, $gc);
}
.fi

The \fIdraw_highlight\fP routine draws item \fIn\fP in reversed colors.

.nf
draw_highlight($, int  n)
{
    XFillRectangle(XtDisplay($), XtWindow($), $gc, MARGIN,
		   $offset[n], $width - 2 * MARGIN, $itemheight);
    draw_label($, n, $rvgc);
}
.fi

The \fIdraw_grayed\fP routine draws item \fIn\fP grayed out.

.nf
draw_grayed($, int  n)
{
    draw_label($, n, $gc);
    XFillRectangle(XtDisplay($), XtWindow($), $graygc, MARGIN,
		   $offset[n], $width - 2 * MARGIN, $itemheight);
}
.fi

The menu string is parsed and the result is stored in a number of
private variables by the \fIparse_menu\fP routine. The string is split
into lines, each line is either a label or a horizontal line. If it is
a label it may have a shortcut key, indicated by an underline in front
of the letter.

\fIparse_menu\fP also sets the \fIwidth\fP and \fIheight\fP of the widget. This is
allowed, since the funtion is only called inside \fIinitialize\fP and
\fIset_values\fP.

\fBdef\fP LINEWD = 2 

.nf
parse_menu($)
{
    Cardinal i, j, nlines = 0, p, q, n, ai, accellen = 0;
    Bool is_line, accel, has_accel;
    char key, h[1024], accelerator[100], *all_accel = NULL;
    Position y = MARGIN;
    Dimension w;

    $width = 1;
    n = 0;
    i = 0;
    fprintf(stderr, "Parsing:\\n%s\\n", $menu);
    while ($menu[i]) {
	is_line = TRUE;
	has_accel = accel = FALSE;
	ai = 0;
	key = '\\0';
	for (; isspace($menu[i]); i++) ;
	for (j = i; $menu[j] != '\\0'  $menu[j] != '\\n'; j++) {
	    if ($menu[j] == ']') accel = FALSE;
	    if (accel) accelerator[ai++] = $menu[j];
	    if ($menu[j] == '[') has_accel = accel = TRUE;
	    if ($menu[j] == '_') key = $menu[j+1];
	    if ($menu[j] != '-'  $menu[j] != ' ') is_line = False;
	}
	if (is_line) {
	    nlines++;
	    $line = myrealloc($line, (nlines + 1) * sizeof(*$line));
	    $line[nlines-1] = y + MARGIN;
	    y += LINEWD + 2 * MARGIN;
	    $line[nlines] = 0;
	} else {
	    $item = myrealloc($item, (n + 1) * sizeof(*$item));
	    $item[n] = mymalloc((j - i + 1) * sizeof(*$item[n]));
	    $item[n][0] = '\\0'; strncat($item[n], $menu[i], j - i);
	    fprintf(stderr, "Item %d: %s\\n", n, $item[n]);
	    w = XfwfTextWidth($font, $menu[i], j - i, $tabs);
	    /* The width includes an extra '_'; is that serious? */
	    if (w > $width) $width = w;
	    $offset = myrealloc($offset, (n + 1) * sizeof(*$offset));
	    $offset[n] = y;
	    y += $itemheight;
	    $shortcut = myrealloc($shortcut, (n + 1) * sizeof(*$shortcut));
	    $shortcut[n] = key;
	    n++;
	}
	if (has_accel) {			/* Create accelerator */
	    int hlen;
	    accelerator[ai] = '\\0';
	    hlen = sprintf(h, "%s: notify(\\"%d\\")\\n", accelerator, n - 1);
	    accellen += hlen;
	    all_accel = myrealloc(all_accel, accellen + 1);
	    strcat(all_accel, h);
	    fprintf(stderr, "Accelerator: %s\\n", h);
	}
	i = $menu[j] == '\\0' ? j : j + 1;
    }
    $nitems = n;
    $height = y + MARGIN;
    $width += 2 * MARGIN;
    if (all_accel) {
	XtVaSetValues($, XtVaTypedArg, XtNaccelerators, XtRString,
		      all_accel, accellen + 1, NULL);
	fprintf(stderr, "Accelerators:\\n%s\\n", all_accel);
    }
}
.fi

The \fImake_gc\fP routine creates the GC for the normal, unhighlighted
text and for the horizontal lines.

.nf
make_gc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($gc != NULL) XtReleaseGC($, $gc);
    values.background = $background_pixel;
    values.foreground = $foreground;
    values.font = $font->fid;
    values.line_width = LINEWD;
    mask = GCFont | GCBackground | GCForeground | GCLineWidth;
    $gc = XtGetGC($, mask, values);
}
.fi

The \fImake_rvgc\fP routine creates the GC for the highlighted text.

.nf
make_rvgc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($rvgc != NULL) XtReleaseGC($, $rvgc);
    values.foreground = $background_pixel;
    values.background = $foreground;
    values.font = $font->fid;
    mask = GCFont | GCBackground | GCForeground;
    $rvgc = XtGetGC($, mask, values);
}
.fi

The \fImake_graygc\fP routine creates a GC for graying out the text. It
contains a stipple in the background color, that will be applied over
the text.

.nf
make_graygc($)
{
    XtGCMask mask;
    XGCValues values;

    if ($graygc != NULL) XtReleaseGC($, $graygc);
    values.foreground = $background_pixel;
    values.stipple =
	XCreateBitmapFromData(XtDisplay($),
			      RootWindowOfScreen(XtScreen($)),
			      stip4_bits, stip4_width, stip4_height);
    values.fill_style = FillStippled;
    mask = GCForeground | GCStipple | GCFillStyle;
    $graygc = XtGetGC($, mask, values);
}
.fi

The \fIadd_cursor_cb\fP callback routine is attached to the
\fIpopupCallback\fP. It will set the cursor in the menu.

.nf
add_cursor_cb($, XtPointer  client_data, XtPointer  call_data)
{
    XChangeActivePointerGrab(XtDisplay($), ButtonPressMask |
			     ButtonReleaseMask | EnterWindowMask |
			     LeaveWindowMask | PointerMotionMask, $cursor,
			     XtLastTimestampProcessed(XtDisplay($)));
}
.fi

.hi
