.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfScrolledWindow3
.SH DESCRIPTION
The ScrolledWindow3 widget is a composite widget that contains 4
Boards and two scroll bars. The first Board is a small area in the top
left corner, where a label widget can be put. A Board along the top
and one along the left side are used for column and row titles
(usually Label widgets). The two scroll bars are along the right side
and the bottom. In the middle is the largest board, in which the main
data will be displayed.

A widget is added as the child of the large Board is called the
`controlled widget' (CW), The widget that is put in the top Board is
called the `column controlled widget' (CCW), the widget that is put in
the left Board is the `row controlled widget' (RCW).

Usually, the controlled widgets are larger than the Boards, and their
origins will have negative x and y coordinates. They are moved about
inside the Boards by the ScrolledWindow3, in reaction to the user
clicking on the scrollbars. The CCW moves left/right, the RCW moves
up/down, the CW moves in all directions. The controlled widgets are
therefore clipped by the Boards.

The first child widget attached to ScrolledWindow3 becomes the child
of the top left Board. The second child widget becomes the CCW, the
third the RCW, and the fourth the CW.

The CCW is typically a Label widget with a tablist to provide column
headers, and only scrolls horizontally. The CW is typically a
single column MultiList widget with a tablist, and scrolls boths
horizontally and vertically.

The ScrolledWindow3 provides a callback, but most application will not
need it, since the ScrolledWindow3 already moves the CW. The callback
is invoked AFTER the CW is moved.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfScrolledWindow3
Name	Class	Type	Default
XtNspacing	XtCSpacing	Dimension 	4 
XtNscrollbarWidth	XtCScrollbarWidth	Dimension 	22 
XtNcolHdrHeight	XtCColHdrHeight	Dimension 	22 
XtNrowHdrWidth	XtCRowHdrWidth	Dimension 	22 
XtNshadowWidth	XtCShadowWidth	Dimension 	2 
XtNhideHScrollbar	XtCHideHScrollbar	Boolean 	False 
XtNhideVScrollbar	XtCHideVScrollbar	Boolean 	False 
XtNvScrollAmount	XtCVScrollAmount	int 	20 
XtNhScrollAmount	XtCHScrollAmount	int 	copy_vScrollAmount 
XtNinitialX	XtCInitialX	Position 	0 
XtNinitialY	XtCInitialY	Position 	0 
XtNscrollCallback	XtCScrollCallback	Callback	NULL 
XtNscrollResponse	XtCScrollResponse	XtCallbackProc 	scroll_response 

.TE
.ps +2

.TP
.I "XtNspacing"
By default, the Board widget, Frame widget and the Scrollbars are
placed 4 pixels from each other and from the edges of the ScrolledWindow3
itself.

	

.hi
Dimension  spacing = 4 
.eh

.TP
.I "XtNscrollbarWidth"
The width of the scrollbars can be set with the \fIscrollbarWidth\fP
resource. The default is 22 pixels.

	

.hi
Dimension  scrollbarWidth = 22 
.eh

.TP
.I "XtNcolHdrHeight"
The height of the Board widget to contain the CCW can be set with
the \fIcolHdrHeight\fP resource. The default is 22 pixels. The width of
the Board to contain the RCW is \fIrowHdrWidth\fP, by default also 22
pixels.

	

.hi
Dimension  colHdrHeight = 22 
.eh

.TP
.I "XtNrowHdrWidth"

.hi
Dimension  rowHdrWidth = 22 
.eh

.TP
.I "XtNshadowWidth"
The scrollbars and the frame have the same shadow frame. (The board
has no border or frame.) The width of both is set with a single
resource: \fIshadowWidth\fP. The style of the shadow cannot be changed. It
will always be \fIXfwfSunken\fP.

	

.hi
Dimension  shadowWidth = 2 
.eh

.TP
.I "XtNhideHScrollbar"
It is possible to switch off the display of the scrollbars, with the
following two resources: \fIhideHScrollbar\fP is by default \fIFalse\fP.

	

.hi
Boolean  hideHScrollbar = False 
.eh

.TP
.I "XtNhideVScrollbar"
\fIhideVScrollbar\fP is also by default \fIFalse\fP.

	

.hi
Boolean  hideVScrollbar = False 
.eh

.TP
.I "XtNvScrollAmount"
When the arrows of the scrollbars are clicked, the controlled widgets
will be moved a fixed number of pixels in the indicated direction. The
distance can be set separately for horizontal and vertical movement.
E.g., if the controlled widget displays text, it is a good idea to set
the vertical scroll distance to the height of one line of text.

	

.hi
int  vScrollAmount = 20 
.eh

.TP
.I "XtNhScrollAmount"
The horizontal amount is by default copied from the vertical amount.

	

.hi
int  hScrollAmount = <CallProc>copy_vScrollAmount 
.eh

.TP
.I "XtNinitialX"
The initial position of the CCW and CW can be set with the resources
\fIinitialX\fP and \fIinitialY\fP. Both are given in pixels and must be zero
or negative.

	

.hi
Position  initialX = 0 
.eh

.TP
.I "XtNinitialY"
\fIinitialY\fP is for the vertical position.

	

.hi
Position  initialY = 0 
.eh

.TP
.I "XtNscrollCallback"
The callback is passed a pointer to an \fIXfwfScrollInfo\fP structure,
which is defined as \fIstruct { XfwfSReason reason; XfwfSFlags flags;
float vpos, vsize, hpos, hsize; }\fP The \fIreason\fP can be:

* \fIXfwfSUp\fP: if the user clicked (or holds) the up arrow.

* \fIXfwfSLeft\fP: ditto left arrow.

* \fIXfwfSDown\fP: ditto down arrow.

* \fIXfwfSRight\fP: ditto right arrow.

* \fIXfwfSPageUp\fP: ditto area above thumb.

* \fIXfwfSPageDown\fP: ditto area below thumb.

* \fIXfwfSPageLeft\fP: ditto area left of thumb.

* \fIXfwfSPageRight\fP: ditto area right of thumb.

* \fIXfwfSDrag\fP: if the user drags one of the thumbs.

* \fIXfwfSMove\fP: if the user stops dragging the thumb.

* \fIXfwfSTop\fP: if the user requests to scroll all the way up.

* \fIXfwfSBottom\fP: same all the way down.

* \fIXfwfSLeftSide\fP: same to the left side.

* \fIXfwfSRightSide\fP: same to the right side.

Note that when the callback is called, the controlled window has
already been moved.

	

.hi
<Callback> XtCallbackList  scrollCallback = NULL 
.eh

.TP
.I "XtNscrollResponse"
To set the scrolled window to a particular position, the
scrollResponse function must be used. The function has the type of a
callback function and it must be retrieved with a call to
\fIXtGetValues\fP.

	

.hi
XtCallbackProc  scrollResponse = scroll_response 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

To set the position of a scrolling widget from an application, one
could use \fIXtGetValues\fP to get the \fIscrollResponse\fP resource and then
call the returned function. The \fIXfwfScrollTo\fP function is a utility
function that makes this more convenient. Its arguments are a widget,
and \fIx\fP and \fIy\fP values (both must be between 0.0 and 1.0). It will
scroll the widget and all other connected scrolling widgets to the
indicated offset.

Note that this function is not tied to the ScrolledWindow3 widget: it
works with every widget that implements the FWF SWIP (Scrolling Widget
Interface Policy).

.nf
XfwfScrollTo( $, double  x, double  y)
.fi

.hi
{
    XtCallbackProc f = NULL;
    XfwfScrollInfo info;

    XtVaGetValues($, XtNscrollResponse, f, NULL);
    if (f == NULL) {
	XtWarning("XfwfScrollTo called for non-scrolling widget.");
	return;
    }
    info.flags = XFWF_VPOS | XFWF_HPOS;
    info.reason = XfwfSMove;
    info.hpos = x;
    info.vpos = y;
    f(NULL, $, info);
}
.eh

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/Frame.h>
.fi

.nf

.B incl
 <Xfwf/Board.h>
.fi

.nf

.B incl
 <Xfwf/VScrollb.h>
.fi

.nf

.B incl
 <Xfwf/HScrollb.h>
.fi

.nf

.B incl
 <Xfwf/scroll.h>
.fi

.hi

.hi
.SS "Private variables"

The ScrolledWindow2 widget has exactly four children, two grandchildren,
and one grandgrandchild. For convenience they are stored in private
variables as well as in the \fIchildren\fP field.

	

.nf
Widget  ulboard
.fi

.nf
Widget  CORNER
.fi

.nf
Widget  cboard
.fi

.nf
Widget  CCW
.fi

.nf
Widget  rboard
.fi

.nf
Widget  RCW
.fi

.nf
Widget  vscroll
.fi

.nf
Widget  hscroll
.fi

.nf
Widget  frame
.fi

.nf
Widget  board
.fi

.nf
Widget  CW
.fi

The variable \fIinitializing\fP is set to \fITrue\fP in the \fIinitialize\fP
method, so that the \fIinsert_child\fP method can see that the inserted
child is one of the three proper children.

	

.nf
Boolean  initializing
.fi

The scroll bars have scrollResponse function, that will be called if
the scrolled window itself received a call to its scrollResponse
function.

	

disabled, 15 Jun '94
 var XtCallbackProc vscroll_resp
	

 var XtCallbackProc hscroll_resp

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method creates the six child widgets and the
grandchild and sets the controlled widgets to NULL. The resources of
the children are set to fixed values and some of the ScrolledWindow's
resources are copied. The board widget will automatically be set to
the correct size by the frame widget in which it is contained.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    $initializing = True;
    if ($initialX > 0) $initialX = 0;
    if ($initialY > 0) $initialY = 0;
    $CORNER = NULL;
    $CCW = NULL;
    $RCW = NULL;
    $CW = NULL;
    $ulboard = XtVaCreateManagedWidget
	("_ulboard", xfwfBoardWidgetClass, $, XtNframeWidth, 0,
	 XtNborderWidth, 0, XtNhighlightThickness, 0, NULL);
    $cboard = XtVaCreateManagedWidget
	("_cboard", xfwfBoardWidgetClass, $, XtNframeWidth, 0,
	 XtNborderWidth, 0, XtNhighlightThickness, 0, NULL);
    $rboard = XtVaCreateManagedWidget
	("_rboard", xfwfBoardWidgetClass, $, XtNframeWidth, 0,
	 XtNborderWidth, 0, XtNhighlightThickness, 0, NULL);
    $frame = XtVaCreateManagedWidget
	("_frame", xfwfFrameWidgetClass, $, XtNframeType, XfwfSunken,
	 XtNframeWidth, $shadowWidth, XtNborderWidth, 0,
	 XtNhighlightThickness, 0, NULL);
    $board = XtVaCreateManagedWidget
	("_board", xfwfBoardWidgetClass, $frame, XtNframeWidth, 0,
	 XtNborderWidth, 0, XtNhighlightThickness, 0, NULL);
    $vscroll = XtVaCreateWidget
	("_vscroll", xfwfVScrollbarWidgetClass, $, XtNframeWidth,
	 $shadowWidth, XtNframeType, XfwfSunken, XtNborderWidth, 0, NULL);
    $hscroll = XtVaCreateWidget
	("_hscroll", xfwfHScrollbarWidgetClass, $, XtNframeWidth,
	 $shadowWidth, XtNframeType, XfwfSunken, XtNborderWidth, 0, NULL);
    if (! $hideVScrollbar) XtManageChild($vscroll);
    if (! $hideHScrollbar) XtManageChild($hscroll);
    compute_sizes($);
    XfwfConnectScrollingWidgets($, $vscroll);
    XfwfConnectScrollingWidgets($, $hscroll);
    $initializing = False;
    if ($scrollResponse != scroll_response) {
	$scrollResponse = scroll_response;
	XtWarning("scrollResponse resource may only be queried, not set");
    }
}
.fi

Changes in the resources cause the scrolled window to recompute the
layout of its children.

The \fIscrollResponse\fP resource may not be changed.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($old$spacing != $spacing
	|| $old$scrollbarWidth != $scrollbarWidth
	|| $old$shadowWidth != $shadowWidth
	|| $old$hideHScrollbar != $hideHScrollbar
	|| $old$hideVScrollbar != $hideVScrollbar)
	compute_sizes($);
    if ($old$hideVScrollbar  ! $hideVScrollbar)
	XtUnmanageChild($vscroll);
    else if (! $old$hideVScrollbar  $hideVScrollbar)
	XtManageChild($vscroll);
    if ($old$hideHScrollbar  ! $hideHScrollbar)
	XtUnmanageChild($hscroll);
    else if (! $old$hideHScrollbar  $hideHScrollbar)
	XtManageChild($hscroll);
    if ($scrollResponse != $old$scrollResponse) {
	$scrollResponse = $old$scrollResponse;
	XtWarning("scrollResponse resource may only be queried, not set");
    }
    return False;
}
.fi

When the scrolled window is resized, the scrollbars and the frame
should be repositioned. Also, the thumbs in the scrollbars will have
to change size, but for that purpose there is an event handler that
will intercept changes to the configuration of the CW or the board.
The event handler is installed when the CW is inserted (in the
\fIinsert_child\fP method) and removed again when the child is destroyed
(in the \fICW_killed\fP callback routine).

.nf
resize($)
{
    compute_sizes($);
}
.fi

The \fIinsert_child\fP method performs some tricks to ensure that the
four proper children are added normally, that the fifth is passed on
to the cboard, that the sixth is passed on to the board, and that any
other children are refused.

When the CW is added as a child of the board, the scrollbars are
initialized to the current position and size of the CW relative to the
board.

.nf
insert_child(Widget  child)
{
    Widget board;
    Position boardx, boardy, gx, gy;
    Dimension boardwd, boardht, gwd, ght;
    float wd, ht, x, y;
    Boolean dummy;

    if ($initializing) {
	#insert_child(child);
    } else if ($CORNER == NULL) {
	$CORNER = child;
	$child$parent = $ulboard;
	XtAddCallback(child, XtNdestroyCallback, CORNER_killed, $);
	#insert_child(child);
#if 0
	XtAddEventHandler(child, StructureNotifyMask, False, configure, $);
	XtAddEventHandler($ulboard, StructureNotifyMask, False, configure, $);
	$compute_inside($ulboard, boardx, boardy, boardwd, boardht);
	XtVaGetValues(child, XtNwidth, gwd, XtNheight, ght, NULL);
	gx = gwd <= boardwd ? 0 : max($initialX, boardwd - gwd);
	gy = ght <= boardht ? 0 : max($initialY, boardht - ght);
	XtMoveWidget(child, gx, gy);
	configure($, $, NULL, dummy);
#endif
    } else if ($CCW == NULL) {
	$CCW = child;
	$child$parent = $cboard;
	XtAddCallback(child, XtNdestroyCallback, CCW_killed, $);
	#insert_child(child);
#if 0
	XtAddEventHandler(child, StructureNotifyMask, False, configure, $);
	XtAddEventHandler($cboard, StructureNotifyMask, False, configure, $);
	$compute_inside($cboard, boardx, boardy, boardwd, boardht);
	XtVaGetValues(child, XtNwidth, gwd, XtNheight, ght, NULL);
	gx = gwd <= boardwd ? 0 : max($initialX, boardwd - gwd);
	gy = ght <= boardht ? 0 : max($initialY, boardht - ght);
	XtMoveWidget(child, gx, gy);
	configure($, $, NULL, dummy);
#endif
    } else if ($RCW == NULL) {
	$RCW = child;
	$child$parent = $rboard;
	XtAddCallback(child, XtNdestroyCallback, RCW_killed, $);
	#insert_child(child);
#if 0
	XtAddEventHandler(child, StructureNotifyMask, False, configure, $);
	XtAddEventHandler($rboard, StructureNotifyMask, False, configure, $);
	$compute_inside($rboard, boardx, boardy, boardwd, boardht);
	XtVaGetValues(child, XtNwidth, gwd, XtNheight, ght, NULL);
	gx = gwd <= boardwd ? 0 : max($initialX, boardwd - gwd);
	gy = ght <= boardht ? 0 : max($initialY, boardht - ght);
	XtMoveWidget(child, gx, gy);
	configure($, $, NULL, dummy);
#endif
    } else if ($CW == NULL) {
	$CW = child;
	$child$parent = $board;
	XtAddCallback(child, XtNdestroyCallback, CW_killed, $);
	#insert_child(child);
	XtAddEventHandler(child, StructureNotifyMask, False, configure, $);
	XtAddEventHandler($board, StructureNotifyMask, False, configure, $);
	$compute_inside($board, boardx, boardy, boardwd, boardht);
	XtVaGetValues(child, XtNwidth, gwd, XtNheight, ght, NULL);
	gx = gwd <= boardwd ? 0 : max($initialX, boardwd - gwd);
	gy = ght <= boardht ? 0 : max($initialY, boardht - ght);
	if ($CCW) XtVaSetValues($CCW, XtNwidth, gwd, NULL);
	if ($RCW) XtVaSetValues($RCW, XtNheight, ght, NULL);
	XtMoveWidget(child, gx, gy);
	configure($, $, NULL, dummy);
    } else {
	char s[500];
	(void) sprintf(s, "Cannot add <%s>, %s <%s> already has 4 children\\n",
		       XtName(child), "ScrolledWindow", XtName($));
	XtWarning(s);
    }
}
.fi

When the scrolled window widget is destroyed, the event handler is
removed (if it was installed).

.nf
destroy($)
{
    if ($CCW != NULL) {
	XtRemoveEventHandler($CCW, StructureNotifyMask, False, configure, $);
	XtRemoveEventHandler($cboard, StructureNotifyMask, False, configure,$);
    }
    if ($RCW != NULL) {
	XtRemoveEventHandler($RCW, StructureNotifyMask, False, configure, $);
	XtRemoveEventHandler($rboard, StructureNotifyMask, False, configure,$);
    }
    if ($CW != NULL) {
	XtRemoveEventHandler($CW, StructureNotifyMask, False, configure, $);
	XtRemoveEventHandler($board, StructureNotifyMask, False, configure, $);
    }
    if ($CORNER != NULL) {
	XtRemoveEventHandler($CORNER, StructureNotifyMask, False, configure,$);
	XtRemoveEventHandler($ulboard, StructureNotifyMask, False,configure,$);
    }
}
.fi

When the ScrolledWindow2 widget is configured from outside, this is
done through a call to the \fIscroll_response\fP method.

.nf
scroll_response(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;
    XfwfScrollInfo *info = (XfwfScrollInfo *) call_data;
    XfwfScrollInfo new;
    Position boardx, boardy, gx, gy, minx, miny;
    Dimension boardwd, boardht, gwd, ght;
    float wd, ht, x, y;

    $compute_inside($board, boardx, boardy, boardwd, boardht);
    XtVaGetValues($CW, XtNx, gx, XtNy, gy, XtNwidth, gwd,
		  XtNheight, ght, NULL);
    minx = gwd <= boardwd ? 0 : ((int) boardwd) - gwd;
    miny = ght <= boardht ? 0 : ((int) boardht) - ght;

    if (info->flags  XFWF_VPOS) gy = info->vpos * miny;
    if (info->flags  XFWF_HPOS) gx = info->hpos * minx;

    XtMoveWidget($CCW, gx, 0);	/* Scrolls horizontally only */
    XtMoveWidget($RCW, 0, gy);	/* Scrolls vertically only */
    XtMoveWidget($CW, gx, gy);
#if 0
    XtMoveWidget($CORNER, 0, 0);
#endif

    if (info->reason != XfwfSNotify) {
	new.reason = XfwfSNotify;
	new.flags = info->flags  (XFWF_VPOS | XFWF_HPOS);
	new.hpos = info->hpos;
	new.vpos = info->vpos;
	XtCallCallbackList($, $scrollCallback, new);
    }
}
.fi

.hi

.hi
.SH "Utilities"

\fIcompute_sizes\fP is used by \fIinitialize\fP, \fIresize\fP and \fIset_values\fP
to configure the children.

.nf
compute_sizes($)
{
    Dimension selfw, selfh, framew, frameh, vsheight, hswidth, cwidth, rheight;
    Position selfx, selfy;
#if 0
    Dimension boardwd, boardht, gwd, ght;
    Position boardx, boardy, gx, gy;
    float wd, ht, x, y;
#endif

    $compute_inside($, selfx, selfy, selfw, selfh);

    vsheight = selfh - 3 * $spacing - $colHdrHeight;
    if (! $hideHScrollbar) vsheight -= $spacing + $scrollbarWidth;
    hswidth = selfw - 3 * $spacing - $rowHdrWidth;
    if (! $hideVScrollbar) hswidth -= $spacing + $scrollbarWidth;
    cwidth = selfw - 3 * $spacing - $rowHdrWidth - 2 * $shadowWidth;
    if (! $hideVScrollbar) cwidth -= $spacing + $scrollbarWidth;
    rheight = selfh - 3 * $spacing - $colHdrHeight - 2 * $shadowWidth;
    if (! $hideHScrollbar) rheight -= $spacing + $scrollbarWidth;

    XtConfigureWidget($ulboard,
		      selfx + $spacing,
		      selfy + $spacing,
		      $rowHdrWidth,
		      $colHdrHeight,
		      0);
    XtConfigureWidget($cboard,
		      selfx + 2*$spacing + $rowHdrWidth + $shadowWidth,
		      selfy + $spacing,
		      cwidth,
		      $colHdrHeight,
		      0);
    XtConfigureWidget($rboard,
		      selfx + $spacing,
		      selfy + 2*$spacing + $colHdrHeight + $shadowWidth,
		      $rowHdrWidth,
		      rheight,
		      0);
    XtConfigureWidget($vscroll,
		      selfx + selfw - $spacing - $scrollbarWidth,
		      selfy + $spacing + $colHdrHeight + $spacing,
		      $scrollbarWidth,
		      vsheight,
		      0);
    XtConfigureWidget($hscroll,
		      selfx + 2*$spacing + $rowHdrWidth,
		      selfy + selfh - $spacing - $scrollbarWidth,
		      hswidth,
		      $scrollbarWidth,
		      0);
    framew = selfw - 3 * $spacing - $rowHdrWidth;
    frameh = selfh - 3 * $spacing - $colHdrHeight;
    if (! $hideVScrollbar) framew -= $scrollbarWidth + $spacing;
    if (! $hideHScrollbar) frameh -= $scrollbarWidth + $spacing;
    XtConfigureWidget($frame,
		      selfx + 2*$spacing + $rowHdrWidth,
		      selfy + 2*$spacing + $colHdrHeight,
		      framew,
		      frameh,
		      0);

#if 0
    /* If its been resized, move the scrolled widgets to 0,0.
     * This is quick-n-dirty.  A more sophisticated implementation
     * would attempt to preserve the relative location.
     */
    if ($CCW != NULL) XtMoveWidget($CCW, 0, 0);
    if ($RCW != NULL) XtMoveWidget($RCW, 0, 0);
    if ($CW != NULL) XtMoveWidget($CW, 0, 0);
#else
#if 0
    if ($CW != NULL) {
	XtVaGetValues($CW, XtNx, gx, XtNy, gy, XtNwidth, gwd,
		      XtNheight, ght, NULL);
	$compute_inside($board, boardx, boardy, boardwd, boardht);
	if (gwd <= boardwd) {
	    if ($CCW != NULL) XtMoveWidget($CCW, 0, 0);
	    XtMoveWidget($CW, 0, gy);
	    gx = 0;
	}
	if (ght <= boardht) {
	    if ($RCW != NULL) XtMoveWidget($RCW, 0, 0);
	    XtMoveWidget($CW, gx, 0);
	}
    }
#endif /* 0 */
#endif /* 1 */
}
.fi

The \fIcopy_vScrollAmount\fP routine is a resource default function. It
copies the value of the \fIvScrollAmount\fP resource to the
\fIhScrollAmount\fP resource.

.nf
copy_vScrollAmount($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $vScrollAmount;
}
.fi

When the CCW or CW is destroyed, the private variables \fICCW\fP or \fICW\fP
must be set back to \fINULL\fP. The event handler that was installed to
intercept changes to the board and the CCW or CW must also be
removed.  The scrollbars are set to their `resting position'.

.nf
CW_killed(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtRemoveEventHandler(w, StructureNotifyMask, False, configure, $);
    XtRemoveEventHandler($board, StructureNotifyMask, False, configure, $);
    $CW = NULL;
    XfwfSetScrollbar($vscroll, 0.0, 1.0);
    XfwfSetScrollbar($hscroll, 0.0, 1.0);
}
.fi

.nf
CCW_killed(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtRemoveEventHandler(w, StructureNotifyMask, False, configure, $);
    XtRemoveEventHandler($cboard, StructureNotifyMask, False, configure, $);
    $CCW = NULL;
}
.fi

.nf
RCW_killed(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtRemoveEventHandler(w, StructureNotifyMask, False, configure, $);
    XtRemoveEventHandler($rboard, StructureNotifyMask, False, configure, $);
    $RCW = NULL;
}
.fi

.nf
CORNER_killed(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtRemoveEventHandler(w, StructureNotifyMask, False, configure, $);
    XtRemoveEventHandler($ulboard, StructureNotifyMask, False, configure, $);
    $CORNER = NULL;
}
.fi

The \fIconfigure\fP routine is called when the CW or the large board
receive ConfigureNotify events (and a few others, which are not
useful). It is also called by \fIinsert_child\fP, when the CW is first
created. The changed size of these widgets results in different sizes
for the sliders in the scrollbars.

.nf
configure(Widget  w, XtPointer  client_data, XEvent * event, Boolean * cont)
{
    Widget $ = (Widget) client_data;
    Dimension boardwd, boardht, gwd, ght;
    Position boardx, boardy, gx, gy;
    float wd, ht, x, y;

    if (event != NULL  event->type != ConfigureNotify) return;
    $compute_inside($board, boardx, boardy, boardwd, boardht);
    if ($CW == NULL)
	gwd = ght = 0;
    else
	XtVaGetValues($CW, XtNx, gx, XtNy, gy, XtNwidth, gwd,
		      XtNheight, ght, NULL);
    wd = gwd <= boardwd ? 1.0 : (float) boardwd/gwd;
    ht = ght <= boardht ? 1.0 : (float) boardht/ght;
    x = gwd <= boardwd ? 0.0 : gx/((float) boardwd - gwd);
    y = ght <= boardht ? 0.0 : gy/((float) boardht - ght);
    if (x > 1.0) x = 1.0;
    if (y > 1.0) y = 1.0;
    XfwfSetScrollbar($hscroll, x, wd);
    XfwfSetScrollbar($vscroll, y, ht);
}
.fi

.hi
