/*
** video_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to video
**	resources.
*/
UI_ElementDef video_list[] =
    {
	UI_PANE(panel_name, "ColorMode"),
	UI_TOGGLE(toggle_name, "mono",	XeColorMode_MONO, NULL),
	UI_RADIO(toggle_name, "gray",	XeColorMode_GRAY, NULL),
	UI_RADIO(toggle_name, "color", 	XeColorMode_COLOR, NULL),
	UI_LOAD(XtNcolorMode),
	UI_INPUT(input_name, "max colors:", UI_AcceptPanel),
	UI_LOAD(XtNmaxColors),
	UI_LABEL(label_name, "Dither"),
	UI_TOGGLE(input_name, "none",	XeDither_NONE, NULL),
	UI_RADIO(input_name, "fs4",	XeDither_FS4, NULL),
	UI_LOAD(XtNdither),
	UI_LABEL(label_name, "ColorQuantize"),
	UI_TOGGLE(toggle_name, "fast",	XeColorQuantize_FAST, NULL),
	UI_RADIO(toggle_name, "heckbert",XeColorQuantize_HECKBERT, NULL),
	UI_RADIO(toggle_name, "ppmquant",XeColorQuantize_PPMQUANT, NULL),
	UI_RADIO(toggle_name, "jpeg",	XeColorQuantize_JPEG, NULL),
	UI_LOAD(XtNcolorQuantize),
	UI_LABEL(label_name, "Window Geometry"),
	UI_INPUT(input_name, "Width :", UI_AcceptPanel),
	UI_LOAD(XtNhorizontal),
	UI_INPUT(input_name, "Height:", UI_AcceptPanel),
	UI_LOAD(XtNvertical),

	UI_PANE(panel_name, "Colormap use"),
	UI_TOGGLE(toggle_name, "shared",	XeColormapUse_SHARED, NULL),
	UI_RADIO(toggle_name, "sharedown",	XeColormapUse_SHAREDOWN, NULL),
	UI_RADIO(toggle_name, "optional",	XeColormapUse_OPTIONAL, NULL),
	UI_RADIO(toggle_name, "private",	XeColormapUse_PRIVATE, NULL),
	UI_LOAD(XtNcolormapUse),
	UI_LABEL(label_name, "Miscellanous"),
	UI_TOGGLE(toggle_name, "Use MIT-SHM",True, NULL),
	UI_LOAD(XtNuseShm),
	UI_TOGGLE(toggle_name, "Install colormap", True, NULL),
	UI_LOAD(XtNcolormapInstall),
	UI_TOGGLE(toggle_name, "Resize", True, NULL),
	UI_LOAD(XtNresize),
	UI_INPUT(input_name, "foreground: ", UI_AcceptPanel),
	UI_LOAD(XtNforeground),
	UI_INPUT(input_name, "background: ", UI_AcceptPanel),
	UI_LOAD(XtNbackground),

	UI_PANE(panel_name, "Scaling"),
	UI_TOGGLE(toggle_name, "none",		XeScaling_NONE, NULL),
	UI_RADIO(toggle_name, "width",		XeScaling_WIDTH, NULL),
	UI_RADIO(toggle_name, "height",		XeScaling_HEIGHT, NULL),
	UI_RADIO(toggle_name, "maxaspect",	XeScaling_MAXASPECT, NULL),
	UI_RADIO(toggle_name, "fitarea",	XeScaling_FITAREA, NULL),
	UI_LOAD(XtNscaling),
	UI_LABEL(label_name, "Rotation"),
	UI_TOGGLE(toggle_name, "  0",	0, NULL),
	UI_RADIO(toggle_name, " 90",	90, NULL),
	UI_RADIO(toggle_name, "180",	180, NULL),
	UI_RADIO(toggle_name, "270",	270, NULL),
	UI_LOAD(XtNrotation),
	UI_TOGGLE(toggle_name, "mirror",	True, NULL),
	UI_LOAD(XtNmirrorImage),
	UI_LABEL(label_name, "Play"),
	UI_TOGGLE(toggle_name, "freeze",	XePlay_FREEZE, NULL),
	UI_RADIO(toggle_name, "forward",	XePlay_FORWARD, NULL),
	UI_LOAD(XtNplay),
	UI_INPUT(input_name, "frame delay (ms): ", UI_AcceptPanel),
	UI_LOAD(XtNminFrameDelay),
	UI_LABEL(label_name, "Section"),
	UI_INPUT(input_name, "first frame: ", UI_AcceptPanel),
	UI_LOAD(XtNfirstFrame),
	UI_INPUT(input_name, "last frame:  ", UI_AcceptPanel),
	UI_LOAD(XtNlastFrame),
	UI_INPUT(input_name, "current frame:  ", UI_AcceptPanel),
	UI_LOAD(XtNcurrentFrame),
	UI_END(),
    };

extern UI_PanelDef video_resources;

static UI_ActionDef video_actions[] =
    {
	{"set", UI_AcceptPanel, (XtPointer)&video_resources},
	{"close"},
	{"print", PrintToDisplay, (XtPointer)&video_resources.shell},
	{NULL},
    };

UI_PanelDef video_resources = 
    {
	"Video Resources",
	video_list,
	video_actions,
    };

