/*
** image_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to image
**	resources.
*/
UI_ElementDef image_list[] =
    {
	UI_PANE(panel_name, "ColorMode"),
	UI_TOGGLE(toggle_name,	"mono",	XeColorMode_MONO, NULL),
	UI_RADIO(toggle_name,	"gray",	XeColorMode_GRAY, NULL),
	UI_RADIO(toggle_name,	"color",XeColorMode_COLOR, NULL),
	UI_LOAD(XtNcolorMode),
	UI_INPUT(input_name, "max colors:", UI_AcceptPanel),
	UI_LOAD(XtNmaxColors),
	UI_LABEL(label_name, "Dither"),
	UI_TOGGLE(toggle_name, "none",	XeDither_NONE, NULL),
	UI_RADIO(toggle_name, "fs4",	XeDither_FS4, NULL),
	UI_LOAD(XtNdither),
	UI_LABEL(label_name, "ColorQuantize"),
	UI_TOGGLE(toggle_name,	"fast",	XeColorQuantize_FAST, NULL),
	UI_RADIO(toggle_name,	"heckbert", XeColorQuantize_HECKBERT, NULL),
	UI_RADIO(toggle_name,	"ppmquant", XeColorQuantize_PPMQUANT, NULL),
	UI_RADIO(toggle_name,	"jpeg",	XeColorQuantize_JPEG, NULL),
	UI_LOAD(XtNcolorQuantize),
	UI_LABEL(label_name, "Display Geometry"),
	UI_INPUT(input_name, "Width :", UI_AcceptPanel),
	UI_LOAD(XtNhorizontal),
	UI_INPUT(input_name, "Height:", UI_AcceptPanel),
	UI_LOAD(XtNvertical),

	UI_PANE(panel_name, "Colormap use"),
	UI_TOGGLE(toggle_name, "shared",	XeColormapUse_SHARED, NULL),
	UI_RADIO(toggle_name, "sharedown",	XeColormapUse_SHAREDOWN, NULL),
	UI_RADIO(toggle_name, "optional",	XeColormapUse_OPTIONAL, NULL),
	UI_RADIO(toggle_name, "private",	XeColormapUse_PRIVATE, NULL),
	UI_LOAD(XtNcolormapUse),
	UI_LABEL(label_name, "Miscellanous"),
	UI_TOGGLE(toggle_name, "Use MIT-SHM",True, NULL),
	UI_LOAD(XtNuseShm),
	UI_TOGGLE(toggle_name, "Install colormap", True, NULL),
	UI_LOAD(XtNcolormapInstall),
	UI_TOGGLE(toggle_name, "Resize", True, NULL),
	UI_LOAD(XtNresize),
	UI_INPUT(input_name, "foreground: ", UI_AcceptPanel),
	UI_LOAD(XtNforeground),
	UI_INPUT(input_name, "background: ", UI_AcceptPanel),
	UI_LOAD(XtNbackground),

	UI_PANE(panel_name, "Scaling"),
	UI_TOGGLE(toggle_name, "none",	XeScaling_NONE, NULL),
	UI_RADIO(toggle_name, "width",	XeScaling_WIDTH, NULL),
	UI_RADIO(toggle_name, "height",	XeScaling_HEIGHT, NULL),
	UI_RADIO(toggle_name, "maxaspect",	XeScaling_MAXASPECT, NULL),
	UI_RADIO(toggle_name, "fitarea",	XeScaling_FITAREA, NULL),
	UI_LOAD(XtNscaling),
	UI_LABEL(label_name, "Rotation"),
	UI_TOGGLE(toggle_name, "  0",	0, NULL),
	UI_RADIO(toggle_name,  " 90",	90, NULL),
	UI_RADIO(toggle_name,  "180",	180, NULL),
	UI_RADIO(toggle_name,  "270",	270, NULL),
	UI_LOAD(XtNrotation),
	UI_TOGGLE(toggle_name, "mirror",	True, NULL),
	UI_LOAD(XtNmirrorImage),
	UI_LABEL(label_name, "Image size"),
	UI_INPUT(input_name, "width: ", UI_AcceptPanel),
	UI_LOAD(XtNrasterWidth),
	UI_INPUT(input_name, "height: ", UI_AcceptPanel),
	UI_LOAD(XtNrasterHeight),
	UI_LABEL(label_name, "Clipping"),
	UI_INPUT(input_name, "x: ", UI_AcceptPanel),
	UI_LOAD(XtNclipX),
	UI_INPUT(input_name, "y: ", UI_AcceptPanel),
	UI_LOAD(XtNclipY),
	UI_INPUT(input_name, "width: ", UI_AcceptPanel),
	UI_LOAD(XtNclipWidth),
	UI_INPUT(input_name, "height: ", UI_AcceptPanel),
	UI_LOAD(XtNclipHeight),
	UI_END(),
    };

extern UI_PanelDef image_resources;

static UI_ActionDef image_actions[] =
    {
	{"set", UI_AcceptPanel, (XtPointer)&image_resources},
	{"close"},
	{"print", PrintToDisplay, (XtPointer)&image_resources.shell},
	{NULL},
    };

UI_PanelDef image_resources = 
    {
	"Image Resources",
	image_list,
	image_actions,
    };

