/*
** Very Simple EuroBridge Audio Widget Demonstration Program
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Frame.h>


/*
** This callback will set the value of the "play" resource of the
** audio widget according to the state of the toggle:
**
**	True	-> XePlay_FORWARD	continue/start playing
**	False	-> XePlay_FREEZE	stop playing
*/
static void Play(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	Widget audio = (Widget)client_data;
	Boolean value = False;

	XtSetArg(args[0], XtNstate, &value);
	XtGetValues(w, args, 1);
	if (value)
		XtSetArg(args[0], XtNplay, XePlay_FORWARD);
	else
		XtSetArg(args[0], XtNplay, XePlay_FREEZE);
	XtSetValues(audio, args, 1);
    }

/*
** This callback will set the recource "contentLoaded" to False,
** which causes the audio widget to restart reading of the input
** stream.
*/
static void Again(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	Widget audio = (Widget)client_data;

	XtSetArg(args[0], XtNcontentLoaded, False);
	XtSetValues(audio, args, 1);
    }

#include "fallback.c"

int main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget root_widget, work, box, play, again, audio;
	Arg args[10];
	int n;

	root_widget = XtAppInitialize(&demo_application, "XewAudio",
				      NULL,0, &argc, argv,
				      fallback_resources,
				      NULL, 0);
	n = 0;
	work = XtCreateManagedWidget
		("mainWindow", xeFrameWidgetClass, root_widget,args, n);
	n = 0;
	box = XtCreateManagedWidget
		("menuPanel", xeFrameWidgetClass, work, args,n);
	n = 0;
        XtSetArg(args[n], XtNlabel, "PLAY"); ++n;
	play = XtCreateManagedWidget
		("play", toggleWidgetClass, box, args, n);
	n = 0;
        XtSetArg(args[n], XtNlabel, "AGAIN"); ++n;
	again = XtCreateManagedWidget
		("again", commandWidgetClass, box, args, n);

	n = 0;
	if (argc > 1)
	    {
		if (argv[1] && argv[1][0] == '|')
			XtSetArg(args[n], XtNcontentFilter, argv[1]+1);
		else
			XtSetArg(args[n], XtNcontentFile, argv[1]);
		++n;
	    }
	else
	    {
		XtSetArg(args[n], XtNcontentStream, stdin); ++n;
		printf("Using stardard input.\n");
	    }
	XtSetArg(args[n], XtNcontentFormat, XeContentFormat_AUDIO); ++n;
	XtSetArg(args[n], XtNplay, XePlay_FREEZE); ++n;
	audio = XtCreateManagedWidget
		("demoAudio", xeAudioWidgetClass, box, args, n);
	XtAddCallback(play, XtNcallback, Play, (XtPointer)audio);
	XtAddCallback(again, XtNcallback, Again, (XtPointer)audio);
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }

