/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#endif
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/RasterP.h>
#include "RasterImport.h"
#include "RasterLayout.h"
#include "ImageTools.h"

#define offset(field) XtOffsetOf(XeRasterRec, raster.field)

static XtResource resources[] =
    {
	{XtNclipX, XtCClipX, XtRInt, sizeof(int),
		 offset(clip_x), XtRImmediate, 0},
	{XtNclipY, XtCClipY, XtRInt, sizeof(int),
		 offset(clip_y), XtRImmediate, 0},
	{XtNclipWidth, XtCClipWidth, XtRInt, sizeof(int),
		 offset(clip_width), XtRImmediate, 0},
	{XtNclipHeight, XtCClipHeight, XtRInt, sizeof(int),
		 offset(clip_height), XtRImmediate, 0},
	{XtNrasterWidth, XtCRasterWidth, XtRInt, sizeof(int),
		 offset(raster_width), XtRImmediate, 0},
	{XtNrasterHeight, XtCRasterHeight, XtRInt, sizeof(int),
		 offset(raster_height), XtRImmediate, 0},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize();
static void Initialize(), Redisplay(), Resize(), Destroy();
static Boolean SetValues();
static XtGeometryResult QueryGeometry();

static void PrintInitialize();
static void PrintCancel(), PrintDestroy();
static XtPointer Print();

#define REDISPLAY(w,e,r) \
	(*(w)->core.widget_class->core_class.expose) \
	((Widget)(w), (XEvent *)(e), (Region)(r))

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeRasterbaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

XeRasterClassRec xeRasterClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &xeBasicClassRec,
    /* class_name		*/	"XeRaster",
    /* widget_size		*/	sizeof(XeRasterRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple|XtExposeGraphicsExpose,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	QueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeRasterbaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields	*/
    /* geometry_manager		*/	XtInheritGeometryManager,
    /* change_managed		*/	XtInheritChangeManaged,
    /* insert_child		*/	XtInheritInsertChild,
    /* delete_child		*/	XtInheritDeleteChild,
    /* extension		*/	NULL
  },
  { /* constraint class fields	*/
    /* subresources		*/	NULL,
    /* subresource_count	*/	0,
    /* constraint_size		*/	0,
    /* initialize		*/	NULL,
    /* destroy			*/	NULL,
    /* set_values		*/	NULL,
    /* extension		*/	NULL
  },
#ifdef USING_MOTIF_122
  { /* manager class record	*/
    /* translations		*/	XtInheritTranslations,
    /* syn_resources		*/	NULL,
    /* num_syn_resources	*/	0,
    /* syn_constraint_resources	*/	NULL,
    /* num_syn_constraint_resources */	0,
    /* parent_process		*/	XmInheritParentProcess,
    /* extension		*/	NULL  
  },
#endif
  { /* basic fields */
    /* print_initialize		*/	PrintInitialize,
    /* print			*/	Print,
    /* print_cancel		*/	PrintCancel,
    /* print_destroy		*/	PrintDestroy,
    /* print_constraint_initialize */	NULL,
    /* print_constraint_destroy */	NULL
  },
  { /* XeRaster fields */
    /* not used			*/	0
  }
};

WidgetClass xeRasterWidgetClass = (WidgetClass)&xeRasterClassRec;

#define	CvtDone(type, value)				\
    do {						\
	if (toVal->addr != NULL)			\
	    {						\
		if (toVal->size < sizeof(type))		\
		    {					\
			toVal->size = sizeof(type);	\
			return False;			\
		    }					\
		*(type*)(toVal->addr) = (value);	\
	    }						\
	else						\
	    {						\
		static type static_val;			\
		static_val = (value);			\
		toVal->addr = (XPointer)&static_val;	\
	    }						\
	toVal->size = sizeof(type);			\
	return True;					\
    } while (0)

static void ClassInitialize()
    {
	XewInitializeWidgetSet();
#ifdef USING_MOTIF_122
        _XeRasterbaseClassExtRec.record_type = XmQmotif;
#endif
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static int LimitDimension(d, limit)
int d;
XeFrameDimension *limit;
    {
	if (limit->value > 0)
		return limit->value;
	if (limit->min > 0 && d < limit->min)
		d = limit->min;
	if (limit->max > 0 && d > limit->max)
		d = limit->max;
	return d;
    }

/*
** GetPreferredSize
**	Get the preferred window size limited by (dst_*) and scaling
*/
static void GetPreferredSize(w, dst_width, dst_height, width, height)
XeRasterWidget w;
int dst_width, dst_height;
Dimension *width, *height;
    {
	int src_width, src_height;

	/*
	** The source image rectange size
	*/
	src_width = w->raster.clip_width > 0 ?
		w->raster.clip_width : w->raster.raster_width;
	src_height = w->raster.clip_height > 0 ?
		w->raster.clip_height :  w->raster.raster_height;
	/*
	** prefer dst == src, if nothing else requested
	*/
	if (dst_width <= 0)
		dst_width = src_width;
	if (dst_height <= 0)
		dst_height = src_height;
	dst_width = LimitDimension(dst_width, &w->basic.dimension[0]);
	dst_height = LimitDimension(dst_height, &w->basic.dimension[1]);
	/*
	** Apply the current scale setting and window size to this and
	** get destination rectangle size
	*/
	_XeBasicScaling((XeBasicWidget)w, src_width, src_height,
			dst_width, dst_height, width, height);

	*width = LimitDimension(*width, &w->basic.dimension[0]);
	*height = LimitDimension(*height, &w->basic.dimension[1]);
    }


static XtGeometryResult QueryGeometry(w, request, preferred)
Widget w;
XtWidgetGeometry *request;
XtWidgetGeometry *preferred;
    {
	XeRasterWidget rw = (XeRasterWidget)w;

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = (request->request_mode & CWWidth) ?
		request->width : 0;
	preferred->height = (request->request_mode & CWHeight) ?
		request->height : 0;
	GetPreferredSize
		(rw,
		 preferred->width, preferred->height,
		 &preferred->width, &preferred->height);
	if (((request->request_mode&(CWWidth|CWHeight))==(CWWidth|CWHeight)) &&
	    request->width == preferred->width &&
	    request->height == preferred->height)
		return XtGeometryYes;
	else
		return XtGeometryAlmost;
    }

/*
** SetupContent
**	Prepare for viewing raster content
*/
static void SetupContent(w, allow_resize)
XeRasterWidget w;
int allow_resize;	/* Non-ZERO, if change of core geometry allowed */
    {
	XtWidgetGeometry req, rep;

	if (w->basic.content_loaded == False)
	    {
		XeRasterImport(w);
		w->basic.content_loaded = True;
		w->raster.done = False;
	    }
	if (w->raster.raw_image)
	    {
		GetPreferredSize
			(w,
			 w->core.width, w->core.height,
			 &req.width, &req.height);
		if (w->basic.resize && allow_resize)
		    {
			XtGeometryResult result;
			int almost = 0;

			req.request_mode = 0;
			if (req.width != w->core.width)
				req.request_mode |= CWWidth;
			if (req.height != w->core.height)
				req.request_mode |= CWHeight;
			while (req.request_mode)
			    {
				result = XtMakeGeometryRequest
					((Widget)w, &req, &rep);
				if (result != XtGeometryAlmost || almost)
					break;
				almost = 1;
				req = rep;
			    }
		    }
		if (w->core.width == 0)
			w->core.width = req.width;
		if (w->core.height == 0)
			w->core.height = req.height;
		if (w->raster.dsp_image == NULL ||
		    w->raster.dsp_image->image == NULL ||
		    w->raster.dsp_image->image->width != req.width ||
		    w->raster.dsp_image->image->height != req.height)
			w->raster.done = False;
	    }
	XSetBackground(XtDisplay(w),w->raster.mygc,w->core.background_pixel);
	XSetForeground(XtDisplay(w),w->raster.mygc,w->basic.foreground_pixel);
    }


static void Initialize(request, new)
Widget request, new;
    {
	XeRasterWidget w = (XeRasterWidget)new;

	w->raster.mygc  =
		XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 0, 0);
	XSetLineAttributes(XtDisplay(w), w->raster.mygc,
			   1, LineSolid, CapButt, JoinMiter);
	w->raster.dsp_image = NULL;
	w->raster.raw_image = NULL;
	w->raster.done = False;
	SetupContent(w, False); /* No Geometry requests from initialize! */
    }

static void Redisplay(w, e, r)
Widget w;
XExposeEvent *e;
Region r;
    {
	XeRasterWidget rw = (XeRasterWidget)w;
	Display *dsp = XtDisplay(w);
	Drawable dst = XtWindow(w);
	XRectangle clip;

	if (!XtIsRealized(w))
		return;
	if (!rw->raster.done)
		XeRasterLayout(rw);

	if (r)
		XClipBox(r, &clip);
	else if (e)
	    {
		clip.x = e->x;
		clip.y = e->y;
		clip.width = e->width;
		clip.height = e->height;
	    }
	else
	    {
		/*
		** No expose event or region, assume "virtual expose"
		** event covering the visible portion of the widget
		** when translation is included.
		*/
		int width, height;
		
		clip.x = rw->basic.x_translation;
		clip.y = rw->basic.y_translation;
		width = w->core.width;
		height = w->core.height;
		if (clip.x < 0)
		    {
			width += clip.x;
			clip.x = 0;
		    }
		if (clip.y < 0)
		    {
			height += clip.y;
			clip.y = 0;
		    }
		if (width <= 0 || height <= 0)
			return;	/* Nothing to expose!! */
		clip.width = width;
		clip.height = height;
	    }
	if (rw->raster.dsp_image != NULL)
	    {
		int srcx, srcy, dstx, dsty;
		unsigned int width, height;

		srcx = clip.x - rw->basic.x_translation;
		srcy = clip.y - rw->basic.y_translation;
		width = clip.width;
		height = clip.height;
		dstx = clip.x;
		dsty = clip.y;

		if (srcx < 0)
		    {
			width += srcx;
			srcx = 0;
		    }
		if (srcy < 0)
		    {
			height += srcy;
			srcy = 0;
		    }
		if (width > 0 && height > 0)
			_XePutImage(dsp, dst, rw->raster.mygc,
				    rw->raster.dsp_image,
				    srcx, srcy, dstx, dsty,
				    width, height);
	    }
	if (rw->basic.expose_callbacks &&
	    rw->core.widget_class == xeRasterWidgetClass)
	    {
		XeExposeCallbackData data;
		data.reason = XeCR_EXPOSE;
		data.event = e;
		data.region = r;
		XtCallCallbackList
			(w, rw->basic.expose_callbacks, (XtPointer)&data);
	    }
    }

static void PrintInitialize(w, c, pp)
Widget w, c;
XePrintProcess pp;
    {
	XeRasterWidget clone = (XeRasterWidget)c;

	clone->raster.mygc  =
		XCreateGC(XtDisplay(clone),
			  RootWindowOfScreen(XtScreen(clone)), 0, 0);
	clone->raster.dsp_image = NULL;
	if (clone->raster.raw_image)
		clone->raster.raw_image->references += 1;
	clone->raster.done = False;
    }

static XtPointer Print(w, c, x, y, pp)
Widget w, c;
int x, y;
XePrintProcess pp;
    {
	XeRasterWidget clone = (XeRasterWidget)c;

	clone->basic.x_translation = x;
	clone->basic.y_translation = y;
	REDISPLAY(c, (XEvent *)NULL, (Region)0);
	return NULL;
    }

static void PrintCancel(w, c, pp, client_data)
Widget w, c;
XePrintProcess pp;
XtPointer client_data;
    {
    }

static void PrintDestroy(w, c, pp)
Widget w, c;
XePrintProcess pp;
    {
	XeRasterWidget clone = (XeRasterWidget)c;

	XFreeGC(XtDisplay(clone), clone->raster.mygc);
	_XeDestroyRawImage(clone->raster.raw_image);
	_XeDestroyImage(clone->raster.dsp_image);
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	XeRasterWidget cw = (XeRasterWidget)current;
	XeRasterWidget nw = (XeRasterWidget)new;

	if (cw->basic.imaging.max_colors != nw->basic.imaging.max_colors ||
	    cw->basic.imaging.color_mode != nw->basic.imaging.color_mode ||
	    cw->basic.imaging.colormap_use != nw->basic.imaging.colormap_use ||
	    cw->basic.imaging.use_shm != nw->basic.imaging.use_shm ||
	    cw->basic.imaging.dither != nw->basic.imaging.dither ||
	    cw->basic.imaging.color_quantize != nw->basic.imaging.color_quantize ||
	    cw->basic.rotation != nw->basic.rotation ||
	    cw->basic.scaling != nw->basic.scaling ||
	    cw->basic.mirror_image != nw->basic.mirror_image ||
	    cw->raster.clip_x != nw->raster.clip_x ||
	    cw->raster.clip_y != nw->raster.clip_y ||
	    cw->raster.clip_width != nw->raster.clip_width ||
	    cw->raster.clip_height != nw->raster.clip_height)
		nw->raster.done = False;
	/*
	** If user sets raster_width or raster_height to ZERO, then
	** copy the corresponding value from the real raw image, if
	** any available. (These resources are mainly informative and
	** have effect only to the preferred geometry, if asked)
	*/
	if (nw->raster.raw_image)
	    {
		if (nw->raster.raster_width == 0)
			nw->raster.raster_width = nw->raster.raw_image->width;
		if (nw->raster.raster_height == 0)
			nw->raster.raster_height= nw->raster.raw_image->height;
	    }
	SetupContent(nw, True);
	return (!nw->raster.done ||
		cw->core.background_pixel != nw->core.background_pixel ||
		cw->basic.foreground_pixel != nw->basic.foreground_pixel);
    }

static void Resize(w)
Widget w;
    {
	((XeRasterWidget)w)->raster.done = False;
	SetupContent((XeRasterWidget)w, False);
    }

static void Destroy(w)
Widget w;
    {
	register XeRasterWidget rw = (XeRasterWidget)w;
	
	XFreeGC(XtDisplay(w), rw->raster.mygc);
	_XeDestroyRawImage(rw->raster.raw_image);
	_XeDestroyImage(rw->raster.dsp_image);
    }

/*
** ******************************************************
** IMPLEMENTATION OF THE PROGRAMMATIC INTERFACE FUNCTIONS
** ******************************************************
*/
/*
** IsRasterWidget
**	Returns True, if the widget is of class xeRaster and
**	False otherwise (also, a warning message is generated).
*/
static int IsRasterWidget(w)
Widget w;
    {
	String params[2];

	if (XtIsSubclass(w, xeRasterWidgetClass))
		return True;
	params[0] = w->core.name;
	params[1] = w->core.widget_class->core_class.class_name;
	XeWidgetWarningMsg
		(w, "bugRasterNotRaster",
		 "Widget %s is class %s, and not xeRasterWidget",
		 (String *)params, (Cardinal)2);
	return False;
    }

/*
** XeRasterGetRawImage
**	returns a pointer to the current Raw Image structure.
**
**	Returns NULL, if raster has no raw image.
*/
XeRawImage *XeRasterGetRawImage(w)
Widget w;
    {
	XeRasterWidget r = (XeRasterWidget)w;
	XeRawImage *raw = NULL;

	if (IsRasterWidget(w))
	    {
		raw = r->raster.raw_image;
		if (raw)
			raw->references += 1;
	    }
	return raw;
    }

/*
** XeRasterSetRawImage
**	replaces the current Raw Image in the widget with a new one
*/
void XeRasterSetRawImage(w, raw)
Widget w;
XeRawImage *raw;
    {
	XeRasterWidget r = (XeRasterWidget)w;

	if (IsRasterWidget(w))
	    {
		if (r->raster.raw_image != raw)
		    {
			if (r->raster.raw_image)
				XeDestroyRawImage(r->raster.raw_image);
			r->raster.raw_image = raw;
			if (raw)
				raw->references += 1;
		    }
		if (raw)
		    {
			r->raster.done = FALSE;
			r->raster.raster_width = raw->width;
			r->raster.raster_height = raw->height;
		    }
	    }
    }

/*
** XeCreateRawImage
**	Create empty raw image structure which has room for the
**	specified number of channels.
*/
XeRawImage *XeCreateRawImage(channels)
int channels;
    {
	return _XeCreateRawImage(channels);
    }

/*
** XeDestroyRawImage
**	Release all resources allocated to a raw image, including the
**	descriptor structure itself (do not call this for staticly
**	allocated descriptor!)
*/
void XeDestroyRawImage(raw)
XeRawImage *raw;
    {
	_XeDestroyRawImage(raw);
    }

#ifdef USING_MOTIF_122
/*
** WidgetNavigable
**	routine to handle traversal to children of this widget, if
**	there are any, or else the widget itself, if no children. 
*/
static XmNavigability WidgetNavigable(wid)
Widget wid;
    {   
	if(wid->core.sensitive && wid->core.ancestor_sensitive &&
	   ((XmManagerWidget) wid)->manager.traversal_on)
	    {
		XmNavigationType nav_type =
			((XmManagerWidget) wid)->manager.navigation_type;

		if(nav_type == XmSTICKY_TAB_GROUP ||
		   nav_type == XmEXCLUSIVE_TAB_GROUP ||
		   (nav_type == XmTAB_GROUP && !_XmShellIsExclusive( wid)))
			return XmTAB_NAVIGABLE;
		return XmCONTROL_NAVIGABLE;
	    }
	return XmNOT_NAVIGABLE;
    }
#endif

