#ifndef _XewColor_h
#define _XewColor_h
/*
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xew/Basic.h>

typedef unsigned char XeSample;

#define XeSample_BITS 8
#define XeSample_RANGE (1<<(XeSample_BITS))
#define XeSample_MAX ((XeSample_RANGE)-1)


#if XeSample_BITS == 8
#	define XToSample(v) ((v) / 257)
#	define SampleToX(v) ((v) * 257)
#else
#	define XToSample(v) (((v) * XeSample_MAX) / 65535)
#	define SampleToX(v) (((v) * 65535) / XeSample_MAX)
#endif


_XFUNCPROTOBEGIN

/*
** XeAllocColors
**	allocate best possible colors. This function never fails,
**	all requested colors are always "allocated" (though, at worst
**	the returned colors may not have much to with the requested
**	colors).
*/
Colormap XeAllocColors
	(
#if NeedFunctionPrototypes
	 Display *,	/* Display identification */
	 Window,	/* Determines the screen and visual to use */
	 Colormap,	/* Colormap to use by default */
	 XeColormapUse,	/* Color allocation mode */
	 int,		/* Max number of allowed exact allocations */
	 int,		/* Number of colors to locate */
	 XeSample *,	/* Red values (in/out parameter) */
	 XeSample *,	/* Green values (in/out parameter) */
	 XeSample *,	/* Blue values (in/out parameter) */
	 Pixel *	/* Pixel values (out parameter) */
#endif
	 );

void XeFreeColors
	(
#if NeedFunctionPrototypes
	 Display *,	/* Display identification */
	 Colormap,	/* The colormap */
	 int,		/* Number of pixels to release */
	 Pixel *	/* Pixels to be released */
#endif
	 );

void XeQueryColors
	(
#if NeedFunctionPrototypes
	 Display *,	/* Display identification */
	 Colormap,	/* The colormap */
	 int,		/* Number of pixels to query */
	 Pixel *,	/* Pixels to query */
	 XeSample *,	/* Returned red values */
	 XeSample *,	/* Returned green values */
	 XeSample *	/* Returned blue values */
#endif
_XFUNCPROTOEND
	 );
#endif
