#ifndef _XewBasicP_h
#define _XewBasicP_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Constraint.h>
#include <X11/Xew/Basic.h>
#include "PrintP.h"

#ifdef USING_MOTIF_122
#	include <Xm/ManagerP.h>
#	include <Xm/BaseClassP.h>
#endif

#ifdef USING_XPRINTER
#	include <Xp.h>
#	include <XpMacros.h>
#endif

/*
** Handle some differencies between X11 releases
*/
#if ((XtVersion) < 11005)
typedef char *XPointer;
#endif

#define FRAME_HORIZONTAL 0
#define FRAME_VERTICAL 1

#define XeInheritPrint ((XePrintProc)_XtInherit)
#define XeInheritPrintCancel ((XePrintCancelProc)_XtInherit)

typedef struct _XeBasicClass
    {
	XePrintInitializeProc print_initialize;
	XePrintProc print;
	XePrintCancelProc print_cancel;
	XePrintDestroyProc print_destroy;
	XePrintConstraintInitializeProc print_constraint_initialize;
	XePrintConstraintDestroyProc print_constraint_destroy;
    } XeBasicClassPart;

typedef struct _XeBasicClassRec
    {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
        XeBasicClassPart basic_class;
    } XeBasicClassRec;

typedef struct
    {
	/* resources */
	Visual *visual;		/* The Visual associated with the window */
	Cursor cursor;		/* Cursor symbol used within widget */
	Pixel foreground_pixel;	/* Default Foreground color */
	int x_translation;	/* Horizontal positioning of the content */
	int y_translation;	/* Vertical positioning of the content */
	int rotation;		/* Rotation angle (degrees) [0-360] */
	XeScaling scaling;
	XeFrameDimension dimension[2];	/* geometry specification */
	Boolean resize;
	Boolean content_loaded;
	Boolean mirror_image;
	Boolean parent_background;
	/*
	** colormapInstall resource is only needed to support Window
	** managers that don't work with XtSetWMColormapWindows. If
	** True, the widget will explicitly install colormaps
	** on enter/leave events.
	*/
	Boolean colormap_install;
	XeImaging imaging;

	XeContentFormat content_format;
	String	content_file;
	String	content_filter;
	FILE *	content_stream;
	char *	content_string;
	long	content_length;
	long	content_offset;
#ifndef USING_MOTIF_122
	XtPointer user_data;	/* For application use */
#endif
	XtCallbackList activate_callbacks;
	XtCallbackList notify_callbacks;
	XtCallbackList expose_callbacks;
	XtCallbackList export_callbacks;
	XtCallbackList import_callbacks;

	/* private state */

	Colormap cmap;		/* Private Colormap */
    } XeBasicPart;

typedef struct _XeBasicRec
    {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
#ifdef USING_MOTIF_122
        XmManagerPart	manager;
#endif
	XeBasicPart	basic;
    } XeBasicRec;

/* Class pointer */
extern XeBasicClassRec xeBasicClassRec;

/*
** CvtEnumInfo
**	for Generic String to Enumeration value converter
*/
typedef struct CvtEnumInfo
    {
	char *name;
	int value;
    } CvtEnumInfo;


/*
** XeDataFlow
**	Data flow descriptor. A widget may associate with asynchronous
**	input or output streams. Each stream, once activated operates
**	via three functions.
*/
struct XeDataFlow; /* ..see below for actual definition */
/*
** XeDataFlowFeed
**	int feed(flow, data, length)
**		This function is called when data is available from the
**		source. Feed returns the number (n) of actual bytes
**		processed:
**
**	n > length	(illegal return value)
**
**	0 < n = length, continue waiting for more input and call again
**			'feed', when more data is available.
**			what to do with the unprocessed bytes).
**
**	0 <= n < length, hold off the input, no calls to 'feed' allowed,
**			until enabled by a call to 'more' (it's up to
**			calling function to decide what to do with the
**			unprocessed bytes),
**
**	< 0,		terminate flow and release resources.
**
** XeDataFlowMore
**	int more(flow)
**		Must be called to enable further calls to feed.
**		Returns with < 0, if the flow has been terminated,
**		and otherwise returns > 0.
**
** XeDataFlowDone
**	void done(flow)
**		is called when the input source or output sink of the
**		flow is to be closed.
*/
#if NeedFunctionPrototypes
typedef int (*XeDataFlowFeed)(struct XeDataFlow *, char *, int);
typedef int (*XeDataFlowMore)(struct XeDataFlow *);
typedef void (*XeDataFlowDone)(struct XeDataFlow *);
typedef int (*XeDataFlowRead)(struct XeDataFlow *, char *, int, int);
#else
typedef int (*XeDataFlowFeed)();
typedef int (*XeDataFlowMore)();
typedef void (*XeDataFlowDone)();
typedef int (*XeDataFlowRead)();
#endif

typedef struct XeDataFlow
    {
	XeBasicWidget w;	/* the Xew widget owning the stream */
	XeDataFlowFeed feed;	/* function to be called with data */
	XeDataFlowMore more;	/* function to remove temporary hold */
	XeDataFlowDone done;	/* function to close external source/sink */
	XeDataFlowRead read;	/* function to actively reading input flow */
	XeDataFlowDone save;	/* (used by Basic to save original 'done') */
	XtInputId id;		/* Associated Id of XtAppAddInput  */
	int fd;			/* Associated stream, if any ( >= 0) */
	FILE *fl;		/* (used only with contentFilter) */
	int length;		/* Number of bytes buffered */
	char *buffer;		/* Buffered bytes */
    } XeDataFlow;

/*
** XeDataContent
**	is an alternate internal method of accessing the widget content.
**	The basic structure used by _XeOpenContent and _XeCloseContent.
**
** NOTE:
**	The user should only check against STRING and if true, then use
**	the source.string variant, and otherwise always use source.stream.
**	STRING is defined to be ZERO, other values NON-ZERO!
*/
typedef enum
    {
	XeDataContentType_STRING = 0,	/* Dont't change this!!! */
	XeDataContentType_STREAM,
	XeDataContentType_FILE,
	XeDataContentType_FILTER
    } XeDataContentType;

typedef struct XeDataContent
    {
	XeDataContentType type;
	long length;		/* contentLength resource value */
	union
	    {
		char *string;	/* _STRING */
		FILE *stream;	/* _STREAM, _FILE, _FILTER */
	    } source;
    } XeDataContent;

_XFUNCPROTOBEGIN
void XeWidgetWarningMsg
	(
#if NeedFunctionPrototypes
	 Widget, String, String, String *, Cardinal
#endif
	 );

void XeWidgetErrorMsg
	(
#if NeedFunctionPrototypes
	 Widget, String, String, String *, Cardinal
#endif
	 );


Boolean XeCvtStringToEnum
	(
#if NeedFunctionPrototypes
	 Display *, XrmValue *, Cardinal *,XrmValue *,XrmValue *,XtPointer *
#endif
	 );

Boolean XeCvtStringToHorizontalValue
	(
#if NeedFunctionPrototypes
	 Display *, XrmValue *, Cardinal *,XrmValue *,XrmValue *,XtPointer *
#endif
	 );

Visual *XeGetVisual
	(
#if NeedFunctionPrototypes
	 Widget
#endif
	 );

/*
** _XeBasicScaling
**	Compute the scaled size of the given rectangle as dictated by
**	the current values of resources 'scaling', core 'width' and
**	core 'height'
*/
void _XeBasicScaling
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,	/* Basic widget */
	 int, int,	/* Source width/height of the rectangle in pixels */
	 int, int,	/* Target width/height of the window */
	 Dimension *,	/* New scaled width of the rectangle in pixels */
	 Dimension *	/* New scaled height of the rectangle in pixels */
#endif
	 );

/*
** XeStartInputFlow
**	Initialize reading of the widget content asynchronously using
**	XeDataFlow mechanism. This will hide the actual source of the
**	content stream from the widget implementation. (If content is
**	given with memory pointer, no asynchronous operations really
**	occur, the whole content is just given in single 'feed' call;
**	the mechanism hides file and network access).
**
**	Returns NULL if failure.
*/
XeDataFlow *XeStartInputFlow
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,
	 XeDataFlowFeed,
	 XeDataFlowDone
#endif
);

/*
** XeFileOutFlow
**	Initialize asynchronous writing to a file using XeDataFlow
**	mechanism.
**
**	Returns NULL if failure.
*/
XeDataFlow *XeFileOutFlow
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Owner widget */
	 XeDataFlowMore,	/* Function called when more output allowed */
	 XeDataFlowDone,	/* Function called when output closed */
	 int			/* Output stream file number */
#endif
);

/*
** _XeOpenContent
**	open the content for input.
**
**	There is no special error return. If the content cannot be opened
**	the type will be set, but the corresponding source value (either
**	source.string or source.stream) will be NULL.
*/
void _XeOpenContent
	(
#if NeedFunctionPrototypes	 
	 XeBasicWidget,		/* Widget from which the content */
	 XeDataContent *	/* Address of the content handle */
#endif
	 );
/*
** _XeCloseContent
**	close the content structure openend by _XeOpenContent.
*/
void _XeCloseContent
	(
#if NeedFunctionPrototypes
	 XeDataContent *	/* Address of the content handle */
#endif
	 );

/*
** _XeGetContent
**	returns *all* of the current content bytes in a memory array.
**	If the input is pipe/network stream, this request will *block*
**	until EOF is reached. The returned value may be direct pointer
**	to the contentString resource.
*/
char *_XeGetContent
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget from which the content */
	 int *,			/* Return the length of the content */
	 int *			/* Return True, if return array need XtFree */
#endif
	 );

/*
** _XeGetContentCopy
**	returns *all* of the current content bytes in a memory array.
**	If the input is pipe/network stream, this request will *block*
**	until EOF is reached. The returned value is always a copy that
**	must be released with XtFree.
*/
char *_XeGetContentCopy
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget from which the content */
	 int *			/* Return the length of the content */
#endif
	 );

_XFUNCPROTOEND
#endif
