#ifndef _XewBasic_h
#define _XewBasic_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>

/*
** In proper X11 configuration, the _XFUNCPROTOBEGIN should already be
** defined, but just in case it is missing (like in R4), the following
** is copied from the X11R6 <X11/Xfuncproto.h>)
*/
#ifndef _XFUNCPROTOBEGIN
#ifdef __cplusplus			/* for C++ V2.0 */
#define _XFUNCPROTOBEGIN extern "C" {	/* do not leave open across includes */
#define _XFUNCPROTOEND }
#else
#define _XFUNCPROTOBEGIN
#define _XFUNCPROTOEND
#endif
#endif /* _XFUNCPROTOBEGIN */

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 activateCallback    activateCallback   Pointer         NULL
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 colormapUse         ColormapUse        XeColormapUse   XeColormapUse_SHARED
 colormapInstall     ColormapInstall    Boolean         False
 colorMode           ColorMode          XeColorMode     XeColorMode_COLOR
 contentFile         ContentFile        String          NULL
 contentFilter       ContentFilter      String          NULL
 contentFormat       ContentFormat      XeContentFormat XeContentFormat_UNKNOWN
 contentLoaded       ContentLoaded      Boolean         False
 contentLength       ContentLength      long            0
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 destroyCallback     Callback		Pointer		NULL
 exposeCallback      ExposeCallback     Pointer         NULL
 exportCallback      ExportCallback     Pointer         NULL
 cursor              Cursor             Cursor          None
 foreground	     Foreground		Pixel		XtDefaultForeground
 height	             Height		Dimension	0
 horizontal          FrameDimension     XeFrameDimension XeFrameDimension_MAX
 importCallback      importCallback     Pointer         NULL
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 maxColors           MaxColors          int             MAXINT
 mirrorImage         MirrorImage        Boolean         False
 notifyCallback      NotifyCallback     Pointer         NULL
 parentBackground    ParentBackground   Boolean         False
 resize              Resize             Boolean         True
 scaling             Scaling            XeScaling       XeScaling_WIDTH
 rotation            Rotation           int             0
 useShm              UseShm             Boolean         False
 userData	     UserData           Pointer         NULL
 vertical            FrameDimension     XeFrameDimension XeFrameDimension_MAX
 visual              Visual             Visual *        NULL
 width		     Width		Dimension	0
 x		     Position		Position	0
 xTranslation	     XTranslation	int		0
 y		     Position		Position	0
 yTranslation	     YTranslation	int		0
*/

typedef enum
    {
	XeContentFormat_UNKNOWN,/* Unknown format */
	XeContentFormat_ISO2022,/* ISO 2022 octet stream */
	XeContentFormat_TIFF,	/* TIFF 6.0 Base line */
	XeContentFormat_JPEG,	/* JPEG/JFIF stream */
	XeContentFormat_GIF,	/* GIF89a stream */
	XeContentFormat_CGM,	/* CGM octet stream */
	XeContentFormat_H261,	/* H.261 octet stream */
	XeContentFormat_AUDIO,	/* 8kHz u-law stream */
	XeContentFormat_ODIF,	/* ODA/ODIF stream */
	XeContentFormat_MPEG,	/* MPEG I video stream */
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
	XeContentFormat_RLE,	/* RLE stream */
/* End of addition made by barberjd */
	XeContentFormat_PBM	/* PBMPLUS Image streams */
    } XeContentFormat;

typedef enum
    {
	XeScaling_NONE,		/* No scaling, visualize in real size */
	XeScaling_WIDTH,	/* Width controlled, preserve aspect ratio */
	XeScaling_HEIGHT,	/* Height controlled, preserve aspect ratio */
	XeScaling_MAXASPECT,	/* Max size withing window, preserve aspect */
	XeScaling_FITAREA	/* Fit exactly into window, change aspect */
    } XeScaling;

/*
** XeFrameDimension
**	controls the horizontal and vertical dimensions of the child.
**	Both horizontal and vertical values are interpreted independently
**	according to following rules:
**
**	value > 0	specifies the fixed dimension in this direction
**	value = 0	use maximum possible dimension in this direction
**	value < 0	the dimension is controlled by the child
**
**	When frameDimension resource applies to the XeFrame itself,
**	two special values exist for the negative values:
**
**	-1 (XeFrameDimension_RULE_A)
**		The dimension will be selected such that it is sufficient
**		for the first child of the Frame.
**		
**	-2 (XeFrameDimension_RULE_B)
**		The dimension will be selected such that all children
**		of the fram will fit in this dimension.
*/
#define XeFrameDimension_MAX 0
#define XeFrameDimension_RULE_A (-1)
#define XeFrameDimension_RULE_B (-2)

typedef struct XeFrameDimension
    {
	int value;
	int min, max;	/* Min and Max */
    } XeFrameDimension;

typedef enum
    {
	XeColormapUse_SHARED,
	XeColormapUse_SHAREDOWN,
	XeColormapUse_OPTIONAL,
	XeColormapUse_PRIVATE
    } XeColormapUse;

typedef enum
    {
	XeColorMode_NONE,	/* Not Used */
	XeColorMode_MONO,	/* Use Bi-level (black/white) */
	XeColorMode_GRAY,	/* Use Gray Scale (if possible) */
	XeColorMode_COLOR	/* Use colors (if possible) */
    } XeColorMode;

/*
** XeDither
**	is not really a Basic resource, but is used by at least
**	Raster and Video, and thus needs to be defined for both
**	of them.
**
**	Specify whether dithering algorithm is to be used.
*/
typedef enum
    {
	XeDither_NONE,		/* No dithering */
	XeDither_FS4		/* Floyd-Sternberg with 4 errors */
    } XeDither;

/*
** XeColorQuantize
**	is not really a Basic resource, but is used by at least
**	Raster and Video, and thus needs to be defined for both
**	of them.
**
**	Specify how 24bit colors are to be presented on pseudocolor
**	displays.
*/
typedef enum
    {
	XeColorQuantize_FAST,	/* "Colorcube" mapping with/without dither */
	XeColorQuantize_HECKBERT,/* (from xv) Heckbert's Median Cut */
	XeColorQuantize_PPMQUANT,/* (from xv/PBMPLUS, ppmquant) */
	XeColorQuantize_JPEG	/* IJG quantification, only for jpeg images */
    } XeColorQuantize;

/*
** XeImaging
**	Control the final stages of the content Imaging process
*/
typedef struct
    {
	Boolean use_shm;
	XeColormapUse colormap_use;
	XeColorMode color_mode;
	XeDither dither;
	XeColorQuantize color_quantize;
	int max_colors;		/* Max number of colors to use */
    } XeImaging;

/*
** Known callback reasons in Xe widgets
*/
typedef enum
    {
	XeCR_UNKNOWN,		/* Unspecified callback reason */
	XeCR_NOTIFY,		/* Universal default reason for notify() */
	XeCR_NOTIFY_AREA,	/* Area of interest report */
	XeCR_EXPOSE,		/* Expose callback */
	XeCR_MODIFY_TEXT,	/* Text Content Modified */
	XeCR_LAYOUT_CHANGE_TAG,	/* Text Layout callback */
	XeCR_LAYOUT_BEGIN_LINE,	/* Text Layout callback */
	XeCR_ANIMATION_DONE,	/* Animation (video, audio) done callback */
	XeCR_ANIMATION_FRAME,	/* Animation (video, audio) fram callback */
	XeCR_EXPORT,		/* Universal Convert Selection callback */
	XeCR_IMPORT,		/* Universal Receive Selection callback */
	XeCR_FRAME_OVERFLOW,	/* Widget does not fit inside Frame Widget */
	XeCR_RASTER_IMAGE,	/* Raster Widget has loaded the Image */
	XeCR_ACTIVATE		/* Reason used for activate() */
    } XeCR;

/*
** XeCallData
**	is the general structure that is passed to all Xew callbacks in
**	Xew. Individual widget classes may have further extra fields and
**	have an alternate definition for the structure and different
**	callbacks, but the beginning always matches this structure.
**
**	NOTE:	The callback reason codes will be globally unique across
**		all Xe widgets (the reason code alone can be used to decide
**		about the actual structure that applies to call_data,
**		regardless of the source widget of the callback).
*/
typedef struct XeCallbackData
    {
	int reason;		/* Reason of the callback */
    } XeCallbackData;

/*
** XeNotifyCallData
**	is the universal default data for the notify callback.
*/
typedef struct XeNotifyCallbackData
    {
	int reason;		/* == XeCR_NOTIFY == */
	XEvent *event;		/* event that triggered the callback */
	String *params;		/* Point to args of 'notity(args)' */
	Cardinal num_params;	/* Number of arguments in 'args' */
    } XeNotifyCallbackData;

/*
** XeActivateCallbackData
**	is the data for the activate callback (only generated by
**	activate() action).
*/
typedef struct XeActivateCallbackData
    {
	int reason;		/* == XeCR_ACTIVATE == */
	XEvent *event;		/* event that triggered the callback */
	String *params;		/* Point to args of 'notity(args)' */
	Cardinal num_params;	/* Number of arguments in 'args' */
    } XeActivateCallbackData;

/*
** XeNotifyAreaCallbackData
**	is the data supplied for the XeCR_NOTIFY_AREA callback. This
**	callback is made via general XtNnotifyCallback. The widget uses
**	this callback when it detects that the area of interest shifts
**	outside the current parent window pounds (like moving the cursor
**	out of displayed area in Text Widget). This information can be
**	used to control vieports, portholes and similar constructs.
*/
typedef struct XeNotifyAreaCallbackData
    {
	int reason;		/* == XeCR_NOTIFY_AREA == */
	XRectangle area;	/* Area of interest */
	XRectangle visible;	/* Visiblea are of the window */
    } XeNotifyAreaCallbackData;

/*
** XeExposeCallbackData
**	is the data supplied for the XeCR_EXPOSE callback. This callback
**	is made via XtNexposeCallback after all of the widgets own
**	expose processing has been completed.
*/
typedef struct XeExposeCallbackData
    {
	int reason;		/* == XeCR_EXPOSE */
	XExposeEvent *event;	/* event that triggered the callback */
	Region region;		/* expose region parameter */
    } XeExposeCallbackData;
/*
** XeExportCallbackData
**	is the data supplied for the XeCR_EXPORT callback. This callback
**	is made from the widget ConvertSelection method (see description
**	of XtConvertSelectionProc for the semantics of selection, target,
**	type, value, length and format fields). Upon return from the
**	callback the return fields are copied to the corresponding
**	parameters of the XtConvertSelectionProc.
*/
typedef struct XeExportCallbackData
    {
	int reason;		/* == XeCR_EXPORT */
	Time time;		/* Time stamp from the selection request */
	Atom selection;		/* usually XA_PRIMARY or XA_SECONDARY */
	Atom target;		/* specifies the type of req. information */
	Atom type;		/* Type of the returned value */
	XtPointer value;	/* Address of the returned value */
	unsigned long length;	/* Length of the returned value */
	int format;		/* Bitsize of the value unit (8, 16, 32) */
    } XeExportCallbackData;
/*
** XeImportCallbackData
**	is the data supplied for the XeCR_IMPORT callback. This callback
**	is made from the widget SelectionReceived method (see description
**	of XtSelectionCallbackProc for the semantics of selection, type
**	value, length and format fields).
*/
typedef struct XeImportCallbackData
    {
	int reason;		/* == XeCR_IMPORT */
	Atom selection;		/* usually XA_PRIMARY or XA_SECONDARY */
	Atom type;		/* Type of the value */
	XtPointer value;	/* Address of the returned value */
	unsigned long length;	/* Length of the returned value */
	int format;		/* Bitsize of the value unit (8, 16, 32) */
    } XeImportCallbackData;

/*
** XeFrameOverflowCallbackData
**	is the data supplied for the XeCR_FRAME_OVERFLOW callback. This
**	callback is made via general XtNoverflowCallback. The XeFrame calls
**	this callback during layout for each child widget that does not fit
**	inside the frame.
**
**	If the callback changes the child widget in way that migth make it
**	possible to fit in, it can set the 'redo' field in callback to TRUE.
**	(Must be careful with this to prevent loops, the child may not fit
**	even after changes.)
*/
typedef struct XeFrameOverflowCallbackData
    {
	int reason;		/* == XeCR_FRAME_OVERFLOW == */
	Widget widget;		/* Child Widget */
	XRectangle child;	/* Child Widget rectangle */
	XRectangle frame;	/* Frame Widget rectangle (parent) */
	int redo;		/* Initialized to FALSE! */
    } XeFrameOverflowCallbackData;

/*
** XeRasterImageCallbackData
**	is the data supplied for the XeCR_RASTER_IMAGE callback. This
**	callback is made via XtNnotifyCallback. The XeRaster calls this
**	callback every time after it has loaded a new image, but has
**	not built the display form for it.
**
** *NOTE*
**	This function is called even if the image import operation fails,
**	in which case width and height will be 0.
*/
typedef struct XeRasterImageCallbackData
    {
	int reason;		/* == XeCR_RASTER_IMAGE == */
	int width, height;	/* Image Dimensions */
    } XeRasterImageCallbackData;

#define XtCFrameDimension "FrameDimension"
#define XeRFrameDimension "XeFrameDimension"

/* New fields */
#ifndef XtNactivateCallback
#define XtNactivateCallback "activateCallback"
#define XtCActivateCallback "ActivateCallback"
#endif
#define XtNcolormapUse "colormapUse"
#define XtCColormapUse "ColormapUse"
#define XtRXeColormapUse "XeColormapUse"
#define XtNcolormapInstall "colormapInstall"
#define XtCColormapInstall "ColormapInstall"
#define XtNcolorMode "colorMode"
#define XtCColorMode "ColorMode"
#define XtRXeColorMode "XeColorMode"
#define XtNcolorQuantize "colorQuantize"
#define XtCColorQuantize "ColorQuantize"
#define XtRXeColorQuantize "XeColorQuantize"
#define XtNcursor "cursor"
#define XtNcontentFile "contentFile"
#define XtCContentFile "ContentFile"
#define XtNcontentFilter "contentFilter"
#define XtCContentFilter "ContentFilter"
#define XtNcontentFormat "contentFormat"
#define XtCContentFormat "ContentFormat"
#define XtRXeContentFormat "XeContentFormat"
#define XtNcontentLoaded "contentLoaded"
#define XtCContentLoaded "ContentLoaded"
#define XtNcontentStream "contentStream"
#define XtCContentStream "ContentStream"
#define XtNcontentString "contentString"
#define XtCContentString "contentString"
#define XtNcontentLength "contentLength"
#define XtCContentLength "ContentLength"
#define XtNcontentOffset "contentOffset"
#define XtCContentOffset "ContentOffset"
#define XtNdither "dither"
#define XtCDither "Dither"
#define XtRXeDither "XeDither"
#define XtNexposeCallback "exposeCallback"
#define XtCExposeCallback "ExposeCallback"
#define XtNexportCallback "exportCallback"
#define XtCExportCallback "ExportCallback"
#ifndef XtNhorizontal
#define XtNhorizontal "horizontal"
#endif
#define XtNimportCallback "importCallback"
#define XtCImportCallback "ImportCallback"
#define XtNmaxColors "maxColors"
#define XtCMaxColors "MaxColors"
#define XtNmirrorImage "mirrorImage"
#define XtCMirrorImage "MirrorImage"
#define XtNnotifyCallback "notifyCallback"
#define XtCNotifyCallback "NotifyCallback"
#define XtNparentBackground "parentBackground"
#define XtCParentBackground "ParentBackground"
#define XtNrotation "rotation"
#define XtCRotation "Rotation"
#define XtNscaling "scaling"
#define XtCScaling "scaling"
#define XtRXeScaling "XeScaling"
#define XtRHorizontalValue "HorizontalValue"
#define XtRVerticalValue "VerticalValue"
#define XtNuseShm "useShm"
#define XtCUseShm "UseShm"
#ifndef XtNvertical
#define XtNvertical "vertical"
#endif
#ifndef XtNvisual
#define XtNvisual "visual"
#endif
#ifndef XtCVisual
#define XtCVisual "Visual"
#endif
#define XtNxTranslation "xTranslation"
#define XtCXTranslation "XTranslation"
#define XtNyTranslation "yTranslation"
#define XtCYTranslation "YTranslation"

#ifndef XtNuserData
#define XtNuserData "userData"
#define XtCUserData "UserData"
#endif

/* Class record constants */

extern WidgetClass xeBasicWidgetClass;

typedef struct _XeBasicClassRec *XeBasicWidgetClass;
typedef struct _XeBasicRec      *XeBasicWidget;


#endif
