/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/BasicP.h>
#include "PrintP.h"
#include <errno.h>
#include <ctype.h>
#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif
#if ANSI_INCLUDES
#	include <stdlib.h>
#else
extern int atoi( /* No header for this in SYSV? */
#if NeedFunctionPrototypes
		char *
#endif
		);

#endif

#include <fcntl.h>	/* Is this standard header? check! --msa */
#include "Color.h"
#include "BasicColor.h"

/*
** X11R4 doesn't seem to have XmuCvtStringToCursor. Register this
** converter only for post X11R4 releases. The resource 'cursor'
** is defined always, whether converter exists or not.
*/
#define Have_XmuCvtStringToCursor ((XtVersion) > 11004)

#if NeedFunctionPrototypes
static void EnterWindow(Widget, XEvent *, String *, Cardinal *);
static void LeaveWindow(Widget, XEvent *, String *, Cardinal *);
static void Notify(Widget, XEvent *, String *, Cardinal *);
static void Activate(Widget, XEvent *, String *, Cardinal *);
#else
static void EnterWindow();
static void LeaveWindow();
static void Notify(), Activate();
#endif

static char defaultTranslations[] =
"\
<Btn1Down>,<Btn1Up>: notify()\n\
<EnterWindow>:	enter-window()\n\
<LeaveWindow>:	leave-window()\
";

static XtActionsRec actions[] =
    {
	    {"activate",	Activate},
	    {"notify",		Notify},
	    {"enter-window",	EnterWindow},
	    {"leave-window",	LeaveWindow},
    };

static XeFrameDimension init_FrameDimension;

#define offset(field) XtOffsetOf(XeBasicRec, basic.field)
static XtResource resources[] =
    {
	{XtNactivateCallback,XtCActivateCallback,XtRCallback,sizeof(XtPointer),
		 offset(activate_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNborderWidth, XtCBorderWidth, XtRDimension, sizeof(Dimension),
		 XtOffsetOf(XeBasicRec, core.border_width),
		 XtRImmediate, (XtPointer)0},
	{XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
		 offset(cursor), XtRImmediate, (XtPointer)None},
	{XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
		 offset(foreground_pixel), XtRString, XtDefaultForeground},
	{XtNcolormapUse, XtCColormapUse, XtRXeColormapUse,
		 sizeof(XeColormapUse), offset(imaging.colormap_use),
		 XtRImmediate, (XtPointer)XeColormapUse_SHARED},
	{XtNcolormapInstall, XtCColormapInstall, XtRBoolean,
		 sizeof(Boolean),offset(colormap_install),XtRImmediate,False},
	{XtNcolorMode, XtCColorMode, XtRXeColorMode,
		 sizeof(XeColorMode), offset(imaging.color_mode),
		 XtRImmediate, (XtPointer)XeColorMode_COLOR},
	{XtNcolorQuantize, XtCColorQuantize, XtRXeColorQuantize,
		 sizeof(XeColorQuantize), offset(imaging.color_quantize),
		 XtRImmediate, (XtPointer)XeColorQuantize_FAST},
	{XtNcontentFile, XtCContentFile, XtRString, sizeof(String),
		 offset(content_file), XtRImmediate, (XtPointer)NULL},
	{XtNcontentFilter, XtCContentFilter, XtRString, sizeof(String),
		 offset(content_filter), XtRImmediate, (XtPointer)NULL},
	{XtNcontentFormat, XtCContentFormat, XtRXeContentFormat,
		 sizeof(XeContentFormat), offset(content_format),
		 XtRImmediate, (long)XeContentFormat_UNKNOWN},
	{XtNcontentStream, XtCContentStream, XtRFile, sizeof(FILE *),
		 offset(content_stream), XtRImmediate, (XtPointer)NULL},
	{XtNcontentString, XtCContentString, XtRString, sizeof(String),
		 offset(content_string), XtRImmediate, (XtPointer)NULL},
	{XtNcontentOffset, XtCContentOffset, XtRLong, sizeof(long),
		 offset(content_offset), XtRImmediate, (long)0},
	{XtNcontentLength, XtCContentLength, XtRLong, sizeof(long),
		 offset(content_length), XtRImmediate, (long)0},
	{XtNcontentLoaded, XtCContentLoaded, XtRBoolean, sizeof(Boolean),
		 offset(content_loaded), XtRImmediate, False},
        {XtNdither, XtCDither, XtRXeDither, sizeof(XeDither),
		 offset(imaging.dither),
		 XtRImmediate, (XtPointer)XeDither_FS4 },
	{XtNexportCallback, XtCExportCallback, XtRCallback, sizeof(XtPointer),
		 offset(export_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNexposeCallback, XtCExposeCallback, XtRCallback, sizeof(XtPointer),
		 offset(expose_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNhorizontal, XtCFrameDimension, XeRFrameDimension,
		 sizeof(XeFrameDimension), offset(dimension[FRAME_HORIZONTAL]),
		 XeRFrameDimension, (XtPointer)&init_FrameDimension},
	{XtNimportCallback, XtCImportCallback, XtRCallback, sizeof(XtPointer),
		 offset(import_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNmaxColors, XtCMaxColors, XtRInt, sizeof(int),
		 offset(imaging.max_colors), XtRImmediate, (XtPointer)65535},
	{XtNmirrorImage, XtCMirrorImage, XtRBoolean, sizeof(Boolean),
		 offset(mirror_image), XtRImmediate, False},
	{XtNnotifyCallback, XtCNotifyCallback, XtRCallback, sizeof(XtPointer),
		 offset(notify_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNparentBackground, XtCParentBackground,XtRBoolean,sizeof(Boolean),
		 offset(parent_background), XtRImmediate, False},
	{XtNresize, XtCResize, XtRBoolean, sizeof(Boolean),
		 offset(resize), XtRImmediate, (XtPointer)True},
	{XtNrotation, XtCRotation, XtRInt, sizeof(int),
		 offset(rotation), XtRImmediate, 0},
	{XtNscaling, XtCScaling, XtRXeScaling, sizeof(XeScaling),
		 offset(scaling), XtRImmediate, (XtPointer)XeScaling_WIDTH},
	{XtNuseShm, XtCUseShm, XtRBoolean, sizeof(Boolean),
		 offset(imaging.use_shm), XtRImmediate, False},
#ifndef USING_MOTIF_122
	{XtNuserData, XtCUserData, XtRPointer, sizeof(XtPointer),
		 offset(user_data), XtRImmediate, 0},
#endif
	{XtNvertical, XtCFrameDimension, XeRFrameDimension,
		 sizeof(XeFrameDimension), offset(dimension[FRAME_VERTICAL]),
		 XeRFrameDimension, (XtPointer)&init_FrameDimension},
	{XtNvisual, XtCVisual, XtRVisual,
		 sizeof(Visual *), offset(visual), XtRImmediate, 0},
	{XtNxTranslation, XtCXTranslation, XtRInt, sizeof(int),
		 offset(x_translation), XtRImmediate, 0},
	{XtNyTranslation, XtCYTranslation, XtRInt, sizeof(int),
		 offset(y_translation), XtRImmediate, 0},
    };
#undef offset

static void Initialize(), Realize(), Destroy(), Redisplay();
static void ClassPartInitialize(), ClassInitialize();
static Boolean SetValues();
static XtGeometryResult GeometryManager();
static void PrintInitialize(), PrintDestroy();

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeBasicbaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

#ifdef USING_MOTIF_122
#define SuperClass ((WidgetClass)&xmManagerClassRec)
#else
#define SuperClass ((ConstraintWidgetClass)&constraintClassRec)
#endif

XeBasicClassRec xeBasicClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) SuperClass,
    /* class_name		*/	"XeBasic",
    /* widget_size		*/	sizeof(XeBasicRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeBasicbaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields */
    /* geometry_manager		*/	GeometryManager,
    /* change_managed		*/	XtInheritChangeManaged,
    /* insert_child		*/	XtInheritInsertChild,
    /* delete_child		*/	XtInheritDeleteChild,
    /* extension		*/	NULL
  },
  { /* constraint class fields */
    /* subresources		*/	NULL,
    /* subresource_count	*/	0,
    /* constraint_size		*/	0,
    /* initialize		*/	NULL,
    /* destroy			*/	NULL,
    /* set_values		*/	NULL,
    /* extension		*/	NULL
   },
#ifdef USING_MOTIF_122
   { /* manager class record	*/
     /* translations		*/	XtInheritTranslations,
     /* syn_resources		*/	NULL,
     /* num_syn_resources	*/	0,
     /* syn_constraint_resources */	NULL,
     /* num_syn_constraint_resources */	0,
     /* parent_process		*/	XmInheritParentProcess,
     /* extension		*/	NULL  
   },
#endif
   { /* basic fields */
     /* print_initialize	*/	PrintInitialize,
     /* print			*/	_XeDefaultPrint,
     /* print_cancel		*/	_XeDefaultPrintCancel,
     /* print_finish		*/	PrintDestroy,
     /* print_constraint_initialize */	NULL,
     /* print_constraint_destroy */	NULL
   }
};

WidgetClass xeBasicWidgetClass = (WidgetClass)&xeBasicClassRec;


static CvtEnumInfo cvtContentFormat[] =
    {
	{"unknown",	XeContentFormat_UNKNOWN },
	{"iso2022",	XeContentFormat_ISO2022 },
	{"tiff",	XeContentFormat_TIFF },
	{"jpeg",	XeContentFormat_JPEG },
	{"gif",		XeContentFormat_GIF },
	{"pbm",		XeContentFormat_PBM },
	{"cgm",		XeContentFormat_CGM },
	{"h261",	XeContentFormat_H261 },
	{"mpeg",	XeContentFormat_MPEG },
	{"audio",	XeContentFormat_AUDIO },
	{"odif",	XeContentFormat_ODIF },
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
	{"rle",		XeContentFormat_RLE },
/* End of addition made by barberjd */
	{NULL,		sizeof(XeContentFormat) },
    };

static CvtEnumInfo cvtScaling[] =
    {
	{"none",	XeScaling_NONE },
	{"width",	XeScaling_WIDTH },
	{"height",	XeScaling_HEIGHT },
	{"maxaspect",	XeScaling_MAXASPECT },
	{"fitarea",	XeScaling_FITAREA },
	{NULL,		sizeof(XeScaling) },
    };

static CvtEnumInfo cvtColormapUse[] =
    {
	{"shared",	XeColormapUse_SHARED },
	{"sharedown",	XeColormapUse_SHAREDOWN },
	{"optional",	XeColormapUse_OPTIONAL },
	{"private",	XeColormapUse_PRIVATE },
	{NULL,		sizeof(XeColormapUse) },
    };

static CvtEnumInfo cvtColorMode[] =
    {
	{"none",	XeColorMode_NONE},
	{"mono",	XeColorMode_MONO},
	{"gray",	XeColorMode_GRAY},
	{"color",	XeColorMode_COLOR},
	{NULL,		sizeof(XeColorMode) },
    };

static CvtEnumInfo cvtDither[] =
    {
	{"none",	XeDither_NONE},
	{"fs4",		XeDither_FS4 },
	{NULL,		sizeof(XeDither) },
    };

static CvtEnumInfo cvtColorQuantize[] =
    {
	{"fast",	XeColorQuantize_FAST },
	{"heckbert",	XeColorQuantize_HECKBERT },
	{"ppmquant",	XeColorQuantize_PPMQUANT },
	{"jpeg",	XeColorQuantize_JPEG },
	{NULL,		sizeof(XeColorQuantize) },
    };

#define	CvtDone(type, value)				\
    do {						\
	if (toVal->addr != NULL)			\
	    {						\
		if (toVal->size < sizeof(type))		\
		    {					\
			toVal->size = sizeof(type);	\
			return False;			\
		    }					\
		*(type*)(toVal->addr) = (value);	\
	    }						\
	else						\
	    {						\
		static type static_val;			\
		static_val = (value);			\
		toVal->addr = (XPointer)&static_val;	\
	    }						\
	toVal->size = sizeof(type);			\
	return True;					\
    } while (0)


/*
** XeCvtStringToEnum
**	Generic String to Enumeration value converter
*/
Boolean XeCvtStringToEnum(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal, *toVal;
XtPointer *converter_data;
    {
	static int e;

	char lower[100];
	int len;
	String params[1];
	Cardinal num_params;
	char *s = (char *) fromVal->addr;
	CvtEnumInfo *list;

	if (*num_args != 1)
	    {
		XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
				"wrongParameters","XeCvtStringToEnum",
				"XewError",
		       "String to Enumeration conversion needs one argument",
				(String *)NULL, (Cardinal *)NULL);
		return False;
	    }
	list = (CvtEnumInfo *)args[0].addr;
	if (s == NULL || (len = strlen(s)) >= sizeof(lower))
		return False;
	XmuCopyISOLatin1Lowered(lower, s);

	for (;; list += 1)
	    {
		if (list->name == NULL)
		    {
			params[0] = (String)fromVal->addr;
			num_params = 1;
			XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
					"XeCvtStringToEnum",
					"unknownKeyword",
					"XewError",
					"Cannot convert \"%s\" to Enumeration",
					params,
					&num_params);
			return False;
		    }
		if (strcmp(lower, list->name) == 0)
		    {
			e = list->value;
			break;
		    }
	    }
	CvtDone(int, e);
    }

/*
** XeCvtStringToPixel
**	is a modified version of XtCvtStringPixel that uses Xew Color
**	library instead of raw XAllocNamed color.
*/
static Boolean XeCvtStringToPixel
	(dpy, args, num_args, fromVal, toVal, closure_ret)
Display* dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *closure_ret;
    {
	String str = (String)fromVal->addr;
	XColor color;
	XeSample red, green, blue;
	Screen *screen;
	Colormap colormap;
	Status status;
	String params[1];
	Cardinal num_params=1;

	if (*num_args != 2)
	    {
		XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
				"wrongParameters","XeCvtStringToPixel",
				"XewError",
	"String to pixel conversion needs screen and colormap arguments",
				(String *)NULL, (Cardinal *)NULL);
		return False;
	    }
	screen = *((Screen **) args[0].addr);
	colormap = *((Colormap *) args[1].addr);

	if (XmuCompareISOLatin1(str, XtDefaultBackground) == 0)
	    {
		*closure_ret = False;
		CvtDone(Pixel, WhitePixelOfScreen(screen));
	    }
	if (XmuCompareISOLatin1(str, XtDefaultForeground) == 0)
	    {
		*closure_ret = False;
		CvtDone(Pixel, BlackPixelOfScreen(screen));
	    }
	status = XParseColor(DisplayOfScreen(screen), colormap,
			     (char*)str, &color);
	if (status == 0)
	    {
		params[0] = str;
		XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
				"badColor", "cvtStringToPixel", "XewError",
				"Cannot parse color \"%s\" definition",
				params, &num_params);
		*closure_ret = False;
		return False;
	    }
	red = XToSample(color.red);
	green = XToSample(color.green);
	blue = XToSample(color.blue);
	(void)XeAllocColors
		(DisplayOfScreen(screen), RootWindowOfScreen(screen), colormap,
		 XeColormapUse_SHAREDOWN, 1, 1,
		 &red, &green, &blue, &color.pixel);
	*closure_ret = (char*)True;
	CvtDone(Pixel, color.pixel);
    }

#ifdef not_used_but_left_as_reference_for_future_need

typedef enum
    {
	XeUnit_MILLIMETER,
	XeUnit_DIDOTPOINT,
	XeUnit_PICAPOINT,
	XeUnit_INCH,
	XeUnit_AGATE
    } XeUnit;

static double Scale[5][5] =
    {
	/*   millimeters  didotPoints  picaPoints  inches     agates */
	{    1.0,         2.66014,     2.846035,   0.03937,   14.7994   },
	{    0.375920,    1.0,         1.0698821,  0.0148,    5.5634    },
	{    0.351365,    0.934682,    1.0,        0.0138333, 5.2       },
	{    25.4,        67.567568,   72.2893,    1.0,       375.90436 },
	{    0.06757,     0.179746,    0.1923,     0.00266,   1.0       },
    };

/*
** XeConvert
**	Convert a measure given in some unit (SrcU/SrcF) into another
**	unit (DstU/DstF).
*/
static long XeConvert(DstU, DstF, SrcV, SrcU, SrcF)
int DstU, DstF;
long SrcV;
int SrcU, SrcF;
    {
	return ((SrcV*(double)DstF)/SrcF*Scale[SrcU][DstU]+0.5);
    }

/*
** XeConvertScaled
**	Does the same as Convert, but the result is scaled using the
**	specified scaling parameters. The actual result is something like
**
**		 Q
**		--- * Convert(....)
**		 R
**
**	but with the benefit of minimal rounding errors (if you used the
**	the above expression, there would be two roundings...)
*/
static long XeConvertScaled(DstU, DstF, SrcV, SrcU, SrcF, Q, R)
int DstU, DstF;
long SrcV;
int SrcU, SrcF;
long Q, R;
    {
	return (SrcV*(double)DstF*Q)/(SrcF*R) * Scale[SrcU][DstU]+0.5;
    }

typedef struct
    {
	char name[4];
	XeUnit unit;
	int fraction;
    } XeUnitDefinition;

static XeUnitDefinition unit_table[] =
    {
	{ "mm", XeUnit_MILLIMETER, 1, },
	{ "i", XeUnit_INCH, 1, },
	{ "p", XeUnit_PICAPOINT, 1, },
    };

/*
** XeConvertDimension
**	Convert input units into pixels (horizontal or vertical)
**
**	(under construction--keep off!)
*/
static Dimension XeConvertDimension(s, pixels, mms)
char *s;
int pixels;
int mms;
    {
	int d;
	char *q = s;
	XeUnitDefinition *u;

	d = atoi(q);
	while (isdigit(*q))
		++q;
	while (isspace(*q))
		++q;
	for (u = &unit_table[0]; u < &unit_table[XtNumber(unit_table)]; ++u)
		if (strcmp(u->name, q) == 0)
		    {
			return d;
		    }
	return d;
    }
#endif

/*
** XeCvtStringToHorizontalValue
*/
Boolean XeCvtStringToHorizontalValue(dpy, args, num_args, fromVal, toVal,
				     converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal, *toVal;
XtPointer *converter_data;
    {
	static int d;

	char *s = (char *) fromVal->addr;

	d = atoi(s); /* Dummy Thing Here */
	CvtDone(int, d);
    }

static void ClassInitialize()
    {
#if Have_XmuCvtStringToCursor
	static XtConvertArgRec convertArg[] =
	    {
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.screen),
		    sizeof(Screen *),
		},
		{
		    XtResourceString,
		    (XtPointer) XtNpointerColor,
		    sizeof(Pixel),
		},
	        {
		    XtResourceString,
		    (XtPointer) XtNpointerColorBackground, 
		    sizeof(Pixel),
		},
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.colormap),
		    sizeof(Colormap),
		}
	    };
#endif
	static XtConvertArgRec convertPixelArg[] =
	    {
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.screen),
		    sizeof(Screen *),
		},
		{
		    XtWidgetBaseOffset,
		    (XtPointer) XtOffsetOf(WidgetRec, core.colormap),
		    sizeof(Colormap),
		}
	    };
	static XtConvertArgRec convertContentFormatArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtContentFormat[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertScalingArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtScaling[0],
		    sizeof(XtPointer),
		}
	    };

	static XtConvertArgRec convertColormapUseArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColormapUse[0],
		    sizeof(XtPointer),
		}
	    };

	static XtConvertArgRec convertColorModeArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColorMode[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertDitherArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtDither[0],
		    sizeof(XtPointer),
		}
	    };
	static XtConvertArgRec convertColorQuantizeArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtColorQuantize[0],
		    sizeof(XtPointer),
		}
	    };

	XewInitializeWidgetSet();
#if Have_XmuCvtStringToCursor
	XtSetTypeConverter(XtRString, XtRColorCursor,
			   XmuCvtStringToColorCursor,
			   convertArg, XtNumber(convertArg), 
			   XtCacheByDisplay, NULL);
#endif
	/* Override Xt String to Pixel with own converter!! */

	XtSetTypeConverter(XtRString, XtRPixel,
			   XeCvtStringToPixel,
			   convertPixelArg,
			   XtNumber(convertPixelArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeColormapUse,
			   XeCvtStringToEnum,
			   convertColormapUseArg,
			   XtNumber(convertColormapUseArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeColorMode,
			   XeCvtStringToEnum,
			   convertColorModeArg, XtNumber(convertColorModeArg),
			   XtCacheNone, NULL);
	XtSetTypeConverter(XtRString, XtRXeDither,
			   XeCvtStringToEnum,
			   convertDitherArg, XtNumber(convertDitherArg),
			   XtCacheNone, NULL);
	XtSetTypeConverter(XtRString, XtRXeColorQuantize,
			   XeCvtStringToEnum,
			   convertColorQuantizeArg,
			   XtNumber(convertColorQuantizeArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRHorizontalValue,
			   XeCvtStringToHorizontalValue,
			   (XtConvertArgList)NULL, 0,
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeScaling,
			   XeCvtStringToEnum,
			   convertScalingArg, XtNumber(convertScalingArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
	XtSetTypeConverter(XtRString, XtRXeContentFormat,
			   XeCvtStringToEnum,
			   convertContentFormatArg,
			   XtNumber(convertContentFormatArg), 
			   XtCacheNone, NULL);
#ifdef USING_MOTIF_122
        _XeBasicbaseClassExtRec.record_type = XmQmotif;
#endif
    }


static void Initialize (request, new)
Widget request, new;
    {
	XeBasicWidget w = (XeBasicWidget)new;

	w->basic.cmap = 0;
#ifdef SH_MEM
	if (w->basic.imaging.use_shm && XShmQueryExtension(XtDisplay(w)))
	    {
		int major, minor, stat;
		Bool pixs;

		stat = XShmQueryVersion(XtDisplay(w), &major, &minor, &pixs);
		w->basic.imaging.use_shm = (stat != 0);
		if (stat && pixs)
			w->basic.imaging.use_shm = 2;
	    }
	else
		w->basic.imaging.use_shm = False;
#endif
	/*
	** Make local copies of some resource values
	*/
	if (w->basic.content_file)
		w->basic.content_file = XtNewString(w->basic.content_file);
	if (w->basic.content_filter)
		w->basic.content_filter = XtNewString(w->basic.content_filter);
    }

/*
** XeWidgetWarningMsg
**	This function calls XtAppWarningMsg with the fixed class=XeWidgetError,
**	passing other parameters unchanged (expect note, that num_params is
**	is by value here).
*/
void XeWidgetWarningMsg(w, type, defaultp, params, num_params)
Widget w;
String type;
String defaultp;
String *params;
Cardinal num_params;
    {
	XtAppWarningMsg(XtWidgetToApplicationContext(w),/* app_context */
		      (XtClass(w))->core_class.class_name,/* name */
		      type,				/* type */
		      "XeWidgetError",			/* class */
		      defaultp,				/* default */
		      params,				/* params */
		      &num_params);			/* num_params */
    }		      


/*
** XeWidgetErrorMsg
**	This function calls XtAppErrorMsg with the fixed class=XeWidgetError,
**	passing other parameters unchanged. (expect note, that num_params is
**	is by value here).
*/
void XeWidgetErrorMsg(w, type, defaultp, params, num_params)
Widget w;
String type;
String defaultp;
String *params;
Cardinal num_params;
    {
	XtAppErrorMsg(XtWidgetToApplicationContext(w),/* app_context */
		      (XtClass(w))->core_class.class_name,/* name */
		      type,				/* type */
		      "XeWidgetError",			/* class */
		      defaultp,				/* default */
		      params,				/* params */
		      &num_params);			/* num_params */
    }		      


/*
** XeGetVisual
**	Get the poiner to the visual structure associated with the
**	window of the widget. This is two-way request...
*/
Visual *XeGetVisual(w)
Widget w;
    {
	XWindowAttributes attribs;

	XGetWindowAttributes(XtDisplay(w), XtWindow(w), &attribs);
	return attribs.visual;
    }

/*
** _XeBasicScaling
**	Compute the scaled size of the given rectangle as dictated by
**	the current values of resources 'scaling' and window dilemsions.
*/
void _XeBasicScaling(widget, width, height, wTarget, hTarget, wScaled, hScaled)
XeBasicWidget widget;	/* Basic widget */
int width, height;	/* Source width/height of the rectangle in pixels */
int wTarget, hTarget;	/* Target width/height of the window */
Dimension *wScaled;	/* New scaled width of rectangle in pixels */
Dimension *hScaled;	/* New scaled height of rectangle in pixels */
    {
	XeScaling scaling = widget->basic.scaling;

	if (width == 0 || height == 0)
		scaling = XeScaling_FITAREA; /* Kludge! */
	else if ((wTarget == 0 && hTarget == 0) ||
	    (wTarget == 0 && scaling == XeScaling_WIDTH) ||
	    (hTarget == 0 && scaling == XeScaling_HEIGHT))
		scaling = XeScaling_NONE;
	else if (scaling == XeScaling_FITAREA ||
		 scaling == XeScaling_MAXASPECT)
		if (wTarget == 0)
			scaling = XeScaling_HEIGHT;
		else if (hTarget == 0)
			scaling = XeScaling_WIDTH;
	if (scaling != XeScaling_FITAREA &&
	    (widget->basic.rotation == 90 || widget->basic.rotation == 270))
	    {
		int tmp = width;
		width = height;
		height = tmp;
	    }
	switch (scaling)
	    {
	    case XeScaling_WIDTH:
		/*
		** Set new width from the core width and set the height
		** from that preserving the aspect ratio.
		*/
		*hScaled = (wTarget * height + width/2) / width;
		*wScaled = wTarget;
		break;
	    case XeScaling_HEIGHT:
		/*
		** Set new heigth from the core width and set the width
		** from that preserving the aspect ratio.
		*/
		*wScaled = (hTarget * width + height/2) / height;
		*hScaled = hTarget;
		break;
	    case XeScaling_FITAREA:
		/*
		** Set new width and height directly from the core
		** width and height.
		*/
		*wScaled = wTarget;
		*hScaled = hTarget;
		break;
	    case XeScaling_MAXASPECT:
		*wScaled = (hTarget * width + height/2) / height;
		if (*wScaled > wTarget)
		    {
			*hScaled = (wTarget * height + width/2) / width;
			*wScaled = wTarget;
		    }
		else
			*hScaled = hTarget;
		
		break;
	    case XeScaling_NONE:
	    default:
		/*
		** Return actual size as scaled size
		*/
		*wScaled = width;
		*hScaled = height;
		break;
	    }
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
	XeBasicWidgetClass c = (XeBasicWidgetClass)class;
	XeBasicWidgetClass super =
		(XeBasicWidgetClass)c->core_class.superclass;

	if (c->basic_class.print == XeInheritPrint)
		c->basic_class.print = super->basic_class.print;
	if (c->basic_class.print_cancel == XeInheritPrintCancel)
		c->basic_class.print_cancel = super->basic_class.print_cancel;
    }

/*
** GeometryManager
**	becauase there is no default composite/constraint for the
**	geometry manager, define a very simple one here that accepts
**	all proposed size queries.
*/
static XtGeometryResult GeometryManager(w, request, reply)
Widget w;
XtWidgetGeometry *request, *reply;
    {
	XtWidgetGeometry rq;

	rq = *request;

	if (rq.request_mode & ~(XtCWQueryOnly | CWWidth | CWHeight))
		return XtGeometryNo; /* Something other than size... */
	if ((rq.request_mode & CWWidth) == 0)
		rq.width = w->core.width;
	if ((rq.request_mode & CWHeight) == 0)
		rq.height = w->core.height;
	if (rq.width == w->core.width && rq.height == w->core.height)
		return XtGeometryNo;
	if ((rq.request_mode & XtCWQueryOnly) == 0)
	    {
		w->core.width = rq.width;
		w->core.height = rq.height;
	    }
	return XtGeometryYes;
    }

static void Redisplay(w, e, r)
Widget w;
XExposeEvent *e;
Region r;
    {
	XeExposeCallbackData data;
	data.reason = XeCR_EXPOSE;
	data.event = e;
	data.region = r;
	XtCallCallbackList(w, ((XeBasicWidget)w)->basic.expose_callbacks,
			   (XtPointer)&data);
    }

/*
**	****************
**	Printing support
**	****************
*/
static void PrintInitialize(w, c, pp)
Widget w, c;
XePrintProcess pp;
    {
	XeBasicWidget clone = (XeBasicWidget)c;
	XeBasicWidget bw = (XeBasicWidget)w;
	XeSample r, g, b;
	/*
	** Override the imaging attributes in the clone structure
	*/
	clone->basic.imaging = pp->printer->imaging;
	/*
	** Special with colormode: if the widget color_mode specifies
	** less than printing color mode, use the widget one.
	*/
	if (bw->basic.imaging.color_mode != XeColorMode_NONE &&
	    bw->basic.imaging.color_mode < clone->basic.imaging.color_mode)
		clone->basic.imaging.color_mode = bw->basic.imaging.color_mode;
	/*
	** ..a bit dubious juggling with max_colors, but this makes it
	** easier to use XePrinter structure.. most sensible defaults
	** are produced by zeroing the structure.. -- msa
	*/
	if (clone->basic.imaging.max_colors <= 0)
		clone->basic.imaging.max_colors =
			((XeBasicWidget)w)->basic.imaging.max_colors;
	clone->basic.colormap_install = False;

	/*
	** Transfer foreground_pixel. Upon entering PrintInitialize, the
	** pixel still has the original value. Retrieve the colors using
	** the original widget and allocate a new pixel matching the
	** colors from the printer.
	*/
	if (pp->printer->background)
		XeQueryColors(XtDisplay(w), w->core.colormap, 1,
			      &clone->basic.foreground_pixel, &r, &g, &b);
	else
		r = g = b = 0; /* 'black' */

	(void)XeAllocColors
		(XtDisplay(c), XtWindow(c), c->core.colormap,
		 XeColormapUse_SHARED, 1, 1, &r, &g, &b,
		 &clone->basic.foreground_pixel);
    }

static void PrintDestroy(w, c, pp)
Widget w, c;
XePrintProcess pp;
    {
	XeBasicWidget clone = (XeBasicWidget)c;

	XeFreeColors(XtDisplay(c), clone->core.colormap,
		     1, &clone->basic.foreground_pixel);
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	XeBasicWidget s_old = (XeBasicWidget) current;
	XeBasicWidget s_new = (XeBasicWidget) new;
	Boolean new_cursor = FALSE;
	
	if (s_old->basic.cursor != s_new->basic.cursor)
	    {
		new_cursor = TRUE;
		/*
		** If the converter fails, the cursor will end up Zero,
		** change it into None with a warning.
		*/
		if (s_new->basic.cursor == 0)
		    {
			XtWarning(
			 "Probable incorrect cursor name--replaced with None");
			s_new->basic.cursor = None;
		    }
	    }
	if (s_old->basic.visual != s_new->basic.visual)
	    {
		s_new->basic.visual = s_old->basic.visual;
		XeWidgetWarningMsg((Widget)s_old, "noteBasicVisual",
				   "Cannot change visual with set_values",
				   (String *)NULL, 0);
	    }
	/*
	** If contentString resource is an empty string, make it NULL
	** pointer (without this, it would be hard to make achieve this
	** using editres--well, it's still tricky: first you have to set
	** the string to "", then length to 0 and only after that request
	** loading of content --msa)
	*/
	if (s_new->basic.content_string &&
	    s_new->basic.content_length == 0)
	    {
		s_new->basic.content_length =
			strlen(s_new->basic.content_string);
		if (s_new->basic.content_length == 0)
			s_new->basic.content_string = NULL;
	    }
	/*
	** Maintain private copies of content_file and content_filter
	*/
	if (s_old->basic.content_file != s_new->basic.content_file)
	    {
		s_new->basic.content_file =
			XtNewString(s_new->basic.content_file);
		XtFree(s_old->basic.content_file);
	    }
	if (s_old->basic.content_filter != s_new->basic.content_filter)
	    {
		s_new->basic.content_filter =
			XtNewString(s_new->basic.content_filter);
		XtFree(s_old->basic.content_filter);
	    }
	if (new_cursor && XtIsRealized(new))
		XDefineCursor(XtDisplay(new), XtWindow(new),
			      s_new->basic.cursor);
	return
		s_old->basic.foreground_pixel!=s_new->basic.foreground_pixel ||
		s_old->basic.x_translation != s_new->basic.x_translation ||
		s_old->basic.y_translation != s_new->basic.y_translation;
    }

/*
** Widget needs to have own Realize function so that different
** visuals can be specified for it.
*/
static void Realize(widget, value_mask, attributes)
Widget widget;
XtValueMask *value_mask;
XSetWindowAttributes *attributes;
    {
	XeBasicWidget w = (XeBasicWidget)widget;
	Visual *visual;

	if (w->basic.visual == NULL)
		visual = (Visual *)CopyFromParent;
	else
	    {
		visual = w->basic.visual;
		if (visual != DefaultVisualOfScreen(XtScreen(w)))
		    {
			w->core.colormap = w->basic.cmap =
				XCreateColormap
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 visual, AllocNone);
			attributes->colormap = w->core.colormap;
			*value_mask |= CWColormap;
		    }
	    }
	if (w->basic.cursor)
	    {
		attributes->cursor = w->basic.cursor;
		*value_mask |= CWCursor;
	    }
	XtCreateWindow(widget, (unsigned int) InputOutput,
		       visual, *value_mask, attributes);
    }


static void Destroy(w)
Widget w;
    {
	register XeBasicWidget rw = (XeBasicWidget)w;

	XtFree(rw->basic.content_file);
	XtFree(rw->basic.content_filter);
    }

/*
** Widget needs to follow cursor to change the colourmaps if private
** colourmaps are installed.
*/
static void EnterWindow(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {

	XeBasicWidget r = (XeBasicWidget)w;
	Widget wlst[2];
	
	if (!XtParent(r) || r->core.colormap == XtParent(r)->core.colormap)
		return;	/* No private colormap, or same as parent */
	if (r->basic.colormap_install)
	    {
		XInstallColormap(XtDisplay(w), r->core.colormap);
		return;
	    }
	while (!XtIsShell(w))
		w = XtParent(w);
	wlst[0] = (Widget)r;
	wlst[1] = w;
	XtSetWMColormapWindows(w, wlst, (Cardinal)2);
    }

static void LeaveWindow(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeBasicWidget r = (XeBasicWidget)w;

	if (!XtParent(r) || r->core.colormap == XtParent(r)->core.colormap)
		return; /* No private colormap, or same as parent */
	if (r->basic.colormap_install)
	    {
		XUninstallColormap(XtDisplay(w), r->core.colormap);
		return;
	    }
	while (!XtIsShell(w))
		w = XtParent(w);
	XtSetWMColormapWindows(w, &w, (Cardinal)1);
    }

static void Notify(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
    {
	XeNotifyCallbackData call_data;
	call_data.reason = XeCR_NOTIFY;
	call_data.event = event;
	call_data.params = params;
	call_data.num_params = *num_params;
	XtCallCallbackList(w, ((XeBasicWidget)w)->basic.notify_callbacks,
			   (XtPointer)&call_data);
    }

static void Activate(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
    {
	XeActivateCallbackData call_data;
	call_data.reason = XeCR_ACTIVATE;
	call_data.event = event;
	call_data.params = params;
	call_data.num_params = *num_params;
	XtCallCallbackList(w, ((XeBasicWidget)w)->basic.activate_callbacks,
			   (XtPointer)&call_data);
    }


/*
**	Support Functions for the Asynchronous Data Flows
**	*************************************************
*/

/*
** DoneAndDeleteFlow
**	Call widget defined done if still uncalled, and then release all
**	resources associated with the flow. Note, that this will be
**	also called implicitly from DoneAndCloseFile.
*/
static void DoneAndDeleteFlow(df)
XeDataFlow *df;
    {
	if (df->save != NULL)
		(*df->save)(df);
	if (df->id != None)
		XtRemoveInput(df->id);
	if (df->buffer != NULL)
		XtFree((char *)df->buffer);
	XtFree((char *)df);
    }
/*
** DoneAndCloseFile
**	Sometimes Basic has to open the file for the flow. This function
**	takes care of calling the users 'done' function (saved in 'save')
**	and then closes the file.
*/
static void DoneAndCloseFile(df)
XeDataFlow *df;
    {
	if (df->save != NULL)
	    {
		(*df->save)(df);
		df->save = NULL;
	    }
	if (df->fd >= 0)
	    {
		close(df->fd);
		df->fd = -1;
	    }
	DoneAndDeleteFlow(df);
    }

/*
** DoneAndCloseFilter
**	Sometimes Basic has to open the filter (pipe) for the flow. This
**	function takes care of calling the users 'done' function (saved
**	in 'save') and then closes the pipe.
*/
static void DoneAndCloseFilter(df)
XeDataFlow *df;
    {
	if (df->save != NULL)
	    {
		(*df->save)(df);
		df->save = NULL;
	    }
	if (df->fl)
	    {
		pclose(df->fl);
		df->fl = NULL;
	    }
		
	df->fd = -1;
	DoneAndDeleteFlow(df);
    }

/*
** MoreToFile
**	General function which is called when the output stream
**	is ready for more output (XtInputCallbackProc).
*/
static void MoreToFile(d, fid, id)
XtPointer d;
int *fid;
XtInputId *id;
    {
	XeDataFlow *df = (XeDataFlow *)d;

	XtRemoveInput(*id);
	if (*id != df->id)
		XtWarning("Basic.c/MoreToFile: XtInputId mismatch");
	df->id = None;
	if ((*df->more)(df) < 0)
		(*df->done)(df);
    }
/*
** FromFileToFlow
**	General function to feed octet stream from a file into
**	data flow (XtInputCallbackProc).
**
**	NOTE: This function is *never* called when the flow has
**	      buffered data (df->length > 0).
*/
static void FromFileToFlow(d, fid, id)
XtPointer d;
int *fid;
XtInputId *id;
    {
	XeDataFlow *df = (XeDataFlow *)d;
	char buf[10000];
	int nbytes, obytes;

	if (*id != df->id)
		XtWarning("Basic.c/FromFileToFlow: XtInputId mismatch");
	if ((nbytes = read(*fid, buf, sizeof(buf))) > 0)
	    {
		/*
		** Received at least one byte, feed to the flow.
		*/
		obytes = (*df->feed)(df, buf, nbytes);
		if (obytes == nbytes)
			return;
		XtRemoveInput(*id);
		df->id = None;
		if (obytes < 0)
			(*df->done)(df);
		else
		    {
			df->length = nbytes - obytes;
			df->buffer = (char *)XtMalloc(df->length);
			memcpy(df->buffer, buf + obytes, df->length);
		    }
	    }
	else
	    {
		/*
		** Assume that everything else is EOF
		*/
		XtRemoveInput(*id);
		df->id = None;
		(*df->done)(df);
	    }
    }

/*
** MoreFromStream
**	Is called when input proc should be activated again. It is safe
**	to call multiple times, does nothing if Input is already active.
*/
static int MoreFromStream(df)
XeDataFlow *df;
    {
	if (df->length > 0)
	    {
		int obytes;

		obytes = (*df->feed)(df, df->buffer, df->length);
		if (obytes >= df->length || obytes < 0)
		    {
			XtFree((char *)df->buffer);
			df->buffer = NULL;
			df->length = 0;
			if (obytes < 0)
				return -1;
		    }
		else if (obytes > 0)
		    {
			df->length -= obytes;
#if HAVE_MEMMOVE
			memmove(df->buffer, df->buffer + obytes, df->length);
#else
			/* No memmove, take a risk with memcpy.. */
			memcpy(df->buffer, df->buffer + obytes, df->length);
#endif
			return 1;
		    }
		else
			return 1; /* Keep all data in buffer */
	    }
	if (df->fd < 0)
		return -1; /* No input file to read more */
	/*
	** Note: Here we assume 'None' is of valid type for XtInputId and
	** something that never can be a valid XtInputId and use it as a
	** flag to indicate whether input is primed or not..
	*/
	if (df->id == None)
	    {
		df->id = XtAppAddInput
			(XtWidgetToApplicationContext((Widget)df->w),
			 df->fd, (XtPointer)XtInputReadMask,
			 FromFileToFlow, (XtPointer)df);
	    }
	return 1;
    }


/*
** MoreFromString
**	Is called when input proc should be activated again. This function
**	reads from content_string resource.
*/
static int MoreFromString(df)
XeDataFlow *df;
    {
	if (df->length > 0)
	    {
		int obytes;
		XeBasicWidget w = df->w;
		char *buf;
		buf = (char *)w->basic.content_string + w->basic.content_length
			- df->length;
		obytes = (*df->feed)(df, buf, df->length);
		if (obytes >= df->length || obytes < 0)
		    {
			df->length = 0;
			return -1;
		    }
		df->length -= obytes;
		return 1;
	    }
	return -1;
    }
/*
** ReadFromFlow
**	will actively read (pull) data from the flow, and may block in
**	the process of doing so (unless prevented). Data is read much
**	in similar way as defined for 'fread' function: function returns
**	only full units of specified size [ This function has been
**	created according to the needs of MPEG decoder, but hopefully it
**	will be useful for others someday... ]
**
**	Returns the actual number of full units read, ZERO indicates EOF.
**	Negative return value indicates no data available (this is possible
**	only if the stream was set into non-blocking mode). Other read
**	errors are treated as EOF.
*/
static int ReadFromFlow(df, buf, unit, number)
XeDataFlow *df;	/* input data flow */
char *buf;	/* destination buffer start address */
int unit;	/* size of unit to read */
int number;	/* max number of units to read */
    {
	int obytes;

	obytes = df->length;
	if (obytes > 0)
	    {
		/*
		** Some data is already available in some memory buffer
		*/
		if (obytes > unit * number)
			obytes = unit * number;
		if (df->buffer == NULL)
		    {
			/*
			** contentString used
			*/
			XeBasicWidget w = df->w;
			if (!w || w->basic.content_string == NULL)
				return 0;
			memcpy(buf, w->basic.content_string
			       + w->basic.content_length - df->length,
			       obytes);
			df->length -= obytes;
			/*
			** If the contentString is not an even multiple of
			** the unit bytes, the remainder bytes are copied
			** into the buffer, but the returned count does not
			** include them.
			*/
			return obytes / unit; /* All Done at this point */
		    }
		/*
		** contentStream, contentFilter or contentFile
		** buffered input
		*/
		memcpy(buf, df->buffer, obytes);
		df->length -= obytes;
		if (df->length > 0)
			memcpy(df->buffer, df->buffer + obytes, df->length);
		else
		    {
			XtFree((char *)df->buffer);
			df->buffer = NULL;
		    }
	    }
	if (df->fd < 0)
		return obytes / unit;
	if (obytes < unit)
	    {
		int chunk = read(df->fd, buf + obytes, unit * number - obytes);

		if (chunk == 0)
			return 0;	/* EOF */
		else if (chunk < 0)
		    {
			if (errno != EAGAIN)
				return 0; /* EOF */
		    }
		else
			obytes += chunk;
	    }
	/*
	** Have to return integral number of unit's. If obytes is not even
	** units, must buffer the remainder for future.
	*/
	number = obytes / unit;
	obytes -= number * unit;
	if (obytes > 0)
	    {
		df->length = obytes;
		/* Should probably consider keeping the buffer allocated..
		   it may now get realloced on every read.. --msa */
		df->buffer = (char *)XtMalloc(obytes);
		memcpy(df->buffer, buf + (number * unit), obytes);
	    }
	/* If number == 0, then it was non-blocking stream with no data yet */
	return number ? number : -1;
    }

/*
** XeStartInputFlow
**	Initialize reading of the widget content asynchronously using
**	XeDataFlow mechanism. This will hide the actual source of the
**	content stream from the widget implementation. (If content is
**	given with memory pointer, no asynchronous operations really
**	occur, the whole content is just given in single 'feed' call;
**	the mechanism hides file and network access).
**
**	Returns NULL if failure.
*/
XeDataFlow *XeStartInputFlow(w, feed, done)
XeBasicWidget w;
XeDataFlowFeed feed;
XeDataFlowDone done;
    {
	XeDataFlow *df;

	df = (XeDataFlow *)XtMalloc(sizeof(XeDataFlow));
	df->w = w;
	df->feed = feed;
	df->save = done;
	df->done = DoneAndDeleteFlow;
	df->read = ReadFromFlow;
	df->id = None;
	df->buffer = NULL;
	df->length = 0;
	df->fd = -1;
	df->fl = NULL;
	if (w->basic.content_string != NULL)
	    {
		df->length = w->basic.content_length;
		df->more = MoreFromString;
		return df;
	    }
	else if (w->basic.content_stream != NULL)
	    {
		df->fl = w->basic.content_stream;
		df->fd = fileno(df->fl);
		df->more = MoreFromStream;
		return df;
	    }
	else if (w->basic.content_file != NULL)
	    {
		df->fd = open(w->basic.content_file, O_RDONLY);
		if (df->fd >= 0)
		    {
			df->more = MoreFromStream;
			df->done = DoneAndCloseFile;
			return df;
		    }
		XeWidgetWarningMsg
			((Widget)w, "cannotOpenFile",  "Cannot open file '%s'",
			 &w->basic.content_file, 1);
	    }
	else if (w->basic.content_filter != NULL)
	    {
		df->fl = popen(w->basic.content_filter, "r");
		if (df->fl)
		    {
			df->fd = fileno(df->fl);
			df->more = MoreFromStream;
			df->done = DoneAndCloseFilter;
			return df;
		    }
		XeWidgetWarningMsg
			((Widget)w, "cannotOpenFilter",
			 "Cannot open filter '%s'",&w->basic.content_filter,1);
	    }
	XtFree((char *)df);
	return NULL;
    }

/*
** FeedFromFlowToFile
**	This is called when there are some output bytes to be
**	written to the output device.
*/
static int FeedFromFlowToFile(df, data, length)
XeDataFlow *df;
char *data;
int length;
    {
	int obytes;

	if (df->fd < 0)
		return -1; /* There is no file to write!!! */
	obytes = write(df->fd, data ? data : "\0", length);
	if (obytes == length && data != NULL)
		return obytes;
	else if (obytes < 0)
	    {
		if (errno != EWOULDBLOCK && errno != EAGAIN)
			return -1;
		obytes = 0; /* Indicate nothing written */
	    }
	/*
	** Note: Here we assume 'None' is of valid type for XtInputId and
	** something that never can be a valid XtInputId and use it as a
	** flag to indicate whether output is primed or not..
	*/
	if (df->id == None)
	    {
		df->id = XtAppAddInput
			(XtWidgetToApplicationContext((Widget)df->w),
			 df->fd, (XtPointer)XtInputWriteMask,
			 MoreToFile, (XtPointer)df);
	    }
	return obytes;
    }

/*
** XeFileOutFlow
**	Initialize asynchronous writing to a file using XeDataFlow
**	mechanism.
**
**	Returns NULL if failure.
*/
XeDataFlow *XeFileOutFlow(w, more, done, fd)
XeBasicWidget w;
XeDataFlowMore more;
XeDataFlowDone done;
int fd;
    {
	XeDataFlow *df;
	int result;

	if (fd < 0)
		return NULL;
	/*
	** (Try to) Set the file into non-blocking mode
	*/
	if (((result = fcntl(fd, F_GETFL, 0)) == -1) ||
	    fcntl(fd, F_SETFL, result | O_NDELAY) == -1)
		XeWidgetWarningMsg((Widget)w,
				   "cannotSetNonBlocking",
				   "Cannot set non-blocking on file.",
				   (char **)NULL, 0);
	/*
	*/
	df = (XeDataFlow *)XtMalloc(sizeof(XeDataFlow));
	df->w = w;
	df->feed = FeedFromFlowToFile;
	df->more = more;
	df->done = DoneAndDeleteFlow;
	df->save = done;
	df->fd = fd;
	df->id = None;
	df->buffer = NULL;
	df->length = 0;
	return df;
    }

/*
** BLOCKING CONTENT LOAD SUPPORT
** *****************************
** Some widgets need the content as single unit (are not prepared to
** use the asynchronous method). _XeOpenContent, _XeCloseContent,
** _XeGetContent and _XeGetContentCopy are provided for those.
*/


/*
** _XeOpenContent
**	open the content for input.
**
**	There is no special error return. If the content cannot be opened
**	the type will be set, but the corresponding source value (either
**	source.string or source.stream) will be NULL.
*/
void _XeOpenContent(w, content)
XeBasicWidget w;
XeDataContent *content;
    {
	content->length = w->basic.content_length;
	if (w->basic.content_string != NULL)
	    {
		content->type = XeDataContentType_STRING;
		content->source.string =
			w->basic.content_string + w->basic.content_offset;
		return;
	    }
	/*
	** Handle the stream variants
	*/
	if (w->basic.content_stream != NULL)
	    {
		content->type = XeDataContentType_STREAM;
		content->source.stream = w->basic.content_stream;
	    }
	else if (w->basic.content_file != NULL)
	    {
		content->type = XeDataContentType_FILE;
		content->source.stream = fopen(w->basic.content_file, "rb");
		if (content->source.stream == NULL)
			XeWidgetWarningMsg((Widget)w, "cannotOpenFile",
					   "Cannot open file '%s'",
					   &w->basic.content_file, 1);
	    }
	else if (w->basic.content_filter != NULL)
	    {
		content->type = XeDataContentType_FILTER;
		content->source.stream = popen(w->basic.content_filter, "r");
		if (content->source.stream == NULL)
			XeWidgetWarningMsg((Widget)w, "cannotOpenFilter",
					   "Cannot open filter '%s'",
					   &w->basic.content_filter, 1);
	    }
	else
	    {
		content->type = XeDataContentType_STRING;
		content->source.string = NULL;
		content->length = 0;
		return;
	    }
	/*
	** process the contentOffset resource for streams.
	** (this implementation assumes one can do arithmetic with the
	** return value of ftell and apply it to fseek!!!)
	*/
	if (w->basic.content_offset != 0)
	    {
		long cnt = w->basic.content_offset;
		long pos = ftell(content->source.stream);

		if (pos < 0)
			pos = 0;
		if (fseek(content->source.stream, cnt, 1) < 0)
		    {
			/*
			** fseek failed for some reason, try skip by reading
			** (cannot do anything if offset was negative).
			*/
			char buf[1000];
			int bytes;
			
			fseek(content->source.stream, pos, 0); /* Just reset */
			for ( ;cnt > 0; cnt -= bytes)
			    {
				bytes = cnt > sizeof(buf) ? sizeof(buf) : cnt;
				bytes = fread(buf, 1, bytes,
					      content->source.stream);
				if (bytes <= 0)
					break;
			    }
		    }
	    }
    }

/*
** _XeCloseContent
**	close the content structure openend by _XeOpenContent.
*/
void _XeCloseContent(content)
XeDataContent *content;
    {
	switch (content->type)
	    {
	    case XeDataContentType_FILE:
		if (content->source.stream)
			fclose(content->source.stream);
		break;
	    case XeDataContentType_FILTER:
		if (content->source.stream)
			pclose(content->source.stream);
		break;
	    default:
		break;
	    }
	/*
	** (reset to empty content)
	*/
	content->type = XeDataContentType_STRING;
	content->length = 0;
	content->source.string = NULL;
    }

/*
** LoadFromStream
**	load content from a stream into memory. Apply basic resource
**	contentLength (assume the contentOffset is already dealt with).
**
**	contentLength	defines the number of bytes to be included into
**			the content starting from the beginning of actual
**			content (after contentOffset is applied). If
**			contentLength <= 0, then it is assumed to mean
**			all bytes until end of stream.
*/
#define CHUNK_SIZE 2000

#if NeedFunctionPrototypes
static char *LoadFromStream(XeBasicWidget, FILE *, int *);
#endif
static char *LoadFromStream(w, f, l)
XeBasicWidget w;
FILE *f;
int *l;
    {
	char *data;
	long cnt, pos;
	int bytes, size;
	
	*l = 0;
	/*
	** process the contentLength > 0 case
	*/
	if ((cnt = w->basic.content_length) > 0)
	    {
		data = (char *)XtMalloc((Cardinal)cnt);
		bytes = fread(data, 1, cnt, f);
		if (bytes > 0)
		    {
			*l = bytes;
			return data;
		    }
		XtFree(data);
		return NULL;
	    }
	pos = ftell(f);
	if (pos < 0)
		pos = 0;
	/*
	** contentLength == 0 (means bytes from current position to EOF)
	*/
	if (fseek(f, 0L, 2) != -1)
	    {
		/*
		** fseek to EOF was successful. Doing arithmetic with return
		** values of 'ftell' is not really portable, but should work
		** on most of unixes.. --msa
		*/
		cnt = ftell(f) - pos;
		if (cnt <= 0)
			return NULL; /* No content! */
		fseek(f, pos, 0);
		data = (char *)XtMalloc((Cardinal)cnt);
		if ((*l = fread(data, 1, cnt, f)) > 0)
			return data;
		*l = 0;
		XtFree(data);
		return NULL;
	    }
	/*
	** fseek failed, the file is non-seekable (pipe, tty etc.).
	** Do repeated reads and buffer resizes until EOF is reached.
	*/
	size = CHUNK_SIZE;	/* Current Buffer size */
	data = (char *)XtMalloc(size);
	fseek(f, pos, 0);	/* Just make sure we restart (if possible) */
	*l = 0;
	while ((bytes = fread(data + *l, 1, size - *l, f)) > 0)
	    {
		*l += bytes;
		if (size - *l < CHUNK_SIZE)
		    {
			size += CHUNK_SIZE;
			data = (char *)XtRealloc(data, size);
		    }
	    }
	return data;
    }

/*
** _XeGetContent
**	returns *all* of the current content bytes in a memory array.
**	If the input is pipe/network stream, this request will *block*
**	until EOF is reached.
**
**	length	will return the number of bytes in the content
**
**	use_free will be non-zero, if the returned pointer should be
**		freed with XtFree (if zero, the returned string must
**		not be modified).
*/
char *_XeGetContent(w, length, use_free)
XeBasicWidget w;
int *length, *use_free;
    {
	char *data;
	XeDataContent content;

	_XeOpenContent(w, &content);
	if (content.type == XeDataContentType_STRING)
	    {
		*length = content.length;
		*use_free = False;
		data = content.source.string;
	    }
	else if (content.source.stream)
	    {
		*use_free = True;
		*length = 0;
		data = LoadFromStream(w, content.source.stream, length);
	    }
	else
	    {
		*use_free = False;
		*length = 0;
		data = NULL;
	    }
	_XeCloseContent(&content);
	return data;
    }

/*
** _XeGetContentCopy
**	returns *all* of the current content bytes in a memory array.
**	(Same as _XeGetContent, but the return array is *always* a
**	copy and must be released with XtFree).
*/
char *_XeGetContentCopy(w, length)
XeBasicWidget w;
int *length;
    {
	int is_copy;
	char *data;
	
	data = _XeGetContent(w, length, &is_copy);
	if (data && !is_copy)
	    {
		unsigned char *tmp = (unsigned char *)data;

		data = (char *)XtMalloc(*length);
		memcpy((void *)data, (void *)tmp, *length);
	    }
	return data;
    }


#ifdef USING_MOTIF_122
/************************************************************************
 *
 *  WidgetNavigable - routine to handle traversal to children of this
 *  widget, if there are any, or else the widget itself, if no children. 
 *
 ************************************************************************/
static XmNavigability
WidgetNavigable( wid)
        Widget wid ;
{   
    if(wid->core.sensitive
       &&  wid->core.ancestor_sensitive
       &&  ((XmManagerWidget) wid)->manager.traversal_on) {
        XmNavigationType nav_type = ((XmManagerWidget) wid)
            ->manager.navigation_type ;
        Widget *children = ((XmManagerWidget) wid)->composite.children ;
        unsigned idx = 0 ;

        while( idx < ((XmManagerWidget) wid)->composite.num_children) {
            if(_XmGetNavigability( children[idx])) {
                if( (nav_type == XmSTICKY_TAB_GROUP)
                    ||  (nav_type == XmEXCLUSIVE_TAB_GROUP)
                    ||  (    (nav_type == XmTAB_GROUP)
                             &&  !_XmShellIsExclusive( wid))) {
                    return XmDESCENDANTS_TAB_NAVIGABLE ;
                }
                return XmDESCENDANTS_NAVIGABLE ;
            }
            ++idx ;
        }
            
        if((nav_type == XmSTICKY_TAB_GROUP)
           ||  (nav_type == XmEXCLUSIVE_TAB_GROUP)
           ||  ((nav_type == XmTAB_GROUP)
                &&  !_XmShellIsExclusive( wid))) {
            return XmTAB_NAVIGABLE ;
        }
        return XmCONTROL_NAVIGABLE ;
    }
    return XmNOT_NAVIGABLE ;
}

#endif
