/*-
|> File
|| tcpip.c
||
|> Description
||
|> Comments
||
|> History
|| 950jj _mf Created.
||
||==================================================================|>
*/
#ifndef _NOIDENT
#ident "$Id: tcpip.c,v 2.0 1995/06/05 16:52:14 reynolds Exp mreynold $"
#endif

#include <memory.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "tcpip.h"

/* because solaris insists that the hostname is a BSD thing */
int                     gethostname (char *name, int namelen);

/*-=================================================================|>
||
|> Public functions
||
||==================================================================|>
||
*/

/* create a socket for accepting connections on and listen on it.  If the
   portNo is 0, then create a socket using INADDR_ANY for the port number */

int
createAcceptSocket (const int portNo)

{
  int                     connSock,
                          length;
  struct sockaddr_in      sockAddr;
  int                     optionArg = 1;

/* create a socket file desciptor */

  if ((connSock = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
    perror ("socket call failed");
    return (-1);
  }
  if (setsockopt (connSock, SOL_SOCKET, SO_REUSEADDR, (char *) &optionArg,
                  sizeof (optionArg)) < 0) {
    perror ("setsockopt failed");
    return (-1);
  }

/* create the structure to bind it to for a well-known address */

  memset ((char *) &sockAddr, 0, sizeof (sockAddr));
  sockAddr.sin_family = AF_INET;
  sockAddr.sin_addr.s_addr = INADDR_ANY;

/* if the requested port number is 0, then we generate a port number */

  sockAddr.sin_port = (portNo) ? htons (portNo) : INADDR_ANY;

/* bind the socket to its address */

  if (bind (connSock, (struct sockaddr *) &sockAddr, sizeof (sockAddr)) < 0) {
    perror ("bind failed\n");
    return (-1);
  }

/* make sure the name was bound properly and listen on it for connections */

  length = sizeof (sockAddr);
  if (getsockname (connSock, (struct sockaddr *) &sockAddr, &length) < 0) {
    perror ("bad address for socket");
    return (-1);
  }
  if (listen (connSock, BACKLOG) < 0) {
    perror ("listen failed");
    return (-1);
  }
  return (connSock);
}

/* accept a connection from a socket */

int
acceptConnection (const int acceptFd)

{
  struct sockaddr         addr;
  int                     addrlen = sizeof (struct sockaddr);

  return (accept (acceptFd, &addr, &addrlen));
}

/* get the port number of the socket */

int
getPortNo (const int socketId)

{
  struct sockaddr_in      sockAddr;
  int                     length = sizeof (sockAddr);

  if (getsockname (socketId, (struct sockaddr *) &sockAddr, &length) < 0) {
    perror ("getsockname failed");
    return (-1);
  }
  return ((int) sockAddr.sin_port);
}

/* create a socket and use it to connect to another host */

int
createConnectSocket ( const int port,
                      const char *const hostname)

{
  struct sockaddr_in      sockAddr;
  struct hostent         *hp;
  int                     connSock;

/* set up the socket for making connections on */

  connSock = socket (AF_INET, SOCK_STREAM, 0);
  memset ((char *) &sockAddr, 0, sizeof (sockAddr));
  sockAddr.sin_family = AF_INET;
  hp = gethostbyname (hostname);
  memcpy ((void *) &sockAddr.sin_addr, (void *) hp->h_addr, hp->h_length);
  sockAddr.sin_port = htons (port);

/* connect and bind the socket to its address */

  if (connect (connSock, (struct sockaddr *) &sockAddr, 
	       sizeof (sockAddr)) < 0) {
    perror ("connect failed");
    return (-1);
  }
  return (connSock);
}

/*- end tcpip.c
*/
