/*-
|> File
|| pserver.c
||
|> Description
||
|> Comments
||
|> History
|| 95045 _mf Created.
|| Oct/Nov 1995 modified by msa
||
||==================================================================|>
*/
#ifndef _NOIDENT
#ident "$Id: pserver.c,v 2.0 1995/06/05 16:52:14 reynolds Exp $"
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#define _POSIX_C_SOURCE 5       /* because signal.h is stupid */
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#if 0
#include <sys/select.h>
#endif
#define NEED_REPLIES            /* because Xproto.h is stupid */
#include <X11/Xproto.h>
#include <X11/Xlib.h>

#include "tcpip.h"
#include "printer.h"

#define _DECLARE_GLOBAL
#include "global.h"
#include "afm.h"

#define SERVBASE    6000
#define MAXREQSZ    262140
#define RESOURCE_ID_MASK  0x3FFFFF
#define CLIENTOFFSET    22
#define VENBYTES    16
#define STATICMAXFD   32

/* prototypes that aren't properly defined on suns. */

int getopt( int argc, char * const *argv, const char *optstring);
char *strdup( const char *);

Display                *THE_DISPLAY;
struct PrintClient      PCS[STATICMAXFD];
char                  **fontlist;
extern char            *optarg;

typedef union xmsg
{
  xReq                    req;
  unsigned char           buf[MAXREQSZ];
}
xmsgU;

typedef union xreply
{
  xGenericReply           reply;
  unsigned char           buf[MAXREQSZ];
}
xreplyU;

int                     debug = 1;

printOptionsRec         PRINT_OPTIONS;

/*-=================================================================|>
||
|> Callbacks
||
||==================================================================|>
||
*/

/*-=================================================================|>
||
|> Local functions
||
||==================================================================|>
||
*/

/* remove the cmap structures associate with a client */

static void
removecmaps (
              const int fd,
              const cmapinfoTablePtr table)

{
  int                     ii = 0,
                          jj = 0;

  for (; ii < table->numCmap; ii++)
    if (table->cmapTable[ii].fd != fd)
      table->cmapTable[jj++] = table->cmapTable[ii];

  table->numCmap = jj;
}

/* remove the GC structures associate with a client */

/* note also similar function deleteGc in handlreq.c! merge? -- msa */

static void
removegcs (const int fd, const gcinfoTablePtr table)
    {
	int ii = 0, jj = 0;

	for (; ii < table->numGc; ii++)
		if (table->gcTable[ii].fd != fd)
			table->gcTable[jj++] = table->gcTable[ii];
		else
		    {
			if (table->gcTable[ii].clipRects)
				free((char *)table->gcTable[ii].clipRects);
			if (table->gcTable[ii].dashes)
				free((char *)table->gcTable[ii].dashes);
		    }
	table->numGc = jj;
    }

/* remove the window structures associated with a client */

static void
removewins (
             const int fd,
             const winfoTablePtr table)

{
  int                     ii = 0,
                          jj = 0;

  for (; ii < table->numWin; ii++)
    if (table->winTable[ii].fd != fd)
      table->winTable[jj++] = table->winTable[ii];

  table->numWin = jj;
}


static void
removefonts (
            const int fd,
            const fontTablePtr table)

{
  int ii, jj;

  for (ii = jj = 0; ii < table->numFonts; ii++)
	  if (table->fontTable[ii].fd == fd)
		  FreeFont(table->fontTable[ii].font_data);
	  else
		  table->fontTable[jj++] = table->fontTable[ii];
  table->numFonts = jj;
}

/* clean up the structures associated with a client */

static void
removeClient (const int fd)
{
  removewins (fd, winfoTable);
  removegcs (fd, gcinfoTable);
  removecmaps (fd, cmapinfoTable);
  removefonts (fd, fontTable);
}

/*-=================================================================|>
||
|> Public functions
||
||==================================================================|>
||
*/

/*-
|> Function
||
||
|> Description
||
||
|> Comments
||
||
||==================================================================|>
*/
int
main (
       int argc,
       char *argv[],
       char *envT[])

{
  int                     port,
                          true_color = 0,
                          acceptFd,
                          clientFd,
                          replyLen,
                          highestFd,
                          clientFlag,
                          i,
                          c;
  xmsgU                   message;
  xreplyU                 reply;
  fd_set                  readfds,
                          writefds,
                          exceptfds,
                          readmask;
  char                   *dispName;
  FILE                   *fp;
  struct sigaction        act,
                          oact;

/* options:
   -p <port #>      port # for server 
   -d <display-name>    name of real display to connect to 
   -g  debug flag on/off
   -t  TRUE color for default

   set the defaults:
 */
  memset((char *)&reply, 0, sizeof(reply)); /* ..silence some purify UMR's */
  debug = FALSE;
  port = SERVBASE + 1;
  dispName = getenv ("DISPLAY");
  if (dispName == NULL)
  {
    dispName = "unix:0.0";
  }

/* parse the arguments */

  while ((c = getopt (argc, argv, "gtp:d:")) != EOF)
  {
    switch (c)
    {
    case 'g':
      debug = TRUE;
      break;
    case 'p':
      port = atoi (optarg) + SERVBASE;
      break;
    case 'd':
      dispName = strdup (optarg);
      break;
    case 't':
      true_color = TRUE;
      break;
    default:
      fprintf (stderr,
               "Usage %s [-p port#][-d display][ -g]\n", argv[0]);
      exit (-1);
      break;
    }
  }

/* try to open the display to the real server */

  THE_DISPLAY = XOpenDisplay (dispName);
  if (THE_DISPLAY == NULL)
  {
    fprintf (stderr, "failed to open display %s\n", dispName);
    exit (-1);
  }

  /* initialize the tables for colormaps, GC's, windows, etc. */
      
  initTables(true_color);
  
/* read in the default font directory */

  LoadFonts((char **)NULL);
  
/* set the defaults, and read the options file if there is one */

  PRINT_OPTIONS.indexCspaceSupport = TRUE;
  if (getenv ("XPRINTOPTS") == NULL)
  {
    if (debug)
      printf ("no options file set, using default values\n");
  }
  else
  {
    fp = fopen (getenv ("XPRINTOPTS"), "r");
    if (fp == NULL)
    {
      fprintf (stderr, "failed to open file %s, using defaults\n",
               getenv ("XPRINTOPTS"));
    }
    else
    {

/* read options here. Add more for extensions */

      fscanf (fp, "%d", &PRINT_OPTIONS.indexCspaceSupport);
      fclose (fp);
    }
  }

/* block out SIGPIPE for when clients die */

  sigemptyset(&act.sa_mask);
  sigaddset(&act.sa_mask, SIGPIPE);
  act.sa_flags = 0;
  act.sa_handler = SIG_IGN;
  sigaction (SIGPIPE, &act, &oact);

/* create the accept socket and the file descriptors for the select call */

  if ((acceptFd = createAcceptSocket (port)) < 0)
  {
    perror ("create_accept_socket failed");
    exit (-1);
  }
  highestFd = acceptFd;
  FD_ZERO (&readfds);
  FD_ZERO (&writefds);
  FD_ZERO (&exceptfds);
  FD_ZERO (&readmask);
  FD_SET (acceptFd, &readfds);

/* initialize the client data structures */

  initPrintClients (PCS, STATICMAXFD);
  do
  {

/* copy to the select mask */

    for (i = 0; i <= highestFd; i++)
    {
      if (FD_ISSET (i, &readfds))
      {
        FD_SET (i, &readmask);
      }
    }
    if (select (highestFd + 1, &readmask, &writefds,
                &exceptfds, NULL) < 0)
    {

/* some client disconnected */

      if (errno == EBADF)
      {
        if (debug)
          printf ("client closed connection\n");
        for (clientFd = 0; clientFd <= highestFd; clientFd++)
        {
          if (clientFd == acceptFd)
          {
            continue;
          }
          if (FD_ISSET (clientFd, &readmask))
          {
            FD_CLR (clientFd, &readfds);
          }
        }
      }

/* if there's an input on the accept socket, accept the connection */

    }
    else if (FD_ISSET (acceptFd, &readmask))
    {
      clientFd = acceptConnection (acceptFd);
      if (debug)
        printf ("accepting connection\n");

/* do the "init" conversation right away, since it's a little different 
   than the rest */

      if (initConnection (clientFd, true_color))
      {
        FD_SET (clientFd, &readmask);

/* once the client has connected, we initialize the fields in the PrintClient
   structure for that file descriptor */

	initClient( &PCS[ clientFd]);
        if (clientFd > highestFd)
        {
          highestFd = clientFd;
        }
      }

/* otherwise, it's just input from the client, and a response */

    }
    else
    {
      for (clientFd = 0; clientFd <= highestFd; clientFd++)
      {
        if (clientFd == acceptFd)
        {
          continue;
        }
        if (FD_ISSET (clientFd, &readmask))
        {
          clientFlag = True;

/* read the request, find out how big it is, and read the rest of it, 
   then send the reply if there is one */

          if (readLoop (clientFd, (char *) &message.req,
                        sizeof (message.req)) <= 0)
          {
            if (debug)
              printf ("client %d disconnected\n", clientFd);
            clientFlag = False;
          }
          if (message.req.length > 1)
          {
            if (readLoop (clientFd,
                          (char *) message.buf + sizeof (xReq),
                          (message.req.length << 2) -
                          sizeof (xReq)) <= 0)
            {
              if (debug)
                printf ("client %d disconnected\n", clientFd);
              clientFlag = False;
            }
          }
          if (debug)
            printf ("reading request %d words\n", message.req.length);
          DecodeRequest (clientFd, message.buf, reply.buf,
                         &replyLen);
          if (replyLen > 0)
          {

/* if the reply length is less than the length of a generic reply, then 
   pump up the volume */

            if (replyLen < sizeof (xGenericReply))
            {
              replyLen = sizeof (xGenericReply);
            }

            if (debug)
              printf ("sending reply %d words\n", replyLen >> 2);

/* if the reply write failed, then the client disconnected */

            if (write (clientFd, reply.buf, replyLen) < 0)
            {
              if (debug)
                printf ("client %d disconnected\n", clientFd);
              clientFlag = False;
            }
          }

/* if anything failed, the close out the client, and remove the 
   associated structures */

          if (!clientFlag)
          {
            close (clientFd);
            removeClient (clientFd);

	    /* .. more needs to be done, if link drops without
	       X_ClosePrint request, but for now I have no time
	       to fix this... (at least printfile should be closed?)
	       -- msa */

            FD_CLR (clientFd, &readmask);
          }
        }
      }
    }
  }
  while (True);
}

/* initialize the connection with the client. Some of these are wild guesses */

int
initConnection (int clientFd, int true_color)
{
  xConnClientPrefix       prefixMsg;
  xConnSetupPrefix        setupMsg;
  xConnSetup              connSetupMsg;
  xPixmapFormat           pixFormatMsg;
  xWindowRoot             windowMsg;
  xDepth                  depthMsg;
  xVisualType             visualMsg;
  unsigned char          *authMsg;
  int                     authLen;
  char                    vendor[VENBYTES];

  winfoPtr root;
  cmapinfoPtr cmap;

/* silence purify UMR's (perhaps should fix them in code instead) */

  memset((char *)&prefixMsg, 0, sizeof(prefixMsg));
  memset((char *)&setupMsg, 0, sizeof(setupMsg));
  memset((char *)&connSetupMsg, 0, sizeof(connSetupMsg));
  memset((char *)&pixFormatMsg, 0, sizeof(pixFormatMsg));
  memset((char *)&windowMsg, 0, sizeof(windowMsg));
  memset((char *)&depthMsg, 0, sizeof(depthMsg));
  memset((char *)&visualMsg, 0, sizeof(visualMsg));
  memset((char *)vendor, 0, sizeof(vendor));

/* read the prefix message from the client */

  if (readLoop (clientFd, (char *) &prefixMsg,
                sizeof (prefixMsg)) < 0)
  {
    perror ("prefix read failed");
    return (False);
  }

/* read the authorization information if there is any */

  authLen = prefixMsg.nbytesAuthProto + prefixMsg.nbytesAuthString;
  if (authLen > 0)
  {
    authMsg = (unsigned char *) malloc (authLen);
    if (readLoop (clientFd, (char *)authMsg, authLen) < 0)
    {
      perror ("auth read failed");
      free (authMsg);
      return (False);
    }
    free (authMsg);
  }

/* create "predefined" resources for the client */

  cmap=createColormap(DEFAULT_COLORMAP(clientFd),PSEUDOCOLOR_VISUAL,clientFd);
  /*
  ** Need to do the preallocated white(0) and black(1)
  */
  cmap->colors[0].red = COLOR_VALUE(65535);
  cmap->colors[0].green = COLOR_VALUE(65535);
  cmap->colors[0].blue = COLOR_VALUE(65535);
  cmap->numAlloc[0] = 1;
  cmap->writeable[0] = FALSE;
  
  cmap->colors[1].red = COLOR_VALUE(0);
  cmap->colors[1].green = COLOR_VALUE(0);
  cmap->colors[1].blue = COLOR_VALUE(0);
  cmap->numAlloc[1] = 1;
  cmap->writeable[1] = FALSE;

  root = createWindow(ROOT_WINDOW_ID(clientFd),0,PSEUDOCOLOR_VISUAL,clientFd);
  root->attr.colormap = cmap->cmap;
  root->parent = root->win;	/* ...make root parent self... */
    
/* write the setup message to the client */

  setupMsg.success = True;
  setupMsg.lengthReason = 0;
  setupMsg.majorVersion = 11;
  setupMsg.minorVersion = 0;
  setupMsg.length = 8 + 2*2 + 
    ( VENBYTES + sizeof( xWindowRoot) + 
      2*( sizeof( xDepth) + sizeof( xVisualType))) / 4;
  if (write (clientFd, &setupMsg, sizeof (setupMsg)) < 0)
  {
    perror ("setup write failed");
    return (False);
  }

/* write the connection setup  message to the client */

  connSetupMsg.release = 1;
  connSetupMsg.ridBase = clientFd << CLIENTOFFSET;
  connSetupMsg.ridMask = RESOURCE_ID_MASK;
  connSetupMsg.motionBufferSize = 256;
  connSetupMsg.nbytesVendor = VENBYTES;
  connSetupMsg.maxRequestSize = MAXREQSZ / 4;
  connSetupMsg.numRoots = 1;
  connSetupMsg.numFormats = 2;
  connSetupMsg.imageByteOrder = MSBFirst;
  connSetupMsg.bitmapBitOrder = MSBFirst;
  connSetupMsg.bitmapScanlineUnit = 8;
  connSetupMsg.bitmapScanlinePad = 32;
  connSetupMsg.minKeyCode = 8;
  connSetupMsg.maxKeyCode = 132;
  if (debug)
  {
    printf ("rid base = %ld, mask = 0x%lx, maxrequest = %d\n",
            connSetupMsg.ridBase, connSetupMsg.ridMask,
            connSetupMsg.maxRequestSize);
  }
  if (write (clientFd, &connSetupMsg, sizeof (connSetupMsg)) < 0)
  {
    perror ("conn setup message write failed");
    return (False);
  }

/* write out the vendor string */

  strcpy (vendor, "print server");
  if (write (clientFd, vendor, sizeof (vendor)) < 0)
  {
    perror ("vendor write failed");
    return (False);
  }

/* write the pixmap formats */

  pixFormatMsg.depth = 1;
  pixFormatMsg.bitsPerPixel = 1;
  pixFormatMsg.scanLinePad = 32;
  if (write (clientFd, &pixFormatMsg, sizeof (pixFormatMsg)) < 0)
  {
    perror ("pixmap format message write failed");
    return (False);
  }
  pixFormatMsg.depth = 8;
  pixFormatMsg.bitsPerPixel = 8;
  pixFormatMsg.scanLinePad = 32;
  if (write (clientFd, &pixFormatMsg, sizeof (pixFormatMsg)) < 0)
  {
    perror ("pixmap format message write failed");
    return (False);
  }

/* write the message describing our hypothetical screen and root window */

  windowMsg.windowId = root->win;
  windowMsg.defaultColormap = cmap->cmap;
  windowMsg.whitePixel = 0;
  windowMsg.blackPixel = 1;
  windowMsg.currentInputMask = 0;
  /*
  ** Because XSetPrintParams assumes 72 dpi in page definition, the server
  ** should also return something matching that.. Thus make up values
  ** matching a (20" x 20") display with 72dpi.
  */
  windowMsg.pixWidth = 20 * 72;		/* 20 inch "display" with 72 dpi */
  windowMsg.pixHeight = 20 * 72;
  windowMsg.mmWidth = 2 * 254;		/* "2 * 254" == 20 * 25.4 mm */
  windowMsg.mmHeight = 2 * 254;
  windowMsg.minInstalledMaps = 1;
  windowMsg.maxInstalledMaps = 12;
  windowMsg.rootVisualID = root->visualID;
  windowMsg.backingStore = False;
  windowMsg.saveUnders = False;
  windowMsg.rootDepth = root->attr.depth;
  windowMsg.nDepths = 2;
  if (write (clientFd, &windowMsg, sizeof (windowMsg)) < 0)
  {
    perror ("window message write failed");
    return (False);
  }

/* write the depth information for the 8-bit PseudoColor visual */

  depthMsg.depth = 8;
  depthMsg.nVisuals = 1;
  if (write (clientFd, &depthMsg, sizeof (depthMsg)) < 0)
  {
    perror ("window message write failed");
    return (False);
  }

/* write the 8-bit PseudoColor visual */

  visualMsg.visualID = PSEUDOCOLOR_VISUAL;
  visualMsg.class = PseudoColor;
  visualMsg.bitsPerRGB = 8;
  visualMsg.redMask = 0;
  visualMsg.greenMask = 0;
  visualMsg.blueMask = 0;
  visualMsg.colormapEntries = NUM_COLORS;
  if (write (clientFd, &visualMsg, sizeof (visualMsg)) < 0)
  {
    perror ("window message write failed");
    return (False);
  }

/* write the depth information for the 24-bit TrueColor Visual */

  depthMsg.depth = 24;
  depthMsg.nVisuals = 1;
  if (write (clientFd, &depthMsg, sizeof (depthMsg)) < 0)
  {
    perror ("window message write failed");
    return (False);
  }

/* write the 24-bit TrueColor Visual */

  visualMsg.visualID = TRUECOLOR_VISUAL;
  visualMsg.class = TrueColor;
  visualMsg.bitsPerRGB = 8;
  visualMsg.redMask = 0xff;
  visualMsg.greenMask = 0xff00;
  visualMsg.blueMask = 0xff0000;
  visualMsg.colormapEntries = NUM_COLORS;
  if (write (clientFd, &visualMsg, sizeof (visualMsg)) < 0)
  {
    perror ("window message write failed");
    return (False);
  }
  return (True);
}

/* call read in a loop, to make sure we read everything we're supposed to */

int
readLoop (int fd,
          char *msg,
          int length)
{
  int                     nbytes,
                          total = 0;

  do
  {
    nbytes = read (fd, msg, length);
    if (nbytes <= 0)
    {
      return (nbytes);
    }
    else
    {
      length -= nbytes;
      total += nbytes;
      msg += nbytes;
    }
  }
  while (length > 0);
  if (debug)
    printf ("read %d bytes\n", total);
  return (total);
}

/* read a NULL-terminated vector of strings from a file */

char                  **
readStrvec (char *filename)
{
  FILE                   *fp;
  char                    buffer[512];
  int                     lineno = 1;
  char                  **vector,
                        **vecPtr;

/* read it to find the number of lines */

  if ((fp = fopen (filename, "r")) == NULL)
  {
    return (NULL);
  }
  do
  {
    if (fgets (buffer, sizeof (buffer), fp) == NULL)
    {
      break;
    }
    lineno++;
  }
  while (TRUE);

/* rewind and allocate the vector */

  rewind (fp);
  vector = vecPtr = (char **) malloc (sizeof (char *) * (lineno + 1));

/* read the lines and "strdup" them after getting rid of the \n */

  do
  {
    if (fgets (buffer, sizeof (buffer), fp) == NULL)
    {
      break;
    }
    buffer[strlen (buffer) - 1] = '\0';
    *vecPtr++ = strdup (buffer);
  }
  while (TRUE);
  *vecPtr = NULL;

/* close and return */

  fclose (fp);
  return (vector);
}

/* function for reading color correction table */

int
readCorrectionTable (char *filename,
                     int *ncorr,
                     float ***corrects)
{
  FILE                   *fp;
  int                     i;

  if ((fp = fopen (filename, "r")) == NULL)
  {
    fprintf (stderr, "failed to open color correction file %s\n", filename);
    return (FALSE);
  }
  fscanf (fp, "%d", ncorr);
  *corrects = (float **) malloc (sizeof (float *) * (*ncorr));

  for (i = 0; i < *ncorr; i++)
  {
    (*corrects)[i] = (float *) malloc (sizeof (float) * 3);
  }
  for (i = 0; i < *ncorr; i++)
  {
    if (fscanf (fp, "%f %f %f\n",
                &((*corrects)[i][0]),
                &((*corrects)[i][1]),
                &((*corrects)[i][2])) != 3)
    {
      fprintf (stderr, "failed to read color correction file %s\n",
               filename);
      fclose (fp);
      return (FALSE);
    }
  }
  fclose (fp);
  return (TRUE);
}

/* apply a color correction vector to a color */

void
correctColor (XColor *color,
              int ncorr,
              float **corrects)
{
  int                     ind;
  double                  frac;

  ind = ((ncorr - 1) * color->red) / 65536;
  if (ind < ncorr - 1)
  {
    frac = ((ncorr - 1) * color->red) / 65536.0 - ind;
    color->red = frac * color->red * corrects[ind][0] +
      (1.0 - frac) * color->red * corrects[ind + 1][0];
  }
  ind = ((ncorr - 1) * color->blue) / 65536;
  if (ind < ncorr - 1)
  {
    frac = ((ncorr - 1) * color->blue) / 65536.0 - ind;
    color->blue = frac * color->blue * corrects[ind][1] +
      (1.0 - frac) * color->blue * corrects[ind + 1][1];
  }
  ind = ((ncorr - 1) * color->green) / 65536;
  if (ind < ncorr - 1)
  {
    frac = ((ncorr - 1) * color->green) / 65536.0 - ind;
    color->blue = frac * color->green * corrects[ind][2] +
      (1.0 - frac) * color->green * corrects[ind + 1][2];
  }
}

/*- end pserver.c
*/
