/*-
|> File
|| ps_types.h
||
|> Description
||
||
|> Comments
||
||
|> History
|| 95061 _mf Created.
|| Oct/Nov 1995 modified by msa
||
||==================================================================|>
*/
#ifndef _dir_ps_types_h
#define _dir_ps_types_h

#ifndef _NOIDENT
#ident "$Id: ps_types.h,v 2.0 1995/06/05 16:52:18 reynolds Exp mreynold $"
#endif

#define PSEUDOCOLOR_VISUAL 0x20
#define TRUECOLOR_VISUAL 0x21
/*
** Make root window and default colormap "virtual", private to
** each client (as the code is not very good at keeping track of
** color allocations by client, this way makes it work a bit better,
** as long long as clients don't pass their colormaps to other clients...
** -- msa)
*/

#define DEFAULT_COLORMAP(fd) ((fd) << 8 | 0x22)
#define ROOT_WINDOW_ID(fd) ((fd) << 8 | 0x23)
/*
** COLOR_VALUE
**	throw away "insignificant" bits from the color values ("normalize")
*/
#define COLOR_VALUE(color) ((((color) >> 8) & 0xFF) * 257)

/*
   the following structure remembers for each file descriptor its
   state.  In particular, we need to know if it is busy or free
   and if it is in use, by whom.
 */

typedef int             FD;

struct FDDescriptor
{
  Bool                    Busy;
  int                     (*InputHandler) ();
};

typedef struct replyDel
{
  unsigned char          *reply;  /* if there's reply to substitute */
  int                     replyLength;
}
replyDelRec            , *replyDelPtr;

/* this is the structure for adding in printer options. I started off with
   a flag for indexed colorspaces, because our stupid versatec doesn't
   support them... */

typedef struct printOptions
{                               /* options used in the program. */
  int                     indexCspaceSupport;
}
printOptionsRec        , *printOptionsPtr;

/* window information */

typedef struct winfo
{
  Window                  parent;
  Window                  win;
  XWindowAttributes       attr;
  VisualID                visualID;
  int                     fd;
}
winfoRec               , *winfoPtr;

/* window table */

typedef struct winfoTable
{
  winfoPtr                winTable;
  int                     numWin;
  int                     numAlloc;
}

winfoTableRec          , *winfoTablePtr;

/* colormap information */

typedef struct cmapinfo
{
  XColor                  colors[NUM_COLORS];
  int                     numAlloc[NUM_COLORS];
  int                     numColors;
  int                     writeable[NUM_COLORS];
  Colormap                cmap;
  int			  visualID;
  int                     fd;
}
cmapinfoRec            , *cmapinfoPtr;

/* table of colormaps */

typedef struct cmapinfoTable
{
  cmapinfoPtr             cmapTable;
  int                     numCmap;
  int                     numAlloc;
}
cmapinfoTableRec       , *cmapinfoTablePtr;

/* GC information */

typedef struct gcinfo
{
  XID                     gcid;
  XGCValues               attr;
  XRectangle             *clipRects;
  int                     numClipRects;
  char                   *dashes;
  int                     numDashes;
  int                     fd;
}
gcinfoRec              , *gcinfoPtr;

/* gc table */

typedef struct gcinfoTable
{
  gcinfoPtr               gcTable;
  int                     numGc;
  int                     numAlloc;
}
gcinfoTableRec         , *gcinfoTablePtr;

/* for enum-string lookup tables */

typedef struct lookup
{
  int                     tag;
  char                   *name;
}
lookupRec              , *lookupPtr;

typedef struct FontData
    {
	int references;
	char *font_name;
	char *family_name;
	char *weight;
	char *encoding_scheme;
	int characters;
	int is_fixed_pitch;
	int iso_8859_1;
	int scale;
	double italic_angle;
	char *xlfd;
	XFontStruct *font_info;
    } FontData;

#define PIXELS(f,v,size) (((size) * (v) + (f)->scale/2) / (f)->scale)

typedef struct font
    {
	int fd;
	Font fid;
	int size;
	FontData *font_data;
    }
fontRec, *fontPtr;

typedef struct fontTable
{
  fontPtr                 fontTable;
  int                     numFonts;
  int                     numAlloc;
}
fontTableRec           , *fontTablePtr;

typedef struct atomTable
{
  char                    **name;
  int                     numAtoms;
  int                     numAlloc;
}
atomTableRec           , *atomTablePtr;


/*
** FontLoad
**	is used to keep track of which Font+Size combinations have been
**	initialized in the current output stream (so that already prepared
**	fonts can be reused)
*/
typedef struct FontLoad
    {
	struct FontLoad *next;
	struct FontData *font;
	int size;
    } FontLoad;

typedef struct PrintClient
    {
	Window win;	/* ..the meaning and use of this is
			   currently a bit unclear, as all drawing
			   seems to happen relative to root origin
			   and all drawable parameters in drawing
			   requests are simply ignored???  -- msa */
	char *printfile;
	FILE *printfp;
	FontLoad *fonts;	/* List of fonts used on current print */
	int unique;		/* Used in generating font /UniqueID */
	gcinfoPtr gc;		/* Current gc (compare only! don't deref!) */
	char *correctFile;	/* file of printing color corrections */
	int numCorrect;		/* length of color correct vector */
	float **corrects;	/* correction vectors */
	int sequence;
	int preserveAspect;	/* flag for aspect ratio */
	int fontScale;		/* font scale factor (ignored --msa) */
	int pixmapScale;	/* pixmap scale factor (ignored --msa) */
	int pageWidth;		/* page size in points */
	int pageHeight;
	int printDirect;	/* to file or direct to printer */
	int landscape;		/* 0=portrait, 1=landscape */
    } PrintClient;

#endif

/*- end ps_types.h
*/
