#ifndef _PRINTLIBP_H_
#define _PRINTLIBP_H_
#include <X11/Xlib.h>
#include <X11/Xmd.h>

/* the X, sz_ and xName all follow a naming convention for the hideous
   macros */

#define X_OpenPrint   1
#define X_ClosePrint    2
#define X_SetPrint    3

#define BadPrintWindow    0
#define PrintNumberErrors (BadPrintWindow + 1)

typedef struct _xOpenPrintReq
{
  CARD8                   reqType;  /* major and minor opcodes */
  CARD8                   printReqType;
  CARD16                  length;   /* request length */
  CARD16                  strlength;  /* actual length of filename */
  Drawable                drawable;   /* window to be printed */
  char                    filename[512];  /* name of file or printer */
  CARD16                  pad;
}
xOpenPrintReq;

typedef struct _xSetPrintReq
{
  CARD8                   reqType;  /* set printer parameters request */
  CARD8                   printReqType;
  CARD16                  length;
  CARD16                  aspect;   /* preserve printout aspect ratio. */
  CARD16                  fontScale;  /* font scaling (default=1) */
  CARD16                  pixmapScale;  /* pixmap scaling (default=1) */
  CARD16                  pageWidth;  /* page width and height in points */
  CARD16                  pageHeight;
  CARD16                  printDirect;  /* 0=file, 1=popen to named printer */
  CARD16                  strlength;  /* length of string */
  CARD16                  landscape;  /* 1=landscape 0=portrait */
  char                    correctFile[512];   /* color correction file */
}
xSetPrintReq;

typedef struct _xPrintReply
{
  CARD8                   type; /* reply from XOpenPrintWindow req */
  CARD8                   data1;
  CARD16                  sequenceNumber;
  CARD32                  length;
  CARD16                  flag;
  CARD16                  data00;   /* padding */
  CARD32                  data01;
  CARD32                  data02;
  CARD32                  data03;
  CARD32                  data04;
  CARD32                  data05;
}
xPrintReply;

typedef struct _xClosePrintReq
{
  CARD8                   reqType;  /* reply from XClosePrintWindow */
  CARD8                   printReqType;
  CARD16                  length;
  Drawable                drawable;
}
xClosePrintReq;

#define sz_xOpenPrintReq  sizeof( xOpenPrintReq)
#define sz_xClosePrintReq sizeof( xClosePrintReq)
#define sz_xSetPrintReq   sizeof( xSetPrintReq)

#endif /* _PRINTLIBP_H_ */
