/*-
|> File
|| printer.h
||
|> Description
||
||
|> Comments
||
||
|> History
|| 950jj _mf Created.
|| Oct/Nov 1995 modified by msa
||
||==================================================================|>
*/
#ifndef _dir_printer_h
#define _dir_printer_h

#ifndef _NOIDENT
#ident "$Id: printer.h,v 2.0 1995/06/05 16:52:17 reynolds Exp mreynold $"
#endif
#include <stdio.h>
#include <X11/Xlib.h>

#define DEFAULTPORT 6000
#define TRUE    1
#define FALSE   0
#define BACKLOG   5
#define STATICMAXFD 32
#define NUM_COLORS  256
#define NUMWIN    64
#define NUMGC     64
#define NUMATOM     64
#define NUMFONT   64
#define NUMCMAP     8
#define MAXFID    64

#include "ps_types.h"

extern lookupRec        XFN_NAMES[];
extern Display         *THE_DISPLAY;
extern printOptionsRec  PRINT_OPTIONS;  /* global ( only one of it, anyway) */
extern int              debug;

void initprocs( struct PrintClient *pc,
		int		   fd);

int readCorrectionTable( char 	*filename,
			 int	*ncorr,
			 float	***corrects);

winfoPtr getwinfo( const unsigned long win,
		   const winfoTablePtr table);

cmapinfoPtr getcmapinfo(long cmap);

void correctColor( XColor 	*color,
		   int 		ncorr,
		   float 	**corrects);

void printImageGrey( unsigned char *image,
		     int x,
		     int y,
		     int width,
		     int height,
		     int depth,
		     XColor *colors,
		     int numColors,
		     FILE * fp,
		     int indexSupport);

void printImage24( unsigned char     *image,
		  int                 x,
		  int                 y,
		  int                 width,
		  int                 height,
		  int                 depth,
		  FILE               *fp);


void initClient( struct PrintClient *pcs);

int initConnection (int clientFd, int true_color);

int readLoop( int fd,
	      char *msg,
	      int length);

Bool DecodeRequest( const FD fd,
		    unsigned char *const buf,
		    unsigned char *const newmsg,
		    int *const newlen);

void initTables(int true_color);

int internAtom(char *name);

cmapinfoPtr createColormap(long cmap, long visual, int fd);
winfoPtr createWindow(long window, long parent, long visual, int fd);
long allocColor(int cmap, unsigned *red, unsigned *green, unsigned *blue);


#endif

/*- end printer.h
*/
