/*-
|> File
|| drawcmd.h
||
|> Description
||
||
|> Comments
||
||
|> History
|| 95061 _mf Created.
||
||==================================================================|>
*/
#ifndef _dir_drawcmd_h
#define _dir_drawcmd_h

#ifndef _NOIDENT
#ident "$Id: drawcmd.h,v 2.0 1995/06/05 16:52:16 reynolds Exp $"
#endif

void                    polyfillrectangle (FD fd,
					   FILE * fp,
                                           Window win,
                                           gcinfoPtr gc,
                                           int nrect,
                                           XRectangle *rectangles);

void                    fillpoly (FD fd,
				  FILE * fp,
                                  Window win,
				  gcinfoPtr gc,
                                  int npoint,
                                  int coordmode,
                                  XPoint *points);

void                    polyline (FD fd,
				  FILE * fp,
                                  Window win,
                                  gcinfoPtr gc,
                                  int npoint,
                                  int coordmode,
                                  XPoint *points);

void                    polytext8 (FD fd,
				   FILE * fp,
                                   Window win,
                                   gcinfoPtr gc,
                                   int x,
                                   int y,
                                   int ntext,
                                   unsigned char *buffer);

void                    polytext16 (FD fd,
				    FILE * fp,
                                    Window win,
                                    gcinfoPtr gc,
                                    int x,
                                    int y,
                                    int ntext,
                                    unsigned char *buffer);

void                    imagetext8 (FD fd,
				    FILE * fp,
                                    Window win,
                                    gcinfoPtr gc,
                                    int x,
                                    int y,
                                    int ntext,
                                    unsigned char *buffer);

void                    imagetext16 (FD fd,
				     FILE * fp,
                                     Window win,
                                     gcinfoPtr gc,
                                     int x,
                                     int y,
                                     int ntext,
                                     unsigned char *buffer);


long                    pad (const long n);


void                    setCurrGc (FD fd,
				   FILE * fp,
				   gcinfoPtr gc,
				   Colormap cmap
);

/* set the values in a GC given the flags and the data buffer from a request */

void                    setGcvalues (FD fd,
				     FILE * fp,
				     gcinfoPtr gc,
				     unsigned long value_mask,
				     unsigned long *request,
				     Colormap cmap
);

void                    initprocs (
                                    struct PrintClient *pc,
                                    int fd
);

void                    polyfillrectangle (FD fd,
					   FILE * fp,
					   Window win,
					   gcinfoPtr gc,
					   int nrect,
					   XRectangle *rectangles
);

void                    polyrectangle (FD fd,
				       FILE * fp,
				       Window win,
				       gcinfoPtr gc,
				       int nrect,
				       XRectangle *rectangles
);

void                    fillpoly (FD fd,
				  FILE * fp,
				  Window win,
				  gcinfoPtr gc,
				  int npoint,
				  int coordmode,
				  XPoint *points
);

void                    polyline (FD fd,
				  FILE * fp,
				  Window win,
				  gcinfoPtr gc,
				  int npoint,
				  int coordmode,
				  XPoint *points
);

void                    polysegment (FD fd,
				     FILE * fp,
				     Window win,
				     gcinfoPtr gc,
				     int nseg,
				     XSegment *segments
);

void                    polytext8 (FD fd,
				   FILE * fp,
				   Window win,
				   gcinfoPtr gc,
				   int x,
				   int y,
				   int ntext,
				   unsigned char *buffer
);

void                    polytext16 (FD fd,
				    FILE * fp,
				    Window win,
				    gcinfoPtr gc,
				    int x,
				    int y,
				    int ntext,
				    unsigned char *buffer
);

void                    imagetext8 (FD fd,
				    FILE * fp,
				    Window win,
				    gcinfoPtr gc,
				    int x,
				    int y,
				    int ntext,
				    unsigned char *buffer
);

void                    imagetext16 (FD fd,
				     FILE * fp,
				     Window win,
				     gcinfoPtr gc,
				     int x,
				     int y,
				     int ntext,
				     unsigned char *buffer
);

void                    cleararea (FD fd,
				   FILE * fp,
				   Window win,
				   XWindowAttributes *attr,
				   int x,
				   int y,
				   int width,
				   int height
);

void                    putimage (FD fd,
				  FILE * fp,
				  Window win,
				  gcinfoPtr gc,
				  int depth,
				  int width,
				  int height,
				  int x,
				  int y,
				  int leftpad,
				  int format,
				  int numColors,
				  XColor *colors,
				  unsigned char *data
);

void                    copyarea (FD fd,
				  FILE * fp,
				  Drawable src,
				  Window win,
				  int srcX,
				  int srcY,
				  int dstX,
				  int dstY,
				  int width,
				  int height,
				  int numColors,
				  XColor *colors
);

void                    copyGcvalues (gcinfoPtr gc,
                                      gcinfoPtr srcGc,
                                      unsigned long value_mask);

void                    polypoint (FD fd,
				   FILE * fp,
                                   Window win,
                                   gcinfoPtr gc,
                                   int npoint,
                                   int coordmode,
                                   XPoint *points);

void                    polyarc (FD fd,
				 FILE * fp,
                                 Window win,
                                 gcinfoPtr gc,
                                 int narc,
                                 xArc * arcs);

void                    printImageGrey (unsigned char *image,
                                        int x,
                                        int y,
                                        int width,
                                        int height,
                                        int depth,
                                        XColor *colors,
                                        int numColors,
                                        FILE * fp,
                                        int indexSupport);

#endif

/*- end drawcmd.h
*/
