/*-
|> File
|| decode11.c
||
|> Description
||
|> Comments
|| There are 4 types of things in X11: requests, replies, errors, and events.
|| 
|| Each of them has a format defined by a small integer that defines
|| the type of the thing.
|| 
|| Requests have an opcode in the first byte.
|| Events have a code in the first byte.
|| Errors have a code in the second byte (the first byte is 0)
|| Replies ...
|| 
|| Replies have a sequence number in bytes 2 and 3.  The sequence
|| number should be used to identify the request that was sent, and
|| from that request we can determine the type of the reply.
||
|> History
|| Oct/Nov 1995 modified by msa
||
||==================================================================|>
*/
#ifndef _NOIDENT
#ident "$Id: decode11.c,v 2.0 1995/06/05 16:52:11 reynolds Exp $"
#endif

#include <stdio.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>

#define NEED_REPLIES
#include <X11/Xproto.h>
#include <X11/Xlib.h>

#include "printer.h"
#include "printlib.h"
#include "printlibP.h"
#include "afm.h"
#include "global.h"

/*- Declare initialized globals.
*/
/* standard GC created with all default values */
XGCValues               initial_GC =
{
  GXcopy,                       /* function */
  AllPlanes,                    /* plane_mask */
  0L,                           /* foreground */
  1L,                           /* background */
  0,                            /* line_width */
  LineSolid,                    /* line_style */
  CapButt,                      /* cap_style */
  JoinMiter,                    /* join_style */
  FillSolid,                    /* fill_style */
  EvenOddRule,                  /* fill_rule */
  ArcPieSlice,                  /* arc_mode */
  ~0L,                          /* tile, impossible (unknown) resource */
  ~0L,                          /* stipple, impossible (unknown) resource */
  0,                            /* ts_x_origin */
  0,                            /* ts_y_origin */
  ~0L,                          /* font, impossible (unknown) resource */
  ClipByChildren,               /* subwindow_mode */
  True,                         /* graphics_exposures */
  0,                            /* clip_x_origin */
  0,                            /* clip_y_origin */
  None,                         /* clip_mask */
  0,                            /* dash_offset */
  4                             /* dashes (list [4,4]) */
};

XWindowAttributes       initial_Attrs =
{
  0,                            /* x */
  0,                            /* y */
  0,                            /* width */
  0,                            /* height */
  0,                            /* border width */
  8,                            /* default depth */
  0,                            /* visual */
  0,                            /* root window of containing screen */
  InputOutput,                  /* class */
  0,                            /* bit gravity */
  0,                            /* win gravity */
  NotUseful,                    /* backing store */
  0,                            /* backing pixel */
  False,                        /* save under */
  0,                            /* colormap */
  False,                        /* colormap installed flag */
  IsUnmapped,                   /* map state */
  0,                            /* all event mask */
  0,                            /* my event mask */
  0,                            /* do-not-propogate mask */
  False,                        /* override-redirect */
  0                             /* screen pointer */
};

int                     THE_OPCODE = 144;

int                     HandleX_Request (
                                          void *const buf, unsigned char *newmsg, int *newlen,
                                          const int request, const FD fd);




/*
** clean_font_load
**	cleanout the info about loaded fonts, if any
*/
static void clean_font_load(struct PrintClient *pc)
    {
	FontLoad *load;

	while ((load = pc->fonts) != NULL)
	    {
		pc->fonts = load->next;
		FreeFont(load->font);
		free((char *)load);
	    }
    }

/*-=================================================================|>
||
|> Public functions
||
||==================================================================|>
||
|> Function
|| DecodeRequest
||
|> Description
|| return TRUE/FALSE as to whether this request should be
|| forwarded to the server.
||
|> Comments
|| None.
||
|> Parameters
|| -void.
||
|> Returns
|| Returns void.
||
|> Exits
|| Exits if:
||
|> Limits
||   
||
||==================================================================|>
*/

Bool
DecodeRequest (
                const FD fd,
                unsigned char *const buf,
                unsigned char *const newmsg,
                int *const newlen)

{
  const short             Request = *buf;
  xGenericReply          *reply = (xGenericReply *) newmsg;

  *newlen = 0;

/* set reply sequence # in advance */

  reply->sequenceNumber = ++(PCS[fd].sequence);
  reply->type = X_Reply;

  if (debug)
    printf ("request opcode = %d\n", Request);

  if ((Request <= 0) || (127 < Request))
  {
    xOpenPrintReq          *openReq;
    xClosePrintReq         *closeReq;
    xSetPrintReq           *setReq;
    xPrintReply            *printRply = (xPrintReply *) newmsg;

    if (*buf == THE_OPCODE)
    {
      printRply->type = 1, printRply->length = 0;
      switch (buf[1])
      {
      case X_ClosePrint:
        closeReq = (xClosePrintReq *) buf;
        if (PCS[fd].printfp)
        {
          fprintf (PCS[fd].printfp, "\nshowpage\n");
          if (PCS[fd].printDirect)
            pclose (PCS[fd].printfp);
          else
            fclose (PCS[fd].printfp);

          PCS[fd].printfp = 0;
	  clean_font_load(&PCS[fd]);
        }
        break;

      case X_OpenPrint:

/* read the print request */
        openReq = (xOpenPrintReq *) buf;
	if (PCS[fd].printfile)
	  free(PCS[fd].printfile);
        PCS[fd].printfile = (char *) malloc (openReq->strlength + 1);
        PCS[fd].correctFile = 0;
        strncpy (PCS[fd].printfile, openReq->filename,
                 openReq->strlength);
        PCS[fd].printfile[openReq->strlength] = '\0';

/* if he requested direct printing, then the filename is the name of the
   printer */

	/*
	** ..having a daemon accepting connections on non-priv port (6001)
	** and this daemon blindly calling a shell or creating files from
	** the client requests is a bad move... to lessen the most obvious
	** dangers, the following band-aid will "mangle" the input string
	** so that it only can contain alphanumerics and some special
	** characters ('-', '.' and '_'). The code below may be overly
	** restrictive, but anyone naming their printer device as '.p' or
	** '../foo' can fix this piece too.. -- msa
	*/
	    {
		char *r;
		char *s = strrchr(PCS[fd].printfile, '/');
		if (s)
			s++;	/* No directory paths allowed!!!! */
		else
			s = PCS[fd].printfile;
		for (r = PCS[fd].printfile; *s; ++s)
		    {
			if (isalnum(*s) || *s == '_')
				*r++ = *s;
			else if (*s == '-')
			    {
				/* Do not accept '-' as first char! */
				if (r != PCS[fd].printfile)
					*r++ = *s;
			    }
			else if (*s == '.')
			    {
				/* Do not accept '.' as a first char,
				   Do not accept multiple consecutive '.'
				   */
				if (r != PCS[fd].printfile && r[-1] != '.')
					*r++ = *s;
			    }
		    }
		*r++ = 0;
	    }
	if (!PCS[fd].printfile[0])
	    {
		fprintf(stderr, "invalid printername/filename %*.*s\n",
			(int)openReq->strlength, (int)openReq->strlength,
			openReq->filename);
	    }
        else if (PCS[fd].printDirect)
	    {
		char cmd[100];

		strcpy(cmd, "lpr -P ");
		strncat(cmd, PCS[fd].printfile, sizeof(cmd) - strlen(cmd));
		cmd[sizeof(cmd)-1] = 0;
		if (!(PCS[fd].printfp = popen (cmd, "w")))
			fprintf (stderr, "failed to open pipe %s\n", cmd);
	    }
        else if ((PCS[fd].printfp = fopen (PCS[fd].printfile, "w")) == NULL)
		fprintf (stderr, "failed to open file %s\n",
			 PCS[fd].printfile);

        printRply->flag = (PCS[fd].printfp != NULL);
        PCS[fd].win = openReq->drawable;

/* put in the postscript header information */

	clean_font_load(&PCS[fd]);

        if (printRply->flag) {
          initprocs (&PCS[fd], fd);
	}
        *newlen = sizeof (printRply);
        break;

/* print showpage, and close the file */

/* for setting printer attributes, can be extended */

      case X_SetPrint:
        setReq = (xSetPrintReq *) buf;
        PCS[fd].preserveAspect = setReq->aspect;
        PCS[fd].fontScale = setReq->fontScale;
        PCS[fd].pixmapScale = setReq->pixmapScale;
        PCS[fd].pageWidth = setReq->pageWidth;
        PCS[fd].pageHeight = setReq->pageHeight;
        PCS[fd].printDirect = setReq->printDirect;
        PCS[fd].landscape = setReq->landscape;

/* copy the name of the color correction file and load the values, if there
   is one */

        if (setReq->strlength)
        {
          PCS[fd].correctFile = malloc (setReq->strlength + 1);
          strncpy (PCS[fd].correctFile, setReq->correctFile,
                   setReq->strlength);
          PCS[fd].correctFile[setReq->strlength] = '\0';

/* if it failed, then set the correction file to NULL */

          if (!readCorrectionTable (PCS[fd].correctFile,
                                    &PCS[fd].numCorrect,
                                    &PCS[fd].corrects))
          {
            fprintf (stderr, "failed to read correction table\n");
            free (PCS[fd].correctFile);
            PCS[fd].correctFile = 0;
          }
        }
        break;

      default:
        fprintf (stderr, "Received erroneous minor opcode.\n");
      }
    }

    return True;                /* maybe this will be useful in the future */
  }

  /*- If it was not handled above, handle it here.
  */
  return (HandleX_Request (buf, newmsg, newlen, Request, fd));
}

/*- end decode11.c
*/
