/*
** image_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to image
**	resources.
*/
UI_ElementDef image_list[] =
    {
	UI_PANE("ColorMode"),
	UI_TOGGLE("mono",	XeColorMode_MONO),
	UI_RADIO("gray",	XeColorMode_GRAY),
	UI_RADIO("color", 	XeColorMode_COLOR),
	UI_LOAD(XtNcolorMode),
	UI_INPUT("max colors:"),
	UI_LOAD(XtNmaxColors),
	UI_LABEL("Dither"),
	UI_TOGGLE("none",	XeDither_NONE),
	UI_RADIO("fs4",		XeDither_FS4),
	UI_LOAD(XtNdither),
	UI_LABEL("ColorQuantize"),
	UI_TOGGLE("fast",	XeColorQuantize_FAST),
	UI_RADIO("heckbert",	XeColorQuantize_HECKBERT),
	UI_RADIO("ppmquant",	XeColorQuantize_PPMQUANT),
	UI_RADIO("jpeg",	XeColorQuantize_JPEG),
	UI_LOAD(XtNcolorQuantize),
	UI_LABEL("Window Geometry"),
	UI_INPUT("Width :"),
	UI_LOAD(XtNwidth),
	UI_INPUT("Height:"),
	UI_LOAD(XtNheight),

	UI_PANE("Colormap use"),
	UI_TOGGLE("shared",	XeColormapUse_SHARED),
	UI_RADIO("sharedown",	XeColormapUse_SHAREDOWN),
	UI_RADIO("optional",	XeColormapUse_OPTIONAL),
	UI_RADIO("private",	XeColormapUse_PRIVATE),
	UI_LOAD(XtNcolormapUse),
	UI_LABEL("Miscellanous"),
	UI_TOGGLE("Use MIT-SHM",True),
	UI_LOAD(XtNuseShm),
	UI_TOGGLE("Install colormap", True),
	UI_LOAD(XtNcolormapInstall),
	UI_TOGGLE("Resize", True),
	UI_LOAD(XtNresize),
	UI_INPUT("foreground: "),
	UI_LOAD(XtNforeground),
	UI_INPUT("background: "),
	UI_LOAD(XtNbackground),

	UI_PANE("Scaling"),
	UI_TOGGLE("none",	XeScaling_NONE),
	UI_RADIO("width",	XeScaling_WIDTH),
	UI_RADIO("height",	XeScaling_HEIGHT),
	UI_RADIO("maxaspect",	XeScaling_MAXASPECT),
	UI_RADIO("fitarea",	XeScaling_FITAREA),
	UI_LOAD(XtNscaling),
	UI_LABEL("Rotation"),
	UI_TOGGLE("  0",	0),
	UI_RADIO( " 90",	90),
	UI_RADIO( "180",	180),
	UI_RADIO( "270",	270),
	UI_LOAD(XtNrotation),
	UI_TOGGLE("mirror",	True),
	UI_LOAD(XtNmirrorImage),
	UI_LABEL("Logical size"),
	UI_INPUT("width: "),
	UI_LOAD(XtNrasterWidth),
	UI_INPUT("height: "),
	UI_LOAD(XtNrasterHeight),
	UI_LABEL("Clip from logical"),
	UI_INPUT("x: "),
	UI_LOAD(XtNclipX),
	UI_INPUT("y: "),
	UI_LOAD(XtNclipY),
	UI_INPUT("width: "),
	UI_LOAD(XtNclipWidth),
	UI_INPUT("height: "),
	UI_LOAD(XtNclipHeight),
	UI_END(),
    };

extern UI_PanelDef image_resources;

static UI_ActionDef image_actions[] =
    {
	{"set", UI_AcceptPanel, (XtPointer)&image_resources},
	{"close"},
	{NULL},
    };

UI_PanelDef image_resources = 
    {
	"Image Resources",
	image_list,
	image_actions,
    };

