#ifndef _XewTextEdP_h
#define _XewTextEdP_h
/*
** Copyright 1993 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Xew/BasicP.h>
#include <X11/Xew/TextP.h>
#include <X11/Xew/TextEd.h>

typedef struct _XeTextEdClass
    {
	int makes_compiler_happy;	/* not used */
    } XeTextEdClassPart;


typedef struct _XeTextEdClassRec
    {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
	XeBasicClassPart basic_class;
	XeTextClassPart text_class;
	XeTextEdClassPart texted_class;
    } XeTextEdClassRec;

typedef struct
    {
	XeTextHighlight mode;	/* Highlite mode */
	Boolean delayed;	/* Refresh delayed */
	short nrect;		/* Number rectangles in 'rect' */
	long range[2];		/* Affected text area (virtual offsets) */
	XRectangle rect[3];	/* Covering rectangles (for expose) */
    } XeTextRegion;

	
typedef struct
    {
	Atom *selections;	/* Owned selections */
	int atom_count;		/* Number of  atoms in selections */
	int array_size;		/* Size of the selections array */
    } XeTextSelection;

typedef struct
    {
	/* resources */
	Boolean	allow_edit;	/* True, if editing allowed */
	Boolean display_caret;	/* True, if caret symbol is visible */
	long cursor_position;	/* Current position (virtual offset) */
	XtCallbackList modify_callbacks;

	/* private state */

	/*
	** insert_prefix and insert_prefix_length define an octet string
	** that will be implicitly inserted every time an insert point
	** is opened. It should contain only control sequences to change
	** the graphic presentation from the default initialState. The
	** modes set by insert_prefix will be locked. The value can be set
	** with XeTextInsertPrefix function.
	*/
	char *insert_prefix;
	long insert_prefix_length;
	
	Pixmap cursor;		/* Cursor Image Bitmap */
	/*
	** Information about the cursor location in various levels. To
	** speed up some processing, the some precomputed information
	** is maintained (matching the cursor_location).
	**
	** (cursor_x, cursor_y) is the current (x,y) location matching
	**	cursor_location.
	** cursor_location is the current (Snip, offset) pointer
	**	matching the cursor_position. This is information is
	**	the primary for defining the cursor position.
	** cursor_position
	**	is the virtual offset matching the cursor_location.
	*/
	short cursor_x, cursor_y;
	XeTextLocation cursor_location;
	XeTextSelection s;	/* Current Selection information */
	int mult;		/* Repeater count for actions */
	short cursor_goal;	/* Horizontal target position for cursor */
	unsigned need_layout:1;	/* Content has been modified since layout */
	unsigned full_layout:1;	/* Need full layout (insert point has moved) */
	Time time;		/* Time of the last event */
	Region refresh;		/* Region requiring refresh on display */
	/*
	** Current Text Regions. A text region is a text segment defined by
	** two virtual offsets, and it may optionally be assocated with some
	** automatic highlighting. The first text region (id = 0) always
	** exists and is reserved for the selection mechanism. The remaining
	** entries are available for the application use and text_regions
	** array is resized as needed. The region identifier is an index
	** to this array. Unset region entries will be re-used, and the
	** text_regions array never shrinks.
	*/
	int num_regions;	/* Highest region entry in use */
	int max_regions;	/* Current size of text regions array */
	XeTextRegion *regions;	/* Text regions array pointer */
	/*
	** To implement scrolling the TextEd must be aware about
	** the position and size relative to the *real* window parent,
	** which is not necessarily the same as the window of the
	** parent Widget. The following private variables track the
	** relation between TextEd Window and parent Window.
	*/
	Window parent;		/* Parent Window */
	int parent_width, parent_height;
	int window_x, window_y;	/* TextEd Window position */
    } XeTextEdPart;

typedef struct _XeTextEdRec
    {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
#ifdef USING_MOTIF_122
        XmManagerPart	manager;
#endif
	XeBasicPart	basic;
	XeTextPart	text;
	XeTextEdPart	texted;
    } XeTextEdRec;

/* Class pointer */
extern XeTextEdClassRec xeTextEdClassRec;
#endif

