/*
** A demo program for TextEd widget
**
** WARNING!
**	This is not any real "editor". The user interface is just a
**	jumbled collection of buttons and menus which access the
**	TextEd features individually at low level.
*/
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h> /* Some <sys/stat.h>'s need this, not all */
#include <sys/stat.h>
#if SYSV_INCLUDES
#	include <memory.h>
#endif
#include <string.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Video.h>
#include <X11/Xew/TextEd.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/Support.h>
#include <X11/Xmu/Atoms.h>	/* needed for cut/paste export/import */

#if SYSV_INCLUDES || ANSI_INCLUDES
#	include <limits.h>
#else
#ifndef LONG_MAX
#define LONG_MAX (~((unsigned long)0L)>>1)
#endif
#endif

#include "ui_tools.h"

static void Export();
static void Import();
static char *LoadFromFile();
static void SetInsertState();

static Widget root_widget, main_window;
static Widget edit_widget;	/* TextEd widget instance */
static char *edit_file;		/* Current primary file */
static Widget edit_title;	/* Label Widget for filename */
static int text_modified;	/* True if text modified */

static Position AdjustCoord(x, y, a, b)
int x, a, b;
    {
	if (x < a)
		a = x;
	else if (x + y >= a + b)
		a = x + y - b;
	return a;
    }


/*
** RemovePanelTarget
**	a callback function that removes the Widget from the panel
**	target.
*/
static void RemovePanelTarget(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;

	if (panel && panel->target == w)
		panel->target = None;
    }

/*
** ChangePanelTarget
**	Change the target widget of a panel. Primarily, this function
**	adds a Destroy Callback to the widget for removing the reference
**	from the panel, if widget gets destroyed.
*/
static void ChangePanelTarget(w, panel)
Widget w;
UI_PanelDef *panel;
    {
	if (panel->target)
		XtRemoveCallback(panel->target, XtNdestroyCallback,
				 RemovePanelTarget, (XtPointer)panel);
	if ((panel->target = w) != 0)
		XtAddCallback(w, XtNdestroyCallback, RemovePanelTarget,
			      (XtPointer)panel);
    }

/*
** Notify_MENU
**	Popup a menu panel associated with the widget. Assume the
**	client_data is a resource list panel description.
*/
static void Notify_MENU(w, data)
Widget w;
XtPointer data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)data;

	if (panel)
	    {
		ChangePanelTarget(w, panel);
		UI_SetToggles(panel);
		UI_PopupPanel(w, (XtPointer)panel, (XtPointer)NULL);
	    }
    }


/*
** Sample Notify skeleton..
*/
static void Notify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyCallbackData *notify = (XeNotifyCallbackData *)call_data;
	XeNotifyAreaCallbackData *area;
	int i;
	Position x, y;

	switch (notify->reason)
	    {
	    case XeCR_NOTIFY:
		for (i = 0; i < notify->num_params; i++)
		    {
			if (strcmp("MENU", notify->params[i]) == 0)
				Notify_MENU(w, client_data);
		    }
		break;
	    case XeCR_NOTIFY_AREA:
		/*
		** This works only for the top level widget. Not Insets!!
		*/
		if (w == edit_widget)
		    {
			area = (XeNotifyAreaCallbackData *)call_data;
			x = AdjustCoord(area->area.x, area->area.width,
					area->visible.x, area->visible.width);
			y = AdjustCoord(area->area.y, area->area.height,
					area->visible.y, area->visible.height);
#if X11R5
			if (x != area->visible.x || y != area->visible.y)
				XawViewportSetCoordinates(XtParent(w), x, y);
#endif
		    }
		break;
	    default:
		printf("UNKNOWN: XeRC=%d\n", (int)notify->reason);
		break;
	    }
    }

static void Modify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	text_modified = True;
    }

static void SelectAll(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeTextSetSelection(edit_widget, (long)0, (long)LONG_MAX);
    }

static void InsertText(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	long pos = XeTextGetInsertionPoint(edit_widget);

	if (!client_data)
		return;
	XeTextReplace(edit_widget, pos, pos,
		      (char *)client_data, strlen((char *)client_data));
    }
/*
** SetFilenameToTitle
*/
static void SetFilenameToTitle()
    {
	Arg args[1];
	char *label = edit_file ? edit_file : "(noname)";

	XtSetArg(args[0], XtNlabel, label);
	XtSetValues(edit_title, args, (Cardinal)1);
    }

/*
** AddInset
**	insert a widget at current insert point in the text stream.
*/

#include "image_panel.c"
#include "video_panel.c"
#include "text_panel.c"

extern UI_PanelDef popup_paragraph_control;
extern UI_PanelDef popup_insert_state;


static UI_ElementDef insert_state[] =
    {
	/* *NOTE* The control sequences in data assume the C compiler is
	   is using ASCII code set. --msa */
	UI_PANE(	" "),
	UI_TOGGLE(	"Normal intensity",	"\033[22m"),
	UI_RADIO(	"Bold",			"\033[1m"),
	UI_TOGGLE(	"Italic",		"\033[3m"),
	UI_RADIO(	"Not italic",		"\033[23m"),
	UI_TOGGLE(	"Underlined",		"\033[4m"),
	UI_RADIO(	"Double underlined",	"\033[21m"),
	UI_RADIO(	"Not underlined",	"\033[24m"),
	UI_TOGGLE(	"Inverse", 		"\033[7m"),
	UI_RADIO(	"Not inversed",		"\033[27m"),
	UI_TOGGLE(	"Crossed out", 		"\033[9m"),
	UI_RADIO(	"Not crossed out", 	"\033[29m"),
	UI_TOGGLE(	"Framed", 		"\033[51m"),
	UI_RADIO(	"Not framed",	 	"\033[54m"),
	UI_TOGGLE(	"Superscript",		"\033L\033L"),
	UI_RADIO(	"Baseline",		"\033K\033K\033L"),
	UI_RADIO(	"Subscript",		"\033K\033K"),
	UI_TOGGLE(	"Default aligned",	"\033[0 F"),
	UI_RADIO(	"Justified",		"\033[2 F"),
	UI_RADIO(	"Start aligned",	"\033[5 F"),
	UI_RADIO(	"Centered",		"\033[6 F"),
	UI_RADIO(	"End aligned",		"\033[7 F"),
	UI_PANE(	"Foreground:"),
	UI_TOGGLE(	"Default",		"\033[39m"),
	UI_RADIO(	"Black",		"\033[30m"),
	UI_RADIO(	"Red",			"\033[31m"),
	UI_RADIO(	"Green",		"\033[32m"),
	UI_RADIO(	"Yellow",		"\033[33m"),
	UI_RADIO(	"Blue",			"\033[34m"),
	UI_RADIO(	"Magenta",		"\033[35m"),
	UI_RADIO(	"Cyan",			"\033[36m"),
	UI_RADIO(	"White",		"\033[37m"),
	UI_LABEL(	"Background:"),
	UI_TOGGLE(	"Default",		"\033[49m"),
	UI_RADIO(	"Black",		"\033[40m"),
	UI_RADIO(	"Red",			"\033[41m"),
	UI_RADIO(	"Green",		"\033[42m"),
	UI_RADIO(	"Yellow",		"\033[43m"),
	UI_RADIO(	"Blue",			"\033[44m"),
	UI_RADIO(	"Magenta",		"\033[45m"),
	UI_RADIO(	"Cyan",			"\033[46m"),
	UI_RADIO(	"White",		"\033[47m"),
	UI_PANE(	"Font:"),
	UI_TOGGLE(	"primary (default)",	"\033[10m"),
	UI_RADIO(	"First alternative",	"\033[11m"),
	UI_RADIO(	"Second alternative",	"\033[12m"),
	UI_RADIO(	"Third alternative",	"\033[13m"),
	UI_RADIO(	"Fourth alternative",	"\033[14m"),
	UI_RADIO(	"Fifth alternative",	"\033[15m"),
	UI_RADIO(	"Sixth alternative",	"\033[16m"),
	UI_RADIO(	"Seventh alternative",	"\033[17m"),
	UI_RADIO(	"Eight alternative",	"\033[18m"),
	UI_RADIO(	"Ninth alternative",	"\033[19m"),
	UI_LABEL(	"Size modification:"),
	UI_TOGGLE(	" 25%",	"\033[25 B"),
	UI_RADIO(	" 50%",	"\033[50 B"),
	UI_RADIO(	" 75%",	"\033[75 B"),
	UI_RADIO(	"100%",	"\033[100 B"),
	UI_RADIO(	"125%",	"\033[125 B"),
	UI_RADIO(	"150%",	"\033[150 B"),
	UI_RADIO(	"175%",	"\033[175 B"),
	UI_RADIO(	"200%",	"\033[200 B"),
	UI_RADIO(	"225%",	"\033[225 B"),
	UI_RADIO(	"250%",	"\033[250 B"),
	UI_RADIO(	"275%",	"\033[275 B"),
	UI_RADIO(	"300%",	"\033[300 B"),
	UI_PANE(	"Character set:"),
	UI_TOGGLE("iso8859-1 (Latin No.1)","\33(B\33)B\33.A\33/A\17\33\175"),
	UI_RADIO("iso8859-2 (Latin No.2)","\33(B\33)B\33.B\33/B\17\33\175"),
	UI_RADIO("iso8859-3 (Latin No.3)","\33(B\33)B\33.C\33/C\17\33\175"),
	UI_RADIO("iso8859-4 (Latin No.4)","\33(B\33)B\33.D\33/D\17\33\175"),
	UI_RADIO("iso8859-5 (Latin/Cyrillic)","\33(B\33)B\33.L\33/L\17\33\175"),
	UI_RADIO("iso8859-6 (Latin/Arabic)","\33(B\33)B\33.G\33/G\17\33\175"),
	UI_RADIO("iso8859-7 (Latin/Greek)","\33(B\33)B\33.F\33/F\17\33\175"),
	UI_RADIO("iso8859-8 (Latin/Hebrew)","\33(B\33)B\33.H\33/H\17\33\175"),
	UI_RADIO("iso8859-9 (Latin No.5)","\33(B\33)B\33.M\33/M\17\33\175"),
	UI_RADIO("iso6937","\33(B\33)B\33.R\33/R\17\33\175"),
	UI_RADIO("iso646-se",		"\33(G\33)G\33.A\33/A\17\33\175"),
	UI_RADIO("iso646-se (names)",	"\33(H\33)H\33.A\33/A\17\33\175"),
	UI_RADIO("EUC", "\33(J\33$)B\33*I\33$+C\17\33\176"),
	UI_RADIO("KSC 5601-1987",	"\33(B\33)B\33$*C\33$+C\17\33\175"),
	UI_RADIO("GB 2312-80",		"\33(B\33)B\33$*A\33$+A\17\33\175"),
	UI_END(),
    };


static UI_ActionDef insert_state_actions[] =
    {
	{"set", SetInsertState, (XtPointer)&popup_insert_state},
	{"close"},
	{NULL},
    };

UI_PanelDef popup_insert_state =
    {
	"Change Input State",
	insert_state,
	insert_state_actions,
    };


static void AddInset(parent, name)
Widget parent;
char *name;
    {
	static UI_PanelDef inset_resources = 
	    {
		"Inset Constraint Resources",
		/* inset_list, */
		/* inset_actions, */
	    };

	static UI_ActionDef inset_actions[] =
	    {
		{"set", UI_AcceptPanel, (XtPointer)&inset_resources},
		{"close"},
		{NULL},	    
	    };

	/*
	**	Inset resources
	*/
	static UI_ElementDef inset_list[] =
	    {
		UI_PANE("Frame Position"),
		UI_INPUT("positioning:"),
		UI_LOAD(XtNframePosition),
		UI_INPUT("alignment:"),
		UI_LOAD(XtNframeAlignment),
		
		UI_LABEL("Frame Dimension"),
		UI_INPUT("Horizontal: "),
		UI_LOAD(XtNhorizontal),
		UI_INPUT("Vertical: "),
		UI_LOAD(XtNvertical),
		
		UI_LABEL("Frame separation"),
		UI_INPUT("trailing:"),
		UI_LOAD(XtNtrailingSeparation),
		UI_INPUT("leading:"),
		UI_LOAD(XtNleadingSeparation),
		UI_INPUT("left:"),
		UI_LOAD(XtNleftSeparation),
		UI_INPUT("right:"),
		UI_LOAD(XtNrightSeparation),
		
		UI_PANE("Frame borders"),
		UI_INPUT("left: "),
		UI_LOAD(XtNleftBorder),
		UI_INPUT("right: "),
		UI_LOAD(XtNrightBorder),
		UI_INPUT("trailing: "),
		UI_LOAD(XtNtrailingBorder),
		UI_INPUT("leading: "),
		UI_LOAD(XtNleadingBorder),

		UI_TOGGLE("invert shadow",	True),
		UI_LOAD(XtNinvertShadow),
		UI_END(),
	    };

	Widget inset;
	Arg args[10];
	int n;
	XeContentFormat content_type;
	XeContentClass content_class;
	UI_PanelDef *resources = NULL;

	if (!name || strlen(name) == 0)
		return;

	if (!inset_resources.elements)
	    {
		/* Icky.. just because some compilers have hard time
		   with forward declarations...
		   */
		inset_resources.elements = inset_list;
		inset_resources.actions = inset_actions;
	    }
	content_type = XeFindContentFormat(name);
	content_class = XeFindContentClass(content_type);
	n = 0;
	XtSetArg(args[n], XtNcontentFile, name); ++n;
	XtSetArg(args[n], XtNcontentFormat, content_type); ++n;
	switch (content_class)
	    {
	    default:
		/*
		** If the inset would be a Text Widget, don't use the
		** contentFile resource. Use LoadFromFile, which does
		** the 'inset hack' processing for this content too!
		*/
#ifdef USING_MOTIF_122
		inset = XeCreateMotifTextEd(name, parent, args, 0);
#else
		inset = XtCreateManagedWidget
			(name, xeTextEdWidgetClass, parent, args, 0);
#endif
		XtAddCallback(inset,XtNexportCallback,Export,(XtPointer)NULL);
		XtAddCallback(inset,XtNimportCallback,Import,(XtPointer)NULL);
		XtAddCallback(inset,XtNnotifyCallback, Notify,
			      (XtPointer)&popup_insert_state);
		LoadFromFile(inset, name);
		resources = &text_resources;
		break;
	    case XeContentClass_AUDIO:
		inset = XtCreateManagedWidget
			(name, xeAudioWidgetClass, parent, args, n);
		break;
	    case XeContentClass_RASTER:
		inset = XtCreateManagedWidget
			(name, xeRasterWidgetClass, parent, args, n);
		resources = &image_resources;
		break;
	    case XeContentClass_VIDEO:
		inset = XtCreateManagedWidget
			(name, xeVideoWidgetClass, parent, args, n);
		resources = &video_resources;
	    }
	if (inset)
	    {
		XtAddCallback(inset, XtNnotifyCallback, Notify,
			      (XtPointer)&inset_resources);
		if (resources)
			XtAddCallback(inset, XtNnotifyCallback, Notify,
				      (XtPointer)resources);
	    }
    }

/*
** ********************************
** CUT/PASTE FILTERS AND PROCESSING
** ********************************
** This an sample code that utilizes the export- and import callbacks.
**
** The idea behind those call back is that XeTextEd cannot know all
** possible application specific formats and thus gives the application
** a chance to do own convertions, and add extra targets.
*/

#define INSET_MARK '\001'

typedef struct DataBuffer
    {
	Widget w;	/* Associated Widget */
	int size;	/* Current Size of data buffer */
	int length;	/* Bytes in the data buffer */
	char *data;	/* Allocated data buffer */
    } DataBuffer;

static DataBuffer init_DataBuffer; /* Initializing DataBuffer */

/*
** FeedData
**	is called multiple times, for many snippets
*/
static int FeedData(data, length, tag, client_data)
char *data;
int length;
XeTextTag tag;
XtPointer client_data;
    {
	DataBuffer *buffer = (DataBuffer *)client_data;
	int wrap = False;

	if (length < 0)
		return 0;
	else if (length == 0)
	    {
		/*
		** Assumption: Feed with ZERO length is called only when
		** the stream contains inset (widgets). Assume the data
		** is actually a widget pointer. [For a more robust and
		** final solution one *should* really use TAG for double
		** check --msa]
		*/
		Widget inset = (Widget)data;
		if (!inset)
			return;
		length = strlen(XtName(inset)) + 2;
		data = XtName(inset);
		wrap = True;
	    }
	if (buffer->size - buffer->length < length)
	    {
		buffer->size += ((length + 511) / 512) * 512;
		buffer->data = XtRealloc(buffer->data, buffer->size);
	    }
	if (wrap)
	    {
		/*
		** Totally unportable hack to demonstrate possibilities:
		** Just enclose the widget name into ctrl-a codes (see
		** what Import does when it sees ctrl-a).
		*/
		buffer->data[buffer->length] = INSET_MARK;
		strcpy(&buffer->data[buffer->length+1], data);
		buffer->data[buffer->length + length - 1] = INSET_MARK;
	    }
	else
		/*
		** To be complete, we should here QUOTE all INSET_MARK's
		** and add corresponding dequoting into paste part!
		*/
		memcpy(&buffer->data[buffer->length], data, length);
	buffer->length += length;
	return length;
    }

/*
** PasteData
**	insert data into current instert point (and process the INSET_MARK
**	"hackery").
*/
static void PasteData(w, buf, length)
Widget w;
char *buf;
int length;
    {
	char *mark;

	for (;;)
	    {
		mark = memchr(buf, INSET_MARK, length);
		if (mark == NULL)
		    {
			XeTextInsert(w, buf, length);
			break;
		    }
		XeTextInsert(w, buf, mark - buf);
		mark += 1;
		length -= (mark - buf);
		buf = mark;
		mark = memchr(buf, INSET_MARK, length);
		if (mark == NULL)
			break;
		*mark++ = '\0';
		AddInset(w, buf);
		length -= (mark - buf);
		buf = mark;
	    }
    }


/*
** Export
**	is a hooked to the X11 selection processing and allows the application
**	provide application specific conversions.
*/
static void Export(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeExportCallbackData *data = (XeExportCallbackData *)call_data;
	Display *d = XtDisplay(w);
	DataBuffer buffer;
	long start, end;

	if (data == NULL || data->reason != XeCR_EXPORT)
		return;
	/*
	** Handle only "text type" targets and leave all other targets
	** to the widget defaults..
	*/
	if (data->target != XA_STRING && data->target != XA_TEXT(d) &&
	    data->target != XA_COMPOUND_TEXT(d))
		return;
	XeTextGetSelectionPosition(w, &start, &end);
	if (start >= end)
		return;
	if (data->value)
		XtFree(data->value);

	buffer = init_DataBuffer;
	XeTextExtract(w, start, end, FeedData, (XtPointer)&buffer);
	data->value = buffer.data;
	data->length = buffer.length;
	/*
	** Just return the target type as data type (except, for generic
	** TEXT return COMPOUND_TEXT).
	*/
	if (data->target == XA_TEXT(d))
		data->type = XA_COMPOUND_TEXT(d);
	else
		data->type = data->target;
	data->format = 8;
    }


static void Import(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeImportCallbackData *data = (XeImportCallbackData *)call_data;
	Display *d = XtDisplay(w);
	char *buf, *mark;
	int length;

	if (data == NULL || data->reason != XeCR_IMPORT)
		return;

	/*
	** Deal only with STRING and COMPOUND_TEXT and leave the rest
	** of types to the defaults
	*/
	if (data->type != XA_STRING && data->type != XA_COMPOUND_TEXT(d))
		return;
	if ((length=data->length) == 0 || (buf=(char *)data->value) == NULL)
		return;
	PasteData(w, buf, length);
	/*
	** We dealt with the content (and let the widget release the data,
	** just mark it all dealt by setting length to zero).
	*/
	data->length = 0;
    }

/* ************************
** END CUT/PASTE PROCESSING
** ************************
*/

/*
** *NOTE*
**	Following externs are really just 'forward declarations'. I would
**	prefer to just use 'static', which works on gcc or hpux cc, but
**	seems to be too much for some older compilers (Apollo cc).
*/
extern UI_PanelDef popup_dialog_saveas;
extern UI_PanelDef popup_dialog_loadfile;
extern UI_PanelDef popup_dialog_insetfile;

static UI_ElementDef file_save_input[] =
    {
	UI_INPUT("Name: "),
	UI_END(),
    };

static UI_ElementDef file_load_input[] =
    {
	UI_INPUT("Name: "),
	UI_END(),
    };

static UI_ElementDef file_inset_input[] =
    {
	UI_INPUT("Name: "),
	UI_END(),
    };

static void PopdownFileDialog();

static UI_ActionDef saveas_actions[] =
    {
	{"save", PopdownFileDialog, (XtPointer)&popup_dialog_saveas},
	{"cancel"},
	{NULL},
    };

static UI_ActionDef loadfile_actions[] =
    {
	{"load", PopdownFileDialog, (XtPointer)&popup_dialog_loadfile},
	{"cancel"},
	{NULL},
    };

static UI_ActionDef insetfile_actions[] =
    {
	{"insert", PopdownFileDialog, (XtPointer)&popup_dialog_insetfile},
	{"cancel"},
	{NULL},
    };

static UI_PanelDef popup_dialog_saveas =
    {
	"dialogPanel",
	file_save_input,
	saveas_actions,
	"Save File",
    };

static UI_PanelDef popup_dialog_loadfile =
    {
	"dialogPanel",
	file_load_input,
	loadfile_actions,
	"Load File",
    };

static UI_PanelDef popup_dialog_insetfile =
    {
	"dialogPanel",
	file_inset_input,
	insetfile_actions,
	"Inset File",
    };

/*
** SaveAsFile
**	saves the widget content to a file. This does the same
**	as XeTextSaveAsFile, except the output is filtered through
**	the FeedData which does the "inset" hackery.
**
** *WARNING*
**	This is just a demonstration. The "inset" hackery just stores
**	the FILEPATH's delimited by INSERT_MARK's. The result is not
**	portable, depends on current directory etc... BEWARE! For good
**	solution, you must do more WORK!!!
*/
static int SaveAsFile(w, filename)
Widget w;
char *filename;
    {
	DataBuffer buffer;
	FILE *f;

	buffer = init_DataBuffer;

	if ((f = fopen(filename, "wb")) == NULL)
	    {
		/* ..should really pop up something instead of this.. */
		printf("Cannot open %s\n", filename);
		return False;
	    }
	XeTextExtract(w, 0L, LONG_MAX, FeedData, (XtPointer)&buffer);
	if (fwrite(buffer.data, 1, buffer.length, f) != buffer.length)
		printf("Write error on %s\n", filename);
	fclose(f);
	XtFree(buffer.data);
	return True;
    }

/*
** LoadFromFile
**	reloads content from a file. Cannot use XtNcontentFile resource
**	because want to make symmetric processing of SaveAsFile and
**	attempt to recreate the insets.
**
** *WARNING*
**	This is just a demonstration. The "inset" hackery just stores
**	the FILEPATH's delimited by INSERT_MARK's. The result is not
**	portable, depends on current directory etc... BEWARE! For good
**	solution, you must do more WORK!!!
*/
static char *LoadFromFile(w, name)
Widget w;
char *name;
    {
	Cardinal n;
	Arg args[3];
	struct stat sbuf;
	char *source = NULL;
	int fd = -1;
	XeContentFormat content_type;

	if (!name || strlen(name) == 0)
		return NULL;

	content_type = XeFindContentFormat(name);
	if (content_type != XeContentFormat_ISO2022 &&
	    content_type != XeContentFormat_UNKNOWN)
	    {
		/*
		** Attempt to load something that is obviously not a
		** text file, do implicit AddInset instead...
		*/
		AddInset(w, name);
		return NULL;
	    }
	n = 0;
	XtSetArg(args[n], XtNcontentLoaded, False); n++;
	XtSetValues(w, args, n);

	for (;;) /* Just for convenient error exits.. */
	    {
		if ((fd = open(name, O_RDONLY, 0)) < 0)
		    {
			printf("Cannot open '%s'\n", name);
			break;
		    }
		if (fstat(fd, &sbuf) < 0)
		    {
			printf("Cannot access/stat '%s'\n", name);
			break;
		    }
		if ((source = (char *)malloc(sbuf.st_size)) == NULL)
		    {
			printf("Failed to allocate memory (%d) for '%s'\n",
			       (int)sbuf.st_size, name);
			break;
		    }
		if (read(fd, source, sbuf.st_size) != sbuf.st_size)
		    {
			printf("Failed to read %d bytes from '%s'\n",
			       (int)sbuf.st_size, name);
			break;
		    }
		close(fd);
		PasteData(w, source, sbuf.st_size);
		free(source);
		return name;
	    }
	if (fd >= 0)
		close(fd);
	if (source)
		free(source);
	return NULL;
    }

/*
** PopdownFileDialog
**	a little piece of shared code to deal with completed file
**	dialogs.
*/
static void  PopdownFileDialog(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	char *filename, *s;

	if (panel && UI_GetStrings(panel, &filename, 1) > 0 && filename)
	    {
		s = filename + strlen(filename);
		while (s > filename && *--s == ' ')
			*s = 0;
		if (panel == &popup_dialog_insetfile)
		    {
			AddInset(edit_widget, filename);
			free(filename);
		    }
		else
		    {
			if (panel == &popup_dialog_loadfile)
				filename = LoadFromFile(edit_widget, filename);
			else if (SaveAsFile(edit_widget, filename))
				text_modified = False;
			if (edit_file)
				free(edit_file);
			edit_file = filename;
			SetFilenameToTitle();
		    }
	    }
	UI_Popdown(w, client_data, call_data);
    }

static void  ClearModifiedFlag(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	text_modified = False;
	UI_Popdown(w, client_data, call_data);
    }

static void SaveToFile(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (SaveAsFile(edit_widget, edit_file))
		text_modified = False;
    }

static char *GetCurrentInsertState(r)
UI_ElementDef *r;
    {
	static char *current;
	static int size;

	Arg args[1];
	Boolean state;
	char *s;
	int i;

	for (i = 0, r = insert_state; r && r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_ToggleOp:
		    case UI_RadioOp:
			if (!r->widget || !r->data)
				break;
			XtSetArg(args[0], XtNstate, &state);
			XtGetValues(r->widget, args, 1);
			if (state)
			    {
				int length = strlen((char *)r->data);

				if (i + length >= size)
				    {
					size = (size + length + 50) / 50 * 50;
					current = XtRealloc(current, size);
				    }
				strcpy(current + i, (char *)r->data);
				i += length;
			    }
			break;
		    default:
			break;
		    }
	return i > 0 ? current : NULL;
    }

static void SetInsertState(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Arg args[1];
	long start, end;
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	char *prefix = GetCurrentInsertState(panel->elements);

	XeTextInsertPrefix(panel->target, prefix, prefix ? strlen(prefix) : 0);
	/*
	** If a selection is currently active, then extract the selected
	** text away from the widget, and then replace the text with the
	** extracted text. This is rather inefficient way of getting the
	** attributes of the selected text to change as defined by the
	** input state.
	**
	** NOTE:As the selected content is effected by the currently
	**	chosen export format, some information may be lost,
	**	if the format is too simple (like string).
	*/
	XeTextGetSelectionPosition(panel->target, &start, &end);
	if (end > start)
	    {
		String value;
		DataBuffer buffer;

		buffer = init_DataBuffer;
		XeTextExtract(panel->target, start, end, FeedData,
			      (XtPointer)&buffer);
		XeTextDisableDisplay(panel->target);
		XeTextReplace(panel->target, start, end, (char *)NULL, 0);
		XeTextUnsetSelection(panel->target);
		PasteData(panel->target, buffer.data, buffer.length);
		XeTextEnableDisplay(panel->target);
		XtFree(buffer.data);
	    }
    }

static void SetTargetAndPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;

	if (panel)
	    {
		ChangePanelTarget(edit_widget, panel);
		UI_SetToggles(panel);
		UI_PopupPanel(w, client_data, call_data);
	    }
    }

extern UI_PanelDef query_reset_modified;

static UI_ActionDef query_reset_actions[] =
    {
	{"clear", ClearModifiedFlag, (XtPointer)&query_reset_modified},
	{"cancel"},
	{NULL},
    };


static UI_PanelDef query_reset_modified =
    {
	"Text has been modified--clear flag?",
	NULL,
	query_reset_actions,
    };

static void CheckForModify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (text_modified)
		UI_PopupPanel(w, (XtPointer)&query_reset_modified, call_data);
	else
		UI_PopupPanel(w, client_data, call_data);
    }

static void CheckModifyForQuit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	if (text_modified)
		UI_PopupPanel(w, (XtPointer)&query_reset_modified, call_data);
	else
		UI_Quit(w, client_data, call_data);
    }

static UI_MenuItemDef file_menu_items[] =
    {
	{"Save", SaveToFile, (XtPointer)NULL,},
	{"Save as", UI_PopupPanel, (XtPointer)&popup_dialog_saveas,},
	{"Load File", CheckForModify, (XtPointer)&popup_dialog_loadfile,},
	{"Add Inset", UI_PopupPanel, (XtPointer)&popup_dialog_insetfile,},
	{"Quit", CheckModifyForQuit, NULL},
	{NULL},
    };

static UI_MenuDef file_menu =
    {
	"File",
	file_menu_items,
    };

static UI_MenuItemDef edit_menu_items[] =
    {
	{"Character format", SetTargetAndPopup,
		 (XtPointer)&popup_insert_state,},
	{"Paragraph format", SetTargetAndPopup,
		 (XtPointer)&text_resources,},
	{"Select all", SelectAll, (XtPointer)NULL},
	{NULL},
    };

static UI_MenuDef edit_menu =
    {
	"Edit",
	edit_menu_items,
    };

static UI_MenuItemDef insert_menu_items[] =
    {
	{"Paragraph",	InsertText,	(XtPointer)"\036",},
	{"Quad left",	InsertText,	(XtPointer)"\033[0 H",},
	{"Quad center",	InsertText,	(XtPointer)"\033[2 H",},
	{"Quad right",	InsertText,	(XtPointer)"\033[4 H",},
	{"Quad Justify",InsertText,	(XtPointer)"\033[6 H",},
	{"STAB 1",	InsertText,	(XtPointer)"\033[1 ^",},
	{"STAB 2",	InsertText,	(XtPointer)"\033[2 ^",},
	{"STAB 3",	InsertText,	(XtPointer)"\033[3 ^",},
	{"STAB 4",	InsertText,	(XtPointer)"\033[4 ^",},
	{"STAB 5",	InsertText,	(XtPointer)"\033[5 ^",},
	{"STAB 6",	InsertText,	(XtPointer)"\033[6 ^",},
	{"STAB 7",	InsertText,	(XtPointer)"\033[7 ^",},
	{NULL},
    };

static UI_MenuDef insert_menu =
    {
	"Insert",
	insert_menu_items,
    };

static void WarningHandler(message)
String message;
    {
	static UI_PanelDef warning = {"Warning"};

	warning.heading = message;
	UI_PopupPanel(main_window, (XtPointer)&warning, (XtPointer)NULL);
    }

#include "fallback.c"

main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget view, widget, pane, box, button;
	Arg args[10];
	int n;
	XeContentFormat content_type;
	XeContentClass content_class;
	char *data_file;
#if X11R5
	XtSetLanguageProc(NULL, NULL, NULL);
#endif
	root_widget = XtAppInitialize(&demo_application, "Demo",
				      NULL,0, &argc, argv,
				      fallback_resources,
				      NULL, 0);
	UI_Initialize(demo_application);

	edit_file = argc > 1 ? strdup(argv[1]) : NULL;

	n = 0;
	main_window = pane = XtCreateManagedWidget
		("mainWindow", xeFrameWidgetClass, root_widget, args, n);
	n = 0;
	box = XtCreateManagedWidget
		("menuPanel", xeFrameWidgetClass, pane, args, n);
	UI_CreateMenu(box, &file_menu);
	UI_CreateMenu(box, &edit_menu);
	UI_CreateMenu(box, &insert_menu);
	n = 0;
	edit_title = XtCreateManagedWidget
		("fileName", labelWidgetClass, box, args, n);
	SetFilenameToTitle();
	XtAppSetWarningHandler(demo_application, WarningHandler);
	n = 0;
	XtSetArg(args[n], XtNallowHoriz, True); ++n;
	XtSetArg(args[n], XtNallowVert, True); ++n;
	view = XtCreateManagedWidget
		("workArea", viewportWidgetClass, pane,args, n);
	n = 0;
	content_type = XeFindContentFormat(edit_file);
	content_class = XeFindContentClass(content_type);
	/*
	** Do we really have a "Text" content?
	*/
	if ((content_class == XeContentClass_UNKNOWN ||
	     content_class == XeContentClass_TEXT) &&  edit_file)
		data_file = NULL;
	else
	    {
		data_file = edit_file;
		edit_file = NULL;
		SetFilenameToTitle();
	    }
	/*
	** Request proportional spacing, because we are not
	** specifying the lineSpacing.
	*/
	XtSetArg(args[n], XtNproportional, True); ++n;
	XtSetArg(args[n], XtNcolumnWidth, 400); ++n;
#ifdef USING_MOTIF_122
	edit_widget = XeCreateMotifTextEd("textEdit", view, args, n);
#else
	edit_widget = XtCreateManagedWidget
		("textEdit", xeTextEdWidgetClass, view, args, n);
#endif
	XtAddCallback(edit_widget, XtNnotifyCallback, Notify, (XtPointer)NULL);
	XtAddCallback(edit_widget, XtNmodifyCallback, Modify, (XtPointer)NULL);
	XtAddCallback(edit_widget, XtNexportCallback, Export, (XtPointer)NULL);
	XtAddCallback(edit_widget, XtNimportCallback, Import, (XtPointer)NULL);
	XtSetKeyboardFocus(main_window, edit_widget);
	if (edit_file)
		LoadFromFile(edit_widget, edit_file);
	if (data_file)
		AddInset(edit_widget, data_file);
	for (n = 2; n < argc; ++n)
		AddInset(edit_widget, argv[n]);
	XtRealizeWidget(root_widget);
	text_modified = False;
	XtAppMainLoop(demo_application);
	return 0;
    }
