/*
**  RTF to EuroBridge Text Widget Content Translator
** (based on rtfskel.c and uses rtf_reader.c)
**
**	A very skeletal test implementation.
*/

#include	<stdio.h>
#include	"rtf.h"


static void	UnknownClass ();
static void	GroupClass ();
static void	TextClass ();
static void	ControlClass ();

static void	Destination ();
static void	CharSet ();
static void	SpecialChar ();
static void	DocAttr ();
static void	SectAttr ();
static void	TblAttr ();
static void	ParAttr ();
static void	CharAttr ();
static void	PictAttr ();
static void	NeXTGrAttr ();
static void	FieldAttr ();
static void	TOCAttr ();
static void	PosAttr ();


int main (argc, argv)
int	argc;
char	**argv;
    {
	RTFInit ();
	
	--argc;
	++argv;
	
	/* not clever; only allows stdin or one named file to be read */
	
	if (argc > 0)
	    {
		if (freopen (argv[0], "r", stdin) == NULL)
		    {
			fprintf (stderr, "Can't open \"%s\"\n", argv[0]);
			exit (1);
		    }
	    }
	
	/* install class callbacks */
	
	RTFSetClassCallback (rtfUnknown, UnknownClass);
	RTFSetClassCallback (rtfGroup, GroupClass);
	RTFSetClassCallback (rtfText, TextClass);
	RTFSetClassCallback (rtfControl, ControlClass);
	
	/* process the input stream */
	
	RTFRead ();
	
	exit (0);
    }


/*
**  Token class callbacks
*/

static void UnknownClass ()
    {
	/* use this to print warnings about unknown tokens */
    }


static void GroupClass ()
    {
	switch (rtfMajor)
	    {
	    case rtfBeginGroup:
		/* push state */
		break;
	    case rtfEndGroup:
		/* pop state */
		break;
	    }
    }

static void TextClass ()
    {
	putchar(rtfMajor);
    }


/*
**  Process control symbol.
*/
static void ControlClass ()
    {
	switch (rtfMajor)
	    {
	    case rtfVersion:
		break;
	    case rtfDefFont:
		/*
		** rtfParam contains the default font number.  Beware
		** that there is no guarantee that this font will actually
		** be listed in the font table!
		*/
		break;
	    case rtfCharSet:
		CharSet ();
		break;
	    case rtfDestination:
		Destination ();
		break;
	    case rtfFontFamily:
		/* only occurs within font table - can ignore */
		break;
	    case rtfColorName:
		/* only occurs within color table - can ignore */
		break;
	    case rtfSpecialChar:
		SpecialChar ();
		break;
	    case rtfStyleAttr:
		/* only occurs within stylesheet - can ignore */
		break;
	    case rtfDocAttr:
		DocAttr ();
		break;
	    case rtfSectAttr:
		SectAttr ();
		break;
	    case rtfTblAttr:
		TblAttr ();
		break;
	    case rtfParAttr:
		ParAttr ();
		break;
	    case rtfCharAttr:
		CharAttr ();
		break;
	    case rtfPictAttr:
		PictAttr ();
		break;
	    case rtfNeXTGrAttr:
		NeXTGrAttr ();
		break;
	    case rtfFieldAttr:
		FieldAttr ();
		break;
	    case rtfTOCAttr:
		TOCAttr ();
		break;
	    case rtfPosAttr:
		PosAttr ();
		break;
	    }
    }


/*
** Control class major number handlers.  Each one switches on
** the minor numbers that occur within the major number.
*/
static void CharSet ()
    {
	switch (rtfMinor)
	    {
	    case rtfAnsiCharSet:
		break;
	    case rtfMacCharSet:
		break;
	    case rtfPcCharSet:
		break;
	    case rtfPcaCharSet:
		break;
	    }
    }


static void Destination ()
    {
	switch (rtfMinor)
	    {
	    case rtfPict:
		break;
	    case rtfNeXTGraphic:
		break;
	    case rtfFootnote:
		break;
	    case rtfHeader:
		break;
	    case rtfHeaderLeft:
		break;
	    case rtfHeaderRight:
		break;
	    case rtfHeaderFirst:
		break;
	    case rtfFooter:
		break;
	    case rtfFooterLeft:
		break;
	    case rtfFooterRight:
		break;
	    case rtfFooterFirst:
		break;
	    case rtfFNSep:
		break;
	    case rtfFNContSep:
		break;
	    case rtfFNContNotice:
		break;
	    case rtfInfo:
		break;
	    case rtfStyleSheet:
		/* will never occur because of default destination reader */
		break;
	    case rtfFontTbl:
		/* will never occur because of default destination reader */
		break;
	    case rtfColorTbl:
		/* will never occur because of default destination reader */
		break;
	    case rtfField:
		break;
	    case rtfFieldInst:
		break;
	    case rtfFieldResult:
		break;
	    case rtfIndex:
		break;
	    case rtfIndexBold:
		break;
	    case rtfIndexItalic:
		break;
	    case rtfIndexText:
		break;
	    case rtfIndexRange:
		break;
	    case rtfTOC:
		break;
	    case rtfBookmarkStart:
		break;
	    case rtfBookmarkEnd:
		break;
	    case rtfITitle:
		break;
	    case rtfISubject:
		break;
	    case rtfIAuthor:
		break;
	    case rtfIOperator:
		break;
	    case rtfIKeywords:
		break;
	    case rtfIComment:
		break;
	    case rtfIVersion:
		break;
	    case rtfIDoccomm:
		break;
	    }
    }


static void SpecialChar ()
    {
	switch (rtfMinor)
	    {
	    case rtfCurHeadPage:
		break;
	    case rtfCurFNote:
		putchar('\036');
		break;
	    case rtfCurHeadPict:
		break;
	    case rtfCurHeadDate:
		break;
	    case rtfCurHeadTime:
		break;
	    case rtfFormula:
		break;
	    case rtfNoBrkSpace:
		putchar(' ');
		break;
	    case rtfNoReqHyphen:
		break;
	    case rtfNoBrkHyphen:
		putchar('-');
		break;
	    case rtfPage:
	    case rtfPar:
	    case rtfSect:
		putchar('\036');
		break;
	    case rtfLine:
	    case rtfRow:
		putchar('\n');
		putchar('\r');
		break;
	    case rtfTab:
		putchar('\t');
		break;
	    case rtfCell:
		putchar(' ');
		break;
	    case rtfCurAnnot:
		break;
	    case rtfAnnotation:
		break;
	    case rtfAnnotID:
		break;
	    case rtfCurAnnotRef:
		break;
	    case rtfFNoteSep:
		putchar('\036');
		break;
	    case rtfFNoteCont:
		break;
	    case rtfColumn:
		break;
	    case rtfOptDest:
		break;
	    case rtfIIntVersion:
		break;
	    case rtfICreateTime:
		break;
	    case rtfIRevisionTime:
		break;
	    case rtfIPrintTime:
		break;
	    case rtfIBackupTime:
		break;
	    case rtfIEditTime:
		break;
	    case rtfIYear:
		break;
	    case rtfIMonth:
		break;
	    case rtfIDay:
		break;
	    case rtfIHour:
		break;
	    case rtfIMinute:
		break;
	    case rtfINPages:
		break;
	    case rtfINWords:
		break;
	    case rtfINChars:
		break;
	    case rtfIIntID:
		break;
	    }
    }


static void DocAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfPaperWidth:
		break;
	    case rtfPaperHeight:
		break;
	    case rtfLeftMargin:
		break;
	    case rtfRightMargin:
		break;
	    case rtfTopMargin:
		break;
	    case rtfBottomMargin:
		break;
	    case rtfFacingPage:
		break;
	    case rtfGutterWid:
		break;
	    case rtfDefTab:
		break;
	    case rtfWidowCtrl:
		break;
	    case rtfHyphHotZone:
		break;
	    case rtfFNoteEndSect:
		break;
	    case rtfFNoteEndDoc:
		break;
	    case rtfFNoteText:
		break;
	    case rtfFNoteBottom:
		break;
	    case rtfFNoteStart:
		break;
	    case rtfFNoteRestart:
		break;
	    case rtfPageStart:
		break;
	    case rtfLineStart:
		break;
	    case rtfLandscape:
		break;
	    case rtfFracWidth:
		break;
	    case rtfNextFile:
		break;
	    case rtfTemplate:
		break;
	    case rtfMakeBackup:
		break;
	    case rtfRTFDefault:
		break;
	    case rtfRevisions:
		break;
	    case rtfMirrorMargin:
		break;
	    case rtfRevDisplay:
		break;
	    case rtfRevBar:
		break;
	    }
    }


static void SectAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfSectDef:
		break;
	    case rtfNoBreak:
		break;
	    case rtfColBreak:
		break;
	    case rtfPageBreak:
		break;
	    case rtfEvenBreak:
		break;
	    case rtfOddBreak:
		break;
	    case rtfPageStarts:
		break;
	    case rtfPageCont:
		break;
	    case rtfPageRestart:
		break;
	    case rtfPageDecimal:
		break;
	    case rtfPageURoman:
		break;
	    case rtfPageLRoman:
		break;
	    case rtfPageULetter:
		break;
	    case rtfPageLLetter:
		break;
	    case rtfPageNumLeft:
		break;
	    case rtfPageNumTop:
		break;
	    case rtfHeaderY:
		break;
	    case rtfFooterY:
		break;
	    case rtfLineModulus:
		break;
	    case rtfLineDist:
		break;
	    case rtfLineStarts:
		break;
	    case rtfLineRestart:
		break;
	    case rtfLineRestartPg:
		break;
	    case rtfLineCont:
		break;
	    case rtfTopVAlign:
		break;
	    case rtfBottomVAlign:
		break;
	    case rtfCenterVAlign:
		break;
	    case rtfJustVAlign:
		break;
	    case rtfColumns:
		break;
	    case rtfColumnSpace:
		break;
	    case rtfColumnLine:
		break;
	    case rtfENoteHere:
		break;
	    case rtfTitleSpecial:
		break;
	    }
    }


static void TblAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfCellBordBottom:
		break;
	    case rtfCellBordTop:
		break;
	    case rtfCellBordLeft:
		break;
	    case rtfCellBordRight:
		break;
	    case rtfRowDef:
		break;
	    case rtfRowLeft:
		break;
	    case rtfRowRight:
		break;
	    case rtfRowCenter:
		break;
	    case rtfRowGapH:
		break;
	    case rtfRowHt:
		break;
	    case rtfRowLeftEdge:
		break;
	    case rtfCellPos:
		break;
	    case rtfMergeRngFirst:
		break;
	    case rtfMergePrevious:
		break;
	    }
    }


static void ParAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfParDef:
		break;
	    case rtfStyleNum:
		break;
	    case rtfQuadLeft:
		break;
	    case rtfQuadRight:
		break;
	    case rtfQuadJust:
		break;
	    case rtfQuadCenter:
		break;
	    case rtfFirstIndent:
		break;
	    case rtfLeftIndent:
		break;
	    case rtfRightIndent:
		break;
	    case rtfSpaceBefore:
		break;
	    case rtfSpaceAfter:
		break;
	    case rtfSpaceBetween:
		break;
	    case rtfInTable:
		break;
	    case rtfKeep:
		break;
	    case rtfKeepNext:
		break;
	    case rtfSideBySide:
		break;
	    case rtfPBBefore:
		break;
	    case rtfNoLineNum:
		break;
	    case rtfTabPos:
		break;
	    case rtfTabRight:
		break;
	    case rtfTabCenter:
		break;
	    case rtfTabDecimal:
		break;
	    case rtfTabBar:
		break;
	    case rtfBorderTop:
		break;
	    case rtfBorderBottom:
		break;
	    case rtfBorderLeft:
		break;
	    case rtfBorderRight:
		break;
	    case rtfBorderBar:
		break;
	    case rtfBorderBox:
		break;
	    case rtfBorderBetween:
		break;
	    case rtfBorderSingle:
		break;
	    case rtfBorderThick:
		break;
	    case rtfBorderShadow:
		break;
	    case rtfBorderDouble:
		break;
	    case rtfBorderDot:
		break;
	    case rtfBorderHair:
		break;
	    case rtfBorderSpace:
		break;
	    case rtfLeaderDot:
		break;
	    case rtfLeaderHyphen:
		break;
	    case rtfLeaderUnder:
		break;
	    case rtfLeaderThick:
		break;
	    }
    }


static void PutSGR(n)
int n;
    {
	char buf[20];
	char *s;
	sprintf(buf, "\033[%dm", n);
	for (s = buf; *s; ++s)
		putchar(*s);
    }

static void PutString(s)
char *s;
    {
	for ( ;*s; ++s)
		putchar(*s);
    }	
/*
** Several of the attributes can be turned off with param value
** of zero (e.g., \b vs. \b0), but since the value of rtfParam
** is 0 if no param is given, test the text of the token directly.
*/
static void CharAttr ()
    {
	int	turnOn = (rtfTextBuf[rtfTextLen-1] != '0');
	char	buf[20];
	
	switch (rtfMinor)
	    {
	    case rtfPlain:
		PutString("\033[ B"); /* Reset to 100% size (default) */
		PutSGR(0);
		break;
	    case rtfBold:
		PutSGR(turnOn ? 1 : 22);
		break;
	    case rtfItalic:
		PutSGR(turnOn ? 3 : 23);
		break;
	    case rtfStrikeThru:
		PutSGR(turnOn ? 9 : 29);
		break;
	    case rtfOutline:
		break;
	    case rtfShadow:
		break;
	    case rtfSmallCaps:
		break;
	    case rtfAllCaps:
		break;
	    case rtfInvisible:
		break;
	    case rtfFontNum:
		break;
	    case rtfFontSize:
		/* silly test implementation: generate relative
		** size change into current font assuming 8pt size
		** as the normal 100%. (rtfParam is 1/2pt units)
		*/
		turnOn = (rtfParam * 50 + 4) / 8;
		if (turnOn < 10)
			turnOn = 10;
		sprintf(buf, "\033[%d B", turnOn);
		PutString(buf);
		break;
	    case rtfExpand:
		break;
	    case rtfUnderline:
	    case rtfWUnderline:
		PutSGR(turnOn ? 4 : 24);
		break;
	    case rtfDUnderline:
	    case rtfDbUnderline:
		PutSGR(turnOn ? 21 : 24);
		break;
	    case rtfSuperScript:
		putchar(turnOn ? 0x8c : 0x8b);
		break;
	    case rtfNoUnderline:
		PutSGR(24);
		break;
	    case rtfSubScript:
		putchar(turnOn ? 0x8b : 0x8c);
		break;
	    case rtfRevised:
		break;
	    case rtfForeColor:
		break;
	    case rtfBackColor:
		break;
	    }
    }


static void PictAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfMacQD:
		break;
	    case rtfWinMetafile:
		break;
	    case rtfWinBitmap:
		break;
	    case rtfPicWid:
		break;
	    case rtfPicHt:
		break;
	    case rtfPicGoalWid:
		break;
	    case rtfPicGoalHt:
		break;
	    case rtfPicScaleX:
		break;
	    case rtfPicScaleY:
		break;
	    case rtfPicScaled:
		break;
	    case rtfPicCropTop:
		break;
	    case rtfPicCropBottom:
		break;
	    case rtfPicCropLeft:
		break;
	    case rtfPicCropRight:
		break;
	    case rtfPixelBits:
		break;
	    case rtfBitmapPlanes:
		break;
	    case rtfBitmapWid:
		break;
	    case rtfPicBinary:
		break;
	    }
    }


static void NeXTGrAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfNeXTGWidth:
		break;
	    case rtfNeXTGHeight:
		break;
	    }
    }


static void FieldAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfFieldDirty:
		break;
	    case rtfFieldEdited:
		break;
	    case rtfFieldLocked:
		break;
	    case rtfFieldPrivate:
		break;
	    }
    }


static void TOCAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfTOCType:
		break;
	    case rtfTOCLevel:
		break;
	    }
    }


static void PosAttr ()
    {
	switch (rtfMinor)
	    {
	    case rtfPosX:
		break;
	    case rtfPosXCenter:
		break;
	    case rtfPosXInside:
		break;
	    case rtfPosXLeft:
		break;
	    case rtfPosXOutSide:
		break;
	    case rtfPosXRight:
		break;
	    case rtfPosY:
		break;
	    case rtfPosYInline:
		break;
	    case rtfPosYTop:
		break;
	    case rtfPosYCenter:
		break;
	    case rtfPosYBottom:
		break;
	    case rtfAbsWid:
		break;
	    case rtfTextDist:
		break;
	    case rtfRPosMargV:
		break;
	    case rtfRPosPageV:
		break;
	    case rtfRPosMargH:
		break;
	    case rtfRPosPageH:
		break;
	    case rtfRPosColH:
		break;
	    }
    }
