/*
** Import module for importing JPEG/JFIF images into Xew
** internal raster format. This is based on example.c from the
** jpegsrc.v4 distribution.
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#if ANSI_INCLUDES
#	include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/RasterP.h>
#include "ImageTools.h"
#include "RasterJPEG.h"

#ifndef NO_JPEG
#include "jinclude.h"
static jmp_buf jmp;
static unsigned char *dataptr;
static struct External_methods_struct e_methods;
static XeRasterWidget rWidget;
static XeRawImage *raw = NULL;
#endif

static void RasterImportWarning(w, msg)
XeRasterWidget w;
char *msg;
    {
	XeWidgetWarningMsg
		((Widget)w, "rasterImportWarning", msg, (String *)NULL, 0);
    }

#ifndef NO_JPEG
static void output_init (cinfo)
decompress_info_ptr cinfo;
    {
	long size;
	int i;

	raw->width = cinfo->image_width;
	raw->height = cinfo->image_height;
	size = cinfo->image_width * cinfo->image_height;
	if (cinfo->quantize_colors == TRUE ||
	    cinfo->out_color_space == CS_GRAYSCALE)
	    {
		/* here it is assumed that colormap is provided also
		   for the grayscale and it can be treated as palette
		   color. watch this out! --msa */
		raw->data = (unsigned char *)XtMalloc(size);
		raw->samples_per_pixel = 1;
		raw->bits_per_sample = 8;
		raw->bits_per_component = 8;
		raw->bytes_per_line = raw->width;
		raw->class = XeImageClass_PALETTE;
		raw->num_channels = 1;
	    }
	else
	    {
		raw->data = (unsigned char *)XtMalloc(size * 3);
		raw->samples_per_pixel = 3;
		raw->bits_per_sample = 8;
		raw->bits_per_component = 8;
		raw->bytes_per_line = 3 * raw->width;
		raw->class = XeImageClass_FULLCOLOR;
		raw->num_channels = 3;
	    }
	raw->alloc_data = True;
	for (i = 0; i < raw->num_channels; ++i)
	    {
		raw->channel[i].addr = raw->data + i;
		raw->channel[i].w = raw->width;
		raw->channel[i].h = raw->height;
		raw->channel[i].inc = raw->num_channels;
		raw->channel[i].line = raw->bytes_per_line;
	    }
	if (cinfo->out_color_space == CS_YCbCr)
		raw->color_space = XeImageSpace_YCbCr;
	else
		raw->color_space = XeImageSpace_RGB;
	dataptr = raw->data;
    }

/**************************************************/
static void output_term (cinfo)
decompress_info_ptr cinfo;
    {
    }

static void put_color_map(cinfo, num_colors, colormap)
decompress_info_ptr cinfo;
int num_colors;
JSAMPARRAY colormap;
    {
	int i;
	unsigned char *r, *g, *b;
	int mapsize = (1 << raw->bits_per_sample);

	if (raw->alloc_map)
		XtFree((char *)raw->color_map); /* Release old if exists */
	raw->alloc_map = True;
	r = raw->color_map = (unsigned char *)XtMalloc(3 * mapsize);
	g = r + mapsize;
	b = g + mapsize;
	if (mapsize < num_colors) /* should really give warning --msa */
		num_colors = mapsize;
	if (cinfo->out_color_space == CS_RGB)
		for (i = 0; i < num_colors; i++)
		    {
			r[i] = GETJSAMPLE(colormap[0][i]);
			g[i] = GETJSAMPLE(colormap[1][i]);
			b[i] = GETJSAMPLE(colormap[2][i]);
		    }
	else
		for (i = 0; i < num_colors; i++)
			r[i] = g[i] = b[i] = GETJSAMPLE(colormap[0][i]);

    }

static void put_pixel_rows(cinfo, num_rows, pixel_data)
decompress_info_ptr cinfo;
int num_rows;
JSAMPIMAGE pixel_data;
    {
	JSAMPROW ptr0, ptr1, ptr2;
	long col;
	long width = cinfo->image_width;
	int row;
	
	if (cinfo->quantize_colors == TRUE ||
	    cinfo->out_color_space == CS_GRAYSCALE)
		for (row = 0; row < num_rows; row++)
		    {
			ptr0 = pixel_data[0][row];
			for (col = width; col > 0; col--)
				*dataptr++ = GETJSAMPLE(*ptr0++);
		    }
	else 
		for (row = 0; row < num_rows; row++)
		    {
			ptr0 = pixel_data[0][row];
			ptr1 = pixel_data[1][row];
			ptr2 = pixel_data[2][row];
			for (col = width; col > 0; col--) 
			    {
				*dataptr++ = GETJSAMPLE(*ptr0++);
				*dataptr++ = GETJSAMPLE(*ptr1++);
				*dataptr++ = GETJSAMPLE(*ptr2++);
			    }
		    }
    }

static void d_ui_method_selection(cinfo)
decompress_info_ptr cinfo;
    {
	/* select output colorspace & quantization parameters */
	if (cinfo->jpeg_color_space == CS_GRAYSCALE)
	    {
		cinfo->out_color_space = CS_GRAYSCALE;
		cinfo->two_pass_quantize = FALSE;
		cinfo->quantize_colors = TRUE;
	    }
	else if (rWidget->raster.color_quantize == XeColorQuantize_JPEG)
	    {
		cinfo->out_color_space = CS_RGB;
		cinfo->quantize_colors = TRUE;
		cinfo->two_pass_quantize = TRUE;
	    }
	else
	    {
		cinfo->out_color_space = CS_RGB;
		cinfo->quantize_colors = FALSE;
		cinfo->two_pass_quantize = FALSE;
	    }
	cinfo->desired_number_of_colors =
		rWidget->basic.max_colors > 256 ?
			256 : rWidget->basic.max_colors;
	cinfo->methods->output_init = output_init;
	cinfo->methods->put_color_map = put_color_map;
	cinfo->methods->put_pixel_rows = put_pixel_rows;
	cinfo->methods->output_term = output_term;
    }

static void JPEG_Message (msgtext)
char *msgtext;
    {
	XeWidgetWarningMsg
		((Widget)rWidget, "rasterImportWarning", msgtext,
		 (String *)&e_methods.message_parm[0], 8);
    }

static void JPEG_Error (msgtext)
char *msgtext;
    {
	XeWidgetWarningMsg
		((Widget)rWidget, "rasterImportWarning", msgtext,
		 (String *)&e_methods.message_parm[0], 8);
	(*e_methods.free_all) ();	/* clean up memory allocation */
	longjmp(jmp, 1);
    }

/*
** Should never actually occur...
*/
static int JPEG_read(cinfo)
struct Decompress_info_struct *cinfo;
    {
	RasterImportWarning((Widget)rWidget, "Premature EOF in JPEG Data.");
	cinfo->next_input_byte[0] = (char) 0xFF;
	cinfo->next_input_byte[1] = (char) 0xD9; /* EOI marker */
	cinfo->bytes_in_buffer = 2;
	return JGETC(cinfo);
    }

#endif

/*
** XeImport_JPEG
**
*/
XeRawImage *XeImport_JPEG(w)
XeRasterWidget w;
    {
#ifdef NO_JPEG
	RasterImportWarning(w, "JPEG support not compiled.");
	return NULL;
#else
	struct Decompress_info_struct    cinfo;
	struct Decompress_methods_struct dc_methods;
	XeDataContent content;

	_XeOpenContent((XeBasicWidget)w, &content);
	rWidget = w;
	raw = _XeCreateRawImage(3); /* Prepare for 3 channels */
	
	dataptr = NULL;

	/* Set up longjmp for error recovery out of JPEG_Error */
	if (setjmp(jmp))
		goto import_failed;
	cinfo.output_file = NULL;	/* no output file */
	
	/* Initialize the system-dependent method pointers. */
	cinfo.methods  = &dc_methods;
	cinfo.emethods = &e_methods;
	e_methods.error_exit = JPEG_Error; /* provide my own error rtns */
	e_methods.trace_message = JPEG_Message; /* provide my own message */
	e_methods.trace_level = 0; /* no tracing */
	e_methods.num_warnings = 0; /* no warnings emitted yet */
	e_methods.first_warning_level = 0;/* display first corrupted data warning */
	e_methods.more_warning_level = 3;/* but suppress additional ones */
	jselmemmgr(&e_methods);	/* memory allocation routines */
	dc_methods.d_ui_method_selection = d_ui_method_selection;
	
	/* Set up default JPEG parameters. */
	if (!content.type)
	    {
		cinfo.input_file = NULL;
		j_d_defaults(&cinfo, FALSE);
		cinfo.input_buffer = content.source.string;
		cinfo.bytes_in_buffer = content.length;
		cinfo.next_input_byte = content.source.string;
		cinfo.methods->read_jpeg_data = JPEG_read;
	    }
	else if (content.source.stream)
	    {
		cinfo.input_file = content.source.stream;
		j_d_defaults(&cinfo, TRUE);
	    }
	else
	    {
		RasterImportWarning(w, "No JPEG content specified.");
		goto import_failed;
	    }
	cinfo.desired_number_of_colors = 256;

	/* Set up to read a JFIF or baseline-JPEG file. */
	jselrjfif(&cinfo);
	
	jpeg_decompress(&cinfo);
	_XeCloseContent(&content);
	return raw;
	/*
	** Import failed, cleanup
	*/
    import_failed:
	_XeDestroyRawImage(raw);
	_XeCloseContent(&content);
	return NULL;
#endif
    }

