#ifndef _XewFrameSupport_h
#define _XewFrameSupport_h
/*
** Copyright 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Frame.h>

/*
** Some resources are actually realized as small arrays. The following
** constants are used in indexing them:
**
**	border		trailing, leading, right, left
**	offset		trailing, leading, right, left
**	separation	trailing, leading, center/right left
**
**	shadow_contrast	top, bottom
**
**	dimensions	horizontal, vertical
**	position	horizontal, vertical
*/
#define FRAME_TRAILING 0
#define FRAME_LEADING 1
#define FRAME_RIGHT 2
#define FRAME_CENTER 2
#define FRAME_LEFT 3

#define FRAME_TOP 0
#define FRAME_BOTTOM 1

#define FRAME_HORIZONTAL 0
#define FRAME_VERTICAL 1

/*
** FRAME_NO_PIXEL
**	is used in constraint border_pixel[i] to indicate that
**	core.border_pixel value should be used. This value should be such
**	that XAllocColor never returns it as pixel. [If this value happens
**	to be a valid pixel, the color will not be shown, and it is never
**	released, if allocated]
*/
#define FRAME_NO_PIXEL	~((unsigned long)0)

/*
** XeFrameExtents
**	a structure which describes the extents of the child widget
*/
typedef struct XeFrameExtents
    {
	Dimension width, height;/* Total enclosing rectangle */
	XRectangle border;	/* Frame Borders included, relative to total */
	XRectangle window;	/* X Window, core.border_widths included! */
    } XeFrameExtents;

/*
** Private XeFrameBorderP adds an pixel value to the structure
*/
typedef struct XeFrameBorderP
    {
	XeFrameBorder value;	/* Actual resource value */
	Pixel pixel;		/* Internal private info */
    } XeFrameBorderP;

/*
** XeFrame constraint record
*/
typedef struct _XeFrameConstraintsPart
    {
	/* Resources */
	XeFrameBorderP border[4];	/* trailing, leading, right, left */
	Boolean invert_shadow;		/* Invert shadow borders */
	int shadow_contrast[2];		/* top, bottom */
	XeFrameDimension dimension[2];	/* horizontal, vertical */
	XeFrameAlignment alignment;
	XeFramePosition position;
	int offset[4];		/* trailing, leading, right, left */
	int separation[4];	/* trailing, leading, center/right, left */
	/* Private part */
    } XeFrameConstraintsPart;

typedef struct _XeFrameConstraintsRec
    {
	XeFrameConstraintsPart frame;
    } XeFrameConstraintsRec, *XeFrameConstraints;


_XFUNCPROTOBEGIN

void _XeFrameConverters();

/*
** _XeFrameSetValues
**	adjusts XeFrameContstraints record and returns non-zero value
**	if the changes need futher processing by the parent. The value
**	is a bitmask giving out some more information about the changes
**
**	XeFrameSetValues_FRAMING
**		is set, if only the framing attributes (border) were
**		changed in a way that does not require new layout.
**	XeFrameSetValues_GEOMETRY
**		is set, if the geometry has been changed. This requires
**		a new layout computation from the parent.
*/
#define XeFrameSetValues_FRAMING 1
#define XeFrameSetValues_GEOMETRY 2

int _XeFrameSetValues
	(
#if NeedFunctionPrototypes
	 Widget,	/* old */
	 Widget,	/* request */
	 Widget,	/* set */
	 ArgList,	/* args */
	 Cardinal *	/* num_args */
#endif
	 );

void _XeFrameInitialize
	(
#if NeedFunctionPrototypes
	 Widget,	/* Request */
	 Widget		/* init */
#endif
	 );

void _XeFrameDestroy
	(
#if NeedFunctionPrototypes
	 Widget		/* Child */
#endif
	 );

GC _XeFrameCreateGC
	(
#if NeedFunctionPrototypes
	 Widget,		/* Widget */
	 XeFrameBorderP *,	/* Attributes currently matching GC */
	 XeFrameBorderP *,	/* Actual Borders */
	 int,			/* Number of Borders */
	 int *			/* shadow_contrast values (TOP, BOTTOM) */
#endif
	 );

void _XeFrameFreeGC
	(
#if NeedFunctionPrototypes
	 Widget,		/* Widget */
	 GC,			/* Graphics Context to free */
	 XeFrameBorderP *,	/* Actual Borders (for releasing colors) */
	 int			/* Number of Borders */
#endif
	 );

void _XeDrawBorderRectangle
	(
#if NeedFunctionPrototypes
	 Widget,		/* Widget where drawing occurs */
	 GC,			/* Graphic context */
	 XeFrameBorderP *,	/* Graphic Context State info */
	 int, int, int, int,	/* x, y, width, height */
	 XeFrameBorderP *,	/* left border attributes */
	 XeFrameBorderP *,	/* right border attributes */
	 XeFrameBorderP *,	/* top border attributes */
	 XeFrameBorderP *,	/* bottom border attributes */
	 int			/* invert shadows (if non-zero) */
#endif
	 );

void _XeDrawOwnBorder
	(
#if NeedFunctionPrototypes
	 Widget,		/* Self */
	 GC,			/* Border Drawing GC */
	 XeFrameBorderP *,	/* State of the Border GC */
	 XeFrameBorderP *,	/* left */
	 XeFrameBorderP *,	/* right */
	 XeFrameBorderP *,	/* top */
	 XeFrameBorderP *,	/* bottom */
	 int			/* invert shadows (if non-zero) */
#endif
	 );

void _XeDrawChildBorder
	(
#if NeedFunctionPrototypes
	 Widget,		/* Self */
	 GC,			/* Border Drawing GC */
	 XeFrameBorderP *,	/* State of the Border GC */
	 Widget,		/* Child */
	 XeFrameBorderP *,	/* left */
	 XeFrameBorderP *,	/* right */
	 XeFrameBorderP *,	/* top */
	 XeFrameBorderP *,	/* bottom */
	 int			/* invert shadows (if non-zero) */
#endif
	 );

Boolean _XeChangeBorderColor
	(
#if NeedFunctionPrototypes
	 Widget,		/* Self */
	 XeFrameBorderP *,	/* Old Border Color Specification */
	 XeFrameBorderP *,	/* New Border Color Specification */
	 int,			/* Edge number (left, right, ...) */
	 int *,			/* Old shadow contrast (top, bottom) */
	 int *			/* New shadow contrast (top, bottom) */
#endif
	 );

void _XeFrameExtents
	(
#if NeedFunctionPrototypes
	 Widget,		/* Child Widget */
	 int,			/* Assumed Window width */
	 int,			/* Assumed Window height */
	 XeFrameExtents *	/* Return information */
#endif
	 );

void _XeFrameQueryExtents
	(
#if NeedFunctionPrototypes
	 Widget,		/* Child Widget */
	 int,			/* Width default for 'max', if non-zero */
	 int,			/* Height default for 'max', if non-zero */
	 XeFrameExtents *	/* Return information */
#endif
	 );

_XFUNCPROTOEND
#endif

