/*
** mamtest.c
**	Simple test program for
**		- MamOpenFolder/MamNextMessage/MamCloseFolder
**		- MamLoadMessage & MamSaveMessage
**		- MamCopyMessage
**		- MamMoveMessage
*/
#include <stdio.h>
#include <errno.h>
#include "Mam.h"

static char *ErrorMsg(int result)
    {
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char buf[100];

	if (result < 0 || result >= sys_nerr)
	    {
		sprintf(buf, "MamError=%d", result);
		return buf;
	    }
	else if (result > 0)
		return sys_errlist[result];
	else
		return "No Error";
    }

int main(int argc, char *argv[])
    {
	Message msg;
	int move = 0, copy = 0, n = 0, mime = 0, result;
	char *old = NULL, *new = NULL;

	while (++n < argc)
		if (strcmp(argv[n], "-move") == 0)
			move = 1;
		else if (strcmp(argv[n], "-copy") == 0)
			copy = 1;
		else if (strcmp(argv[n], "-mime") == 0)
			mime = 1;
		else if (*argv[n] == '-')
			break;
		else if (old == NULL)
			old = argv[n];
		else if (new == NULL)
			new = argv[n];
		else
			break;
	if (n < argc || (move+copy+mime > 1))
	    {
		printf("Usage: mamtest [(-copy | -move | -mime)] old new\n");
		printf("   or: mamtest dirname\n");
		exit(1);
	    }
	if (new == NULL && !mime)
	    {
		char *dirname = old ? old : ".";
		char *name;
		MamFolder fdr;

		printf("\"eurobridge/message\"'s in directory \"%s\":\n",
		       dirname);
		for (fdr=MamOpenFolder(dirname,(MamFilter)NULL,(void *)NULL);
		     (name = MamNextMessage(fdr)) != NULL;)
			printf("\t%s\n", name);
		MamCloseFolder(fdr);
		exit(0);
	    }
	if (move)
	    {
		if ((result = MamMoveMessage(old,new)) != 0)
		    {
			printf("Move %s %s failed (%s).\n",
			       old, new, ErrorMsg(result));
			exit(1);
		    }
	    }
	else if (copy)
	    {
		if ((result = MamCopyMessage(old,new)) != 0)
		    {
			printf("Copy %s %s failed (%s)\n.",
			       old, new, ErrorMsg(result));
			exit(1);
		    }
	    }
	else
	    {
		if ((msg = MamLoadMessage(old)) == NULL)
		    {
			printf("Failed loading message '%s'.\n", old);
			exit(1);
		    }
		if ((result = (mime ? MamMimeMessage(new, msg) :
			       MamSaveMessage(new, msg))) != 0)
		    {
			printf("Error in writing message '%s' (%s).\n",
			       new?new:"", ErrorMsg(result));
			exit(1);
		    }
	    }
	exit(0);
    }

