/*
** HeaderExt.c
**	This module contains the basic routines to parse
**	the Message Header Extensions for Non-ASCII Text (RFC 1522)
**
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <string.h>
#include <ctype.h>
#include "HeaderExt.h"
#include "MamCoding.h"

static char *charset_mapping[] =
    {
	/* charset */	/* invoke */	/* restore */
	"iso-8859-1",	"",		NULL,
	"iso-8859-2",	"\033.B",	"\033.A",
	"iso-8859-5",	"\033.L",	"\033.A",
	"iso-8859-6",	"\033.G",	"\033.A",
	"iso-8859-7",	"\033.F",	"\033.A",
	"iso-8859-8",	"\033.H",	"\033.A",
	"iso-2022-jp",	"\033(J",	"\033(B",
	NULL,		NULL,		NULL,
    };

/*
** ConvertHeaderExtension
**	Convert a string given in RFC 1522 format into binary ISO 2022
**	stream. This function assumes that the header is already presented
**	as single NUL terminated line (if it makes any difference).
**
**	The conversion is made into an internal static buffer. The caller
**	must use the content before calling this function again.
*/
char *ConvertHeaderExtension(field)
char *field;
    {
	static char buf[2000];	/* Current Internal Buffer */
	char *r, *s, *start, *end, *word, *charset, *encoding, *invoke, **map;

	if (field == NULL)
		return "";
	s = buf;
	r = field;
	while ((r = strchr(r, '=')) != NULL)
	    {
		start = r;
		if (*++r != '?')
			continue;	/* Not a valid start, look forward */
	        charset = ++r;		/* charset begin */
		r = strchr(r, '?');	/* look for charset end */
		if (r == NULL)
			break;
		encoding = ++r;		/* encoding */
		r = strchr(r, '?');
		if (r == NULL)
			break;
		word = ++r;		/* word begin */
		r = strchr(r, '?');
		if (r == NULL)
			break;
		end = r;
		if (*++r != '=')
			continue;	/* bad ending, search more */
		++r;
		/*
		** A correctly framed "encoded word" has been found,
		** try to convert it into ISO 2022 stream.
		*/
		for (invoke = s; *charset != '?'; ++charset)
			*invoke++ = 
				isupper(*charset)?tolower(*charset):*charset;
		*invoke = 0;
		for (map = charset_mapping; *map; map += 3)
			if (strcmp(s, map[0]) == 0)
				break;
		if ((invoke = map[1]) == NULL)
			continue;	/* no conversion */

		/* Copy preceding stuff up to mark */

		while (field < start)
			*s++ = *field++;
		/*
		** Copy ISO 2022 sequence
		*/
		while (*invoke)
			*s++ = *invoke++;

		/* Copy the word into output and convert on spot */

		start = s;
		while (word < end)
			*s++ = *word++;
		if (*encoding == 'B' || *encoding == 'b')
			s = start + Mam_from64((unsigned char *)start,
					       (unsigned char *)s);
		else
			s = start + Mam_fromqp((unsigned char *)start,
					       (unsigned char *)s);

		/* Restore the default ISO 2022 state */

		if ((invoke = map[2]) != NULL)
			while (*invoke)
				*s++ = *invoke++;
		field = r;
	    }
	/*
	** Copy the tail end
	*/
	while (*field)
		*s++ = *field++;
	*s = 0;
	return buf;
    }


