#ifndef tables_h
#define tables_h
/*
** tables.h
**
**	This file works in two ways. If included normally, it will just
**	generate "typedef enum {} xxx;" definitions.
**
**	If ENUM_TABLE_GENERATION is defined, if will generate the matching
**	STORAGE_CLASS "char *string_<typename>[] =  {...};" definitions.
**
**	A typical use would be:
**
**	#include "tables.h"	-- get enum definitions.
**	...
**	... one file will declare the string arrays, it will use following
**	...
**	#undef tables_h		-- force reinclude
**  #define I_OWN_TABLES  -- i.e. I will allocate the strings 
**	#define ENUM_TABLE_GENERATION
**	#include "tables.h"
**	...
**	... if file needs the string arrays, but not to alloc them, it uses
**	...
**	#undef tables_h		-- force reinclude
**  #undef I_OWN_TABLES  -- stop private alloc
**	#define ENUM_TABLE_GENERATION
**	#include "tables.h"
**	...
*/
#ifndef CAT
#define CONCAT(a,b) a ## b	/* ANSI way of concatenation! */
#define CAT(a,b) CONCAT(a,b)
#endif

#undef ENUM_TABLE_BEGIN
#undef ENUM_TABLE_END
#undef ENUM_SYMBOL
#ifndef ENUM_TABLE_GENERATION
#	define ENUM_TABLE_BEGIN(x) typedef enum {
#	define ENUM_SYMBOL(x,y) x,
#	define ENUM_TABLE_END(x) CAT(x,_max)} x;
#else
#	ifndef I_OWN_TABLES
#		define ENUM_TABLE_BEGIN(x) extern char *CAT(string_,x)[];
#		define ENUM_SYMBOL(x,y) 
#		define ENUM_TABLE_END(x) 
#	else
#		define ENUM_TABLE_BEGIN(x) char *CAT(string_,x)[] = {
#		define ENUM_SYMBOL(x,y) y,
#		define ENUM_TABLE_END(x) NULL };
#	endif
#endif
ENUM_TABLE_BEGIN(HdrKeys)
	ENUM_SYMBOL(RFC822_DATE, "date:")
	ENUM_SYMBOL(RFC822_MSG_ID, "message-id:")
	ENUM_SYMBOL(RFC822_FROM, "from:")
	ENUM_SYMBOL(RFC822_SENDER, "sender:")
	ENUM_SYMBOL(RFC822_TO, "to:")
	ENUM_SYMBOL(RFC822_SUBJECT, "subject:")
	ENUM_SYMBOL(RFC822_COMMENTS, "comments:")
	ENUM_SYMBOL(RFC822_KEYWORDS, "keywords:")
	ENUM_SYMBOL(RFC822_CC, "cc:")
	ENUM_SYMBOL(RFC822_BCC, "bcc:")
	ENUM_SYMBOL(RFC822_IN_REPLY_TO, "in-reply-to:")
	ENUM_SYMBOL(RFC822_RELATED_MSG, "references:")
	ENUM_SYMBOL(RFC822_REPLY_TO, "reply-to:")
	ENUM_SYMBOL(RFC822_IMPORTANCE, "importance:")
	ENUM_SYMBOL(RFC822_SENSITIVITY, "sensitivity:")
	ENUM_SYMBOL(RFC822_MIME, "mime-version:")
	ENUM_SYMBOL(RFC822_CONT_TYPE, "content-type:")
	ENUM_SYMBOL(RFC822_CONT_DESCRIPTION, "content-description:")
	ENUM_SYMBOL(RFC822_CONT_ENCODING, "content-transfer-encoding:")
	ENUM_SYMBOL(RFC822_CONT_ID, "content-id:")
	ENUM_SYMBOL(RFC822_BOUNDARY, "--")
ENUM_TABLE_END(HdrKeys)

ENUM_TABLE_BEGIN(SubType)
	ENUM_SYMBOL(ST_unknown,		"x-unknown")
	ENUM_SYMBOL(ST_octet_stream,	"octet-stream")
	ENUM_SYMBOL(ST_postscript,	"postscript")
	ENUM_SYMBOL(ST_ODA,		"oda")
	ENUM_SYMBOL(ST_basic,		"basic")
	ENUM_SYMBOL(ST_compressed,	"compressed")
	ENUM_SYMBOL(ST_plain,		"plain")
	ENUM_SYMBOL(ST_richtext,	"richtext")
	ENUM_SYMBOL(ST_enriched,	"enriched")
	ENUM_SYMBOL(ST_xfig,		"xfig")
	ENUM_SYMBOL(ST_cgm,		"cgm")
	ENUM_SYMBOL(ST_jpeg,		"jpeg")
	ENUM_SYMBOL(ST_gif,		"gif")
	ENUM_SYMBOL(ST_tiff,		"tiff")
	ENUM_SYMBOL(ST_pbm,		"pbm")
	ENUM_SYMBOL(ST_pgm,		"pgm")
	ENUM_SYMBOL(ST_xwd,		"xwd")
	ENUM_SYMBOL(ST_rfc822,		"rfc822")
	ENUM_SYMBOL(ST_partial,		"partial")
	ENUM_SYMBOL(ST_external,	"external-body")
	ENUM_SYMBOL(ST_mixed,		"mixed")
	ENUM_SYMBOL(ST_alternative,	"alternative")
	ENUM_SYMBOL(ST_digest,		"digest")
	ENUM_SYMBOL(ST_parallel,	"parallel")
	ENUM_SYMBOL(ST_mpeg,		"mpeg")
	ENUM_SYMBOL(ST_h261,		"h261")
	ENUM_SYMBOL(ST_xvideo,		"xvideo")
	ENUM_SYMBOL(ST_maker,		"x-framemaker")
ENUM_TABLE_END(SubType)

ENUM_TABLE_BEGIN(ContType)
    ENUM_SYMBOL(CT_unknown,		"x-unknown")
    ENUM_SYMBOL(CT_application,	"application")
	ENUM_SYMBOL(CT_audio,		"audio")
	ENUM_SYMBOL(CT_text,		"text")
    ENUM_SYMBOL(CT_structuredImage,	"x-image")
	ENUM_SYMBOL(CT_rasterImage,	"image")
    ENUM_SYMBOL(CT_message,		"message")
    ENUM_SYMBOL(CT_multipart,	"multipart")
	ENUM_SYMBOL(CT_video,		"video")
	ENUM_SYMBOL(CT_extension,	"extension")
ENUM_TABLE_END(ContType)

ENUM_TABLE_BEGIN(Params)
	ENUM_SYMBOL(Param_Charset, "charset")
	ENUM_SYMBOL(Param_Boundary, "boundary")
	ENUM_SYMBOL(Param_PartNumber, "number")
	ENUM_SYMBOL(Param_PartTotal, "total")
	ENUM_SYMBOL(Param_ID, "id")
	ENUM_SYMBOL(Param_FileName, "name")
	ENUM_SYMBOL(Param_FileSize, "size")
	ENUM_SYMBOL(Param_DirName, "directory")
	ENUM_SYMBOL(Param_AccessType, "access-type")
	ENUM_SYMBOL(Param_AccessMode, "mode")
	ENUM_SYMBOL(Param_SiteAddress, "site")
	ENUM_SYMBOL(Param_ExpiresAt, "expiration")
	ENUM_SYMBOL(Param_ODAProfile, "profile")
ENUM_TABLE_END(Params)

ENUM_TABLE_BEGIN(Charset)
    ENUM_SYMBOL(CS_unknown,		"x-unknown")
    ENUM_SYMBOL(CS_us_ascii,	"us-ascii")
    ENUM_SYMBOL(CS_iso8859_1,	"iso-8859-1")
    ENUM_SYMBOL(CS_iso8859_2,	"iso-8859-2")
    /* iso8859-3 and iso8859-4 are obsolete */
    ENUM_SYMBOL(CS_iso8859_5,	"iso-8859-5")
	ENUM_SYMBOL(CS_iso8859_6,	"iso-8859-6")
    ENUM_SYMBOL(CS_iso8859_7,	"iso-8859-7")
	ENUM_SYMBOL(CS_iso8859_8,	"iso-8859-8")
    ENUM_SYMBOL(CS_iso8859_9,	"iso-8859-9")
ENUM_TABLE_END(Charset)

ENUM_TABLE_BEGIN(Encoding)
	ENUM_SYMBOL(ENC_undefined,	"x-undefined")
	ENUM_SYMBOL(ENC_base64,		"base64")
    ENUM_SYMBOL(ENC_quotedPrintable,"quoted-printable")
    ENUM_SYMBOL(ENC_eightBit,	"8bit")
    ENUM_SYMBOL(ENC_sevenBit,	"7bit")
	ENUM_SYMBOL(ENC_binary,		"binary")
ENUM_TABLE_END(Encoding)

ENUM_TABLE_BEGIN(EBFileType)
	ENUM_SYMBOL(EB_unknown,	"eurobridge/unknown")
	ENUM_SYMBOL(EB_message,	"eurobridge/message")
	ENUM_SYMBOL(EB_folder,	"eurobridge/folder")
ENUM_TABLE_END(EBFileType)

/* 
   Note: the next two tables define RFC-822 header
   extension fields, defined in RFC 1148, "Mapping 
   between X.400(88) and 822"
*/
ENUM_TABLE_BEGIN(Importance)
	ENUM_SYMBOL(IMP_low, "low")
	ENUM_SYMBOL(IMP_normal, "normal")
	ENUM_SYMBOL(IMP_high, "high")
ENUM_TABLE_END(Importance)

ENUM_TABLE_BEGIN(Sensitivity)
	ENUM_SYMBOL(SENS_personal, "personal")
	ENUM_SYMBOL(SENS_private, "private")
	ENUM_SYMBOL(SENS_companyConfidential, "company-confidential")
ENUM_TABLE_END(Sensitivity)

/*
   Note: the next two tables define parts of the external-reference fields.
   They are included for compat with Abstract Structure... 
*/
ENUM_TABLE_BEGIN(AccessType)
	ENUM_SYMBOL(ACS_localFile, "local-file")
	ENUM_SYMBOL(ACS_ftp, "ftp")
	ENUM_SYMBOL(ACS_ftam, "x-ftam")
	ENUM_SYMBOL(ACS_anonFtp, "anon-ftp")
	ENUM_SYMBOL(ACS_anonFtam, "x-anon-ftam")
ENUM_TABLE_END(AccessType)

ENUM_TABLE_BEGIN(TransferParam)
	ENUM_SYMBOL(TX_binary, "image") 
	ENUM_SYMBOL(TX_sevenBit, "ascii")
ENUM_TABLE_END(TransferParam)
#endif

