/* $Id: scrolldemo.c,v 1.2 1999/04/30 22:47:59 falk Rel $
 *
 * Test program for Scrollbar2 widget.
 *
 * Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
 * software.  Source code is freely distributable provided that my name
 * is not removed from it.
 *
 * The X Consortium, and any party obtaining a copy of these files
 * from the X Consortium, directly or indirectly, is granted, free of
 * charge, a full and unrestricted irrevocable, world-wide, paid up,
 * royalty-free, nonexclusive right and license to deal in this
 * software and documentation files (the "Software"), including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and sell copies of the Software, and to
 * permit persons who receive copies from any such party to do so.
 */

#include <stdio.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#ifdef	COMMENT
#include <X11/Core.h>
#include <X11/Object.h>
#endif	/* COMMENT */
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>

#include "Scrollbar2.h"


	/* Xt stuff */

static	XtAppContext	app_ctx ;

static	Widget	topLevel ;
static	Widget	mainPanel ;
static	Widget	report ;

static String fallback[] = {
	"*borderWidth:	0",

	"*scrollbarLbl.label:	Scrollbar",
	"*scrollbarDemo.length:	200",
	"*scrollbarDemo.orientation: horizontal",
	"*scrollbarDemo.shown:	.3",

	"*report.width:		200",
	"*report.justify:	Left",
	"*report.borderWidth:	1",

	"*scrollbarLbl.fromVert:	report",

	"*scrollbarDemo.fromVert: scrollbarLbl",
	NULL
};

static	void	Scroll2CB(Widget cmd, XtPointer client, XtPointer call_data) ;
static	void	JumpCB(Widget cmd, XtPointer client, XtPointer call_data) ;


int
main(int argc, char **argv)
{
	Widget	lbl ;
	Widget	sb ;

	/* this could all be done with a single call to XtAppInitialize(),
	 * but I'm spelling it out for illustration purposes.
	 */

	topLevel = XtAppInitialize(&app_ctx, "Scrolldemo", NULL,0,
		&argc, argv, fallback, NULL,0) ;

	/* now create the widgets.  Most resources will come from the
	 * resource file rather than being hard-coded.
	 */

	mainPanel = XtVaCreateManagedWidget("mainPanel",
		formWidgetClass, topLevel,
		0) ;

	report = XtVaCreateManagedWidget("report", labelWidgetClass, mainPanel,
		XtNlabel, "",
		0) ;

	lbl = XtCreateManagedWidget("scrollbarLbl", labelWidgetClass,
		mainPanel, NULL, 0) ;
	sb = XtCreateManagedWidget("scrollbarDemo", scrollbar2WidgetClass,
		mainPanel, NULL,0) ;

	XtAddCallback(sb, XtNscrollProc, Scrollbar2Callback, NULL) ;
	XtAddCallback(sb, XtNcallback, Scroll2CB, NULL) ;
	XtAddCallback(sb, XtNjumpProc, JumpCB, NULL) ;


	XtRealizeWidget(topLevel) ;

	XtAppMainLoop(app_ctx) ;


	exit(0) ;
}



	/* Gotcha: changing the label of the "report" widget will change
	 * its size, which we don't want.  Work around this by disabling
	 * changes to this item until after widgets are realized, at
	 * which time the report's parent widget will lock down the size.
	 */

static	void
setReport(String str)
{
	XtVaSetValues(report, XtNlabel, str, 0) ;
}





static	void
Scroll2CB(Widget sb, XtPointer client, XtPointer call_data)
{
static	char	line[128] ;
	Scrollbar2Rep *rep = (Scrollbar2Rep *)call_data ;

	switch( rep->what ) {
	  case SC_START:
	    setReport("Begin scroll") ;
	    break ;

	  case SC_DONE:
	    sprintf(line, "Scrolled to %.2f", rep->top) ;
	    setReport(line) ;
	    break ;

	  case SC_JUMP:
	    sprintf(line, "Jump to %.2f", rep->top) ;
	    setReport(line) ;
	}
}


	/* called when user drags slider */

static	void
JumpCB(Widget sb, XtPointer client, XtPointer posn)
{
static	char	line[128] ;
	float	top ;

	top = *(float *)posn ;
	sprintf(line, "Scroll to %.2f", top) ;
	setReport(line) ;
}
