/* $Id: Scrollbar2P.h,v 1.3 1999/04/30 22:47:59 falk Rel $
 *
 * Scrollbar2P.h - Private definitions for Scrollbar2 widget
 *
 * Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
 * software.  Source code is freely distributable provided that my name
 * is not removed from it.
 *
 * The X Consortium, and any party obtaining a copy of these files
 * from the X Consortium, directly or indirectly, is granted, free of
 * charge, a full and unrestricted irrevocable, world-wide, paid up,
 * royalty-free, nonexclusive right and license to deal in this
 * software and documentation files (the "Software"), including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and sell copies of the Software, and to
 * permit persons who receive copies from any such party to do so.
 */

#ifndef _Scrollbar2P_h
#define _Scrollbar2P_h

#include "Scrollbar2.h"
#include <ScrollbarP.h>

typedef struct {
    /* resources */
    float	arrowJump ;	/* amount to move for arrow clicks */
    XtCallbackList notifyProc;	/* call with report structure */
} Scrollbar2Part;

typedef struct _Scrollbar2Rec {
    CorePart		core;
    SimplePart		simple;
#ifdef	_ThreeDP_h
    ThreeDPart		threeD;
#endif
    ScrollbarPart	scrollbar;
    Scrollbar2Part	scrollbar2;
} Scrollbar2Rec;

typedef struct {XtPointer extension;} Scrollbar2ClassPart;

typedef struct _Scrollbar2ClassRec {
    CoreClassPart		core_class;
    SimpleClassPart		simple_class;
#ifdef	_ThreeDP_h
    ThreeDClassPart		threeD_class;
#endif
    ScrollbarClassPart		scrollbar_class;
    Scrollbar2ClassPart		scrollbar2_class;
} Scrollbar2ClassRec;

extern Scrollbar2ClassRec scrollbar2ClassRec;


#endif /* _Scrollbar2P_h */
